/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.plugins.context.AbstractURLHandler;
import org.jboss.virtual.plugins.context.DelegatingHandler;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.plugins.context.file.FileSystemContext;
import org.jboss.virtual.plugins.vfs.helpers.PathTokenizer;
import org.jboss.virtual.spi.LinkInfo;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VFSContextFactory;
import org.jboss.virtual.spi.VFSContextFactoryLocator;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkHandler
extends AbstractURLHandler
implements StructuredVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private List<LinkInfo> links;
    private HashMap<String, VirtualFileHandler> linkTargets = new HashMap(3);

    public LinkHandler(FileSystemContext context, VirtualFileHandler parent, URI uri, String name, List<LinkInfo> links) throws IOException, URISyntaxException {
        super(context, parent, uri.toURL(), name);
        this.links = links;
        for (LinkInfo link : links) {
            String atom;
            int n;
            String linkName = link.getName();
            if (linkName == null) {
                linkName = VFSUtils.getName(link.getLinkTarget());
            }
            if (linkName == null) continue;
            String[] paths = PathTokenizer.getTokens(linkName);
            VirtualFileHandler linkParent = this;
            for (n = 0; n < paths.length - 1; ++n) {
                atom = paths[n];
                try {
                    linkParent = linkParent.findChild(atom);
                    continue;
                }
                catch (IOException e) {
                    break;
                }
            }
            while (n < paths.length - 1) {
                atom = paths[n];
                URL polURL = new URL(linkParent.toURI().toURL(), atom);
                ParentOfLink pol = new ParentOfLink(this.getVFSContext(), linkParent, polURL, atom);
                if (linkParent == this) {
                    this.linkTargets.put(atom, pol);
                } else {
                    ParentOfLink prevPOL = (ParentOfLink)linkParent;
                    prevPOL.addChild(pol, atom);
                }
                linkParent = pol;
                ++n;
            }
            atom = paths[n];
            VirtualFileHandler linkHandler = this.createLinkHandler(linkParent, atom, link.getLinkTarget());
            if (linkParent == this) {
                this.linkTargets.put(atom, linkHandler);
                continue;
            }
            ParentOfLink prevPOL = (ParentOfLink)linkParent;
            prevPOL.addChild(linkHandler, atom);
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        return new ArrayList<VirtualFileHandler>(this.linkTargets.values());
    }

    @Override
    public VirtualFileHandler findChild(String path) throws IOException {
        return this.structuredFindChild(path);
    }

    @Override
    public VirtualFileHandler createChildHandler(String name) throws IOException {
        VirtualFileHandler handler = this.linkTargets.get(name);
        if (handler == null) {
            throw new FileNotFoundException("Failed to find link for: " + name + ", parent: " + this);
        }
        return handler;
    }

    @Override
    protected void doClose() {
        super.doClose();
        this.links.clear();
    }

    protected VirtualFileHandler createLinkHandler(VirtualFileHandler parent, String name, URI linkURI) throws IOException {
        VFSContextFactory factory = VFSContextFactoryLocator.getFactory(linkURI);
        VFSContext context = factory.getVFS(linkURI);
        VirtualFileHandler rootHandler = context.getRoot();
        return new DelegatingHandler(this.getVFSContext(), parent, name, rootHandler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ParentOfLink
    extends AbstractURLHandler
    implements StructuredVirtualFileHandler {
        private static final long serialVersionUID = 1L;
        private HashMap<String, VirtualFileHandler> children;

        public ParentOfLink(VFSContext context, VirtualFileHandler parent, URL url, String name) {
            super(context, parent, url, name);
            this.children = new HashMap(1);
        }

        void addChild(VirtualFileHandler child, String name) {
            this.children.put(name, child);
        }

        @Override
        public VirtualFileHandler findChild(String path) throws IOException {
            return this.structuredFindChild(path);
        }

        @Override
        public VirtualFileHandler createChildHandler(String name) throws IOException {
            return this.children.get(name);
        }

        @Override
        public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
            return null;
        }

        @Override
        public boolean isLeaf() throws IOException {
            return false;
        }
    }
}

