/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.virtual.plugins.context.jar.AbstractJarHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

public class NestedJarHandler
extends AbstractJarHandler {
    private static final long serialVersionUID = 1L;
    private transient JarEntry entry;
    private transient File temp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JarFile createTempJar(File temp, JarFile parentJar, JarEntry entry) throws IOException {
        InputStream inputStream = parentJar.getInputStream(entry);
        try {
            FileOutputStream outputStream = new FileOutputStream(temp);
            try {
                byte[] buffer = new byte[8096];
                int read = inputStream.read(buffer);
                while (read != -1) {
                    outputStream.write(buffer, 0, read);
                    read = inputStream.read(buffer);
                }
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ignored) {}
        }
        return new JarFile(temp);
    }

    public NestedJarHandler(VFSContext context, VirtualFileHandler parent, JarFile parentJar, JarEntry entry, URL url, String entryName) throws IOException {
        super(context, parent, url, entryName);
        try {
            this.temp = File.createTempFile("nestedjar", null);
            this.temp.deleteOnExit();
            this.initJarFile(NestedJarHandler.createTempJar(this.temp, parentJar, entry));
        }
        catch (IOException original) {
            IOException e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
            e.setStackTrace(original.getStackTrace());
            throw e;
        }
        this.entry = entry;
    }

    protected JarEntry getEntry() {
        this.checkClosed();
        return this.entry;
    }

    public long getLastModified() throws IOException {
        return this.getEntry().getTime();
    }

    public long getSize() throws IOException {
        return this.getEntry().getSize();
    }

    public InputStream openStream() throws IOException {
        FileInputStream fis = new FileInputStream(this.temp);
        return fis;
    }

    public URL toURL() throws MalformedURLException, URISyntaxException {
        return new URL("jar:" + this.temp.toURL() + "!/");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        JarFile parentJar = super.getJar();
        this.entry = parentJar.getJarEntry(this.getName());
        this.temp = File.createTempFile("nestedjar", null);
        this.temp.deleteOnExit();
        NestedJarHandler.createTempJar(this.temp, parentJar, this.entry);
        super.initJarFile(parentJar);
    }
}

