/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jboss.aspects.asynch.AsynchMixin;
import org.jboss.aspects.asynch.AsynchProvider;
import org.jboss.aspects.asynch.FutureHolder;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.LocalProxy;
import org.jboss.ejb3.ProxyUtils;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.util.id.GUID;

public class StatefulLocalProxy
extends LocalProxy
implements Externalizable {
    private static final long serialVersionUID = 206913210970415540L;
    protected Object id;
    AsynchProvider provider;

    public StatefulLocalProxy(Container container, Object id) {
        super(container);
        this.id = id;
    }

    public StatefulLocalProxy(AsynchProvider provider, Container container, Object id) {
        super(container);
        this.provider = provider;
        this.id = id;
    }

    public StatefulLocalProxy() {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.id = in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.id);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == AsynchProvider.class) {
            return this.provider.getFuture();
        }
        StatefulContainer sfsb = (StatefulContainer)this.getContainer();
        Object ret = ProxyUtils.handleCallLocally(proxy, this, method, args);
        if (ret != null) {
            return ret;
        }
        return sfsb.localInvoke(this.id, method, args, (FutureHolder)this.provider);
    }

    public Object getAsynchronousProxy(Object proxy) {
        Class[] infs = proxy.getClass().getInterfaces();
        if (!ProxyUtils.isAsynchronous(infs)) {
            Class[] interfaces = ProxyUtils.addAsynchProviderInterface(infs);
            AsynchMixin mixin = new AsynchMixin();
            StatefulLocalProxy handler = new StatefulLocalProxy((AsynchProvider)mixin, this.getContainer(), this.id);
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)handler);
        }
        return proxy;
    }

    public String toString() {
        if (this.id != null) {
            return this.getContainer().getEjbName().toString() + ":" + this.id.toString();
        }
        GUID guid = new GUID();
        return this.getContainer().getEjbName().toString() + ":" + guid.toString();
    }
}

