/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.tree;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.loader.FileCacheLoader;

public class SFSBFileCacheLoader
extends FileCacheLoader {
    Log log = LogFactory.getLog(SFSBFileCacheLoader.class);

    protected boolean isCharacterPortableTree(Fqn fqn) {
        Pattern fqnPattern = Pattern.compile("[\\\\\\/:*<>|\"?]");
        List elements = fqn.peekElements();
        for (Object anElement : elements) {
            Matcher matcher = fqnPattern.matcher(anElement.toString());
            if (!matcher.find()) continue;
            this.log.warn((Object)("One of the Fqn ( " + fqn + " ) elements contains one of these characters: '*' '<' '>' '|' '\"' '?' '\\' '/' ':' "));
            this.log.warn((Object)"Directories containing these characters are illegal in some operative systems and could lead to portability issues");
            return false;
        }
        return true;
    }
}

