/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.javassist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.ProtectionDomain;
import javassist.bytecode.ClassFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.AbstractClassTransformerImpl;
import org.hibernate.tool.instrument.javassist.FieldFilter;
import org.hibernate.tool.instrument.javassist.FieldTransformer;

public class JavassistClassTransformer
extends AbstractClassTransformerImpl {
    private static Log log = LogFactory.getLog((String)JavassistClassTransformer.class.getName());
    static /* synthetic */ Class class$org$hibernate$tool$instrument$javassist$FieldHandled;

    public JavassistClassTransformer(String[] packages, String[] classes) {
        super(packages, classes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] doTransform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        byte[] byArray;
        ClassFile classfile;
        try {
            classfile = new ClassFile(new DataInputStream(new ByteArrayInputStream(classfileBuffer)));
        }
        catch (IOException e) {
            log.error((Object)("Unable to build enhancement metamodel for " + className));
            return classfileBuffer;
        }
        FieldTransformer transformer = this.getFieldTransformer(classfile);
        if (transformer == null) return classfileBuffer;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enhancing " + className));
        }
        FilterOutputStream out = null;
        try {
            try {
                transformer.transform(classfile);
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                out = new DataOutputStream(byteStream);
                classfile.write((DataOutputStream)out);
                byArray = byteStream.toByteArray();
                Object var12_13 = null;
            }
            catch (Exception e) {
                log.error((Object)"Unable to transform class", (Throwable)e);
                throw new HibernateException("Unable to transform class: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return byArray;
        }
        if (out == null) return byArray;
        out.close();
        return byArray;
    }

    protected FieldTransformer getFieldTransformer(ClassFile classfile) {
        if (this.alreadyInstrumented(classfile)) {
            return null;
        }
        return new FieldTransformer(new FieldFilter(){

            public boolean handleRead(String desc, String name) {
                return true;
            }

            public boolean handleWrite(String desc, String name) {
                return true;
            }
        });
    }

    private boolean alreadyInstrumented(ClassFile classfile) {
        String[] intfs = classfile.getInterfaces();
        for (int i = 0; i < intfs.length; ++i) {
            if (!(class$org$hibernate$tool$instrument$javassist$FieldHandled == null ? JavassistClassTransformer.class$("org.hibernate.tool.instrument.javassist.FieldHandled") : class$org$hibernate$tool$instrument$javassist$FieldHandled).getName().equals(intfs[i])) continue;
            return true;
        }
        return false;
    }
}

