/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.intercept;

import java.util.Set;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.intercept.cglib.CGLIBHelper;
import org.hibernate.intercept.javassist.JavassistHelper;

public class FieldInterceptionHelper {
    private FieldInterceptionHelper() {
    }

    public static boolean isInstrumented(Class entityClass) {
        Class<?>[] definedInterfaces = entityClass.getInterfaces();
        for (int i = 0; i < definedInterfaces.length; ++i) {
            if (!"net.sf.cglib.transform.impl.InterceptFieldEnabled".equals(definedInterfaces[i].getName()) && !"org.hibernate.tool.instrument.javassist.FieldHandled".equals(definedInterfaces[i].getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstrumented(Object entity) {
        return entity != null && FieldInterceptionHelper.isInstrumented(entity.getClass());
    }

    public static FieldInterceptor extractFieldInterceptor(Object entity) {
        if (entity == null) {
            return null;
        }
        Class<?>[] definedInterfaces = entity.getClass().getInterfaces();
        for (int i = 0; i < definedInterfaces.length; ++i) {
            if ("net.sf.cglib.transform.impl.InterceptFieldEnabled".equals(definedInterfaces[i].getName())) {
                return CGLIBHelper.extractFieldInterceptor(entity);
            }
            if (!"org.hibernate.tool.instrument.javassist.FieldHandled".equals(definedInterfaces[i].getName())) continue;
            return JavassistHelper.extractFieldInterceptor(entity);
        }
        return null;
    }

    public static FieldInterceptor injectFieldInterceptor(Object entity, String entityName, Set uninitializedFieldNames, SessionImplementor session) {
        if (entity != null) {
            Class<?>[] definedInterfaces = entity.getClass().getInterfaces();
            for (int i = 0; i < definedInterfaces.length; ++i) {
                if ("net.sf.cglib.transform.impl.InterceptFieldEnabled".equals(definedInterfaces[i].getName())) {
                    return CGLIBHelper.injectFieldInterceptor(entity, entityName, uninitializedFieldNames, session);
                }
                if (!"org.hibernate.tool.instrument.javassist.FieldHandled".equals(definedInterfaces[i].getName())) continue;
                return JavassistHelper.injectFieldInterceptor(entity, entityName, uninitializedFieldNames, session);
            }
        }
        return null;
    }

    public static void clearDirty(Object entity) {
        FieldInterceptor interceptor = FieldInterceptionHelper.extractFieldInterceptor(entity);
        if (interceptor != null) {
            interceptor.clearDirty();
        }
    }

    public static void markDirty(Object entity) {
        FieldInterceptor interceptor = FieldInterceptionHelper.extractFieldInterceptor(entity);
        if (interceptor != null) {
            interceptor.dirty();
        }
    }
}

