/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.NotFoundInDispatcherException;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.aop.proxy.Proxy;
import org.jboss.aop.util.reference.MethodPersistentReference;

public class Dispatcher {
    public static final String DISPATCHER = "DISPATCHER";
    public static final String OID = "OID";
    public static final Dispatcher singleton = new Dispatcher();
    Map targetMap = new ConcurrentReaderHashMap();

    public boolean isRegistered(Object oid) {
        return this.targetMap.containsKey(oid);
    }

    public void registerTarget(Object oid, Object target) {
        this.targetMap.put(oid, target);
    }

    public void unregisterTarget(Object oid) {
        this.targetMap.remove(oid);
    }

    public Object getRegistered(Object oid) {
        return this.targetMap.get(oid);
    }

    public InvocationResponse invoke(Invocation invocation) throws NotFoundInDispatcherException, Throwable {
        Object oid = invocation.getMetaData(DISPATCHER, OID);
        Object target = null;
        target = this.targetMap.get(oid);
        if (target == null) {
            throw new NotFoundInDispatcherException(oid);
        }
        if (target instanceof ClassProxy) {
            ClassProxy proxy = (ClassProxy)target;
            return proxy._dynamicInvoke(invocation);
        }
        if (target instanceof Proxy) {
            Proxy proxy = (Proxy)target;
            return proxy._dynamicInvoke(invocation);
        }
        if (target instanceof Advised) {
            Advisor advisor = ((Advised)target)._getAdvisor();
            return advisor.dynamicInvoke(target, invocation);
        }
        if (target instanceof Advisor) {
            Advisor advisor = (Advisor)target;
            return advisor.dynamicInvoke(null, invocation);
        }
        if (invocation instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)invocation;
            long methodHash = methodInvocation.getMethodHash();
            HashMap methodMap = ClassProxyFactory.getMethodMap(target.getClass());
            MethodPersistentReference ref = (MethodPersistentReference)methodMap.get(new Long(methodHash));
            Method method = (Method)ref.get();
            Object[] args = methodInvocation.getArguments();
            try {
                return new InvocationResponse(method.invoke(target, args));
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
        throw new RuntimeException("field invocations not implemented");
    }
}

