/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployers;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javassist.bytecode.ClassFile;
import org.jboss.aop.AspectAnnotationLoader;
import org.jboss.aop.AspectManager;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.aop.deployment.JBossScopedClassLoaderHelper;
import org.jboss.deployers.plugins.deployer.AbstractSimpleDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor;
import org.jboss.virtual.plugins.vfs.helpers.SuffixesExcludeFilter;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectDeployer
extends AbstractSimpleDeployer {
    private static final Logger log = Logger.getLogger(AspectDeployer.class);
    private static final String AOP_JAR_SUFFIX = ".aop";
    private static final String AOP_DD_SUFFIX = "-aop.xml";

    public AspectDeployer() {
        this.setRelativeOrder(4100);
    }

    @Override
    public void deploy(DeploymentUnit unit) throws DeploymentException {
        List<VirtualFile> files = unit.getMetaDataFiles(null, AOP_DD_SUFFIX);
        if (this.isAopArchiveOrFolder(unit)) {
            this.deployAnnotations(unit);
        }
        if (files.size() > 0) {
            this.deployXml(unit, files);
        }
    }

    @Override
    public void undeploy(DeploymentUnit unit) {
        List<VirtualFile> files = unit.getMetaDataFiles(null, AOP_DD_SUFFIX);
        if (this.isAopArchiveOrFolder(unit)) {
            this.undeployAnnotations(unit);
        }
        if (files.size() > 0) {
            this.undeployXml(unit, files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployXml(DeploymentUnit unit, List<VirtualFile> files) throws DeploymentException {
        ClassLoader scl = this.getScopedClassLoader(unit);
        if (scl != null) {
            log.info("AOP deployment is scoped using classloader " + scl);
        }
        for (VirtualFile vf : files) {
            try {
                log.debug("deploying: " + vf.toURL());
                InputStream is = vf.openStream();
                try {
                    Document doc = AspectXmlLoader.loadDocument(is);
                    AspectXmlLoader loader = new AspectXmlLoader();
                    if (scl != null) {
                        loader.setManager(AspectManager.instance(scl));
                        loader.setClassLoader(scl);
                    } else {
                        loader.setManager(AspectManager.instance());
                    }
                    loader.deployXML(doc, vf.toURL(), scl);
                }
                finally {
                    is.close();
                }
            }
            catch (Exception e) {
                throw new DeploymentException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployXml(DeploymentUnit unit, List<VirtualFile> files) {
        ClassLoader scl = this.getScopedClassLoader(unit);
        for (VirtualFile vf : files) {
            try {
                log.debug("undeploying: " + vf.toURL());
                InputStream is = vf.openStream();
                try {
                    Document doc = AspectXmlLoader.loadDocument(is);
                    AspectXmlLoader loader = new AspectXmlLoader();
                    AspectManager manager = scl != null ? AspectManager.instance(scl) : AspectManager.instance();
                    loader.setManager(manager);
                    loader.undeployXML(doc, vf.toURL());
                }
                finally {
                    is.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        AspectManager.instance().unregisterClassLoader(unit.getClassLoader());
    }

    private void deployAnnotations(DeploymentUnit unit) throws DeploymentException {
        ClassLoader scl = this.getScopedClassLoader(unit);
        if (scl != null) {
            log.info("AOP deployment is scoped using classloader " + scl);
        }
        AspectAnnotationLoader loader = this.getAnnotationLoader(scl);
        List<VirtualFile> files = this.getClasses(unit);
        for (VirtualFile file : files) {
            ClassFile cf = this.loadClassFile(file);
            try {
                log.debug("Deploying possibly annotated class " + cf.getName());
                loader.deployClassFile(cf);
            }
            catch (Exception e) {
                throw new DeploymentException("Error reading annotations for " + file, e);
            }
        }
    }

    private void undeployAnnotations(DeploymentUnit unit) {
        ClassLoader scl = this.getScopedClassLoader(unit);
        AspectAnnotationLoader loader = this.getAnnotationLoader(scl);
        List<VirtualFile> files = this.getClasses(unit);
        for (VirtualFile file : files) {
            ClassFile cf = this.loadClassFile(file);
            try {
                log.debug("Undeploying possibly annotated class " + cf.getName());
                loader.undeployClassFile(cf);
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading annotations for " + file, e);
            }
        }
    }

    private AspectAnnotationLoader getAnnotationLoader(ClassLoader scl) {
        AspectManager manager = scl != null ? AspectManager.instance(scl) : AspectManager.instance();
        AspectAnnotationLoader loader = new AspectAnnotationLoader(manager);
        loader.setClassLoader(scl);
        return loader;
    }

    private ClassFile loadClassFile(VirtualFile file) {
        FilterInputStream din = null;
        ClassFile cf = null;
        try {
            InputStream in = file.openStream();
            din = new DataInputStream(new BufferedInputStream(in));
            cf = new ClassFile((DataInputStream)din);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading " + file, e);
        }
        finally {
            try {
                din.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error closing input stream for " + file, e);
            }
        }
        return cf;
    }

    private List<VirtualFile> getClasses(DeploymentUnit unit) {
        VisitorAttributes va = new VisitorAttributes();
        va.setLeavesOnly(true);
        ClassFileFilter filter = new ClassFileFilter();
        SuffixesExcludeFilter noJars = new SuffixesExcludeFilter(JarUtils.getSuffixes());
        va.setRecurseFilter(noJars);
        FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, va);
        for (VirtualFile vf : unit.getDeploymentContext().getClassPath()) {
            try {
                vf.visit(visitor);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return visitor.getMatched();
    }

    private boolean isAopArchiveOrFolder(DeploymentUnit unit) {
        String name = unit.getName();
        int index = name.length();
        if (name.charAt(name.length() - 1) == '/') {
            --index;
        }
        if (name.charAt(name.length() - 2) == '!') {
            --index;
        }
        String realName = index == name.length() ? name : name.substring(0, index);
        return realName.endsWith(AOP_JAR_SUFFIX);
    }

    private ClassLoader getScopedClassLoader(DeploymentUnit unit) {
        if (JBossScopedClassLoaderHelper.isScopedClassLoader(unit.getClassLoader())) {
            return unit.getClassLoader();
        }
        return null;
    }

    private static class ClassFileFilter
    implements VirtualFileFilter {
        private ClassFileFilter() {
        }

        public boolean accepts(VirtualFile file) {
            try {
                return file.isLeaf() && file.getName().endsWith(".class");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

