/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.asynchronous.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import org.jboss.aspects.asynchronous.ProcessingTime;
import org.jboss.aspects.asynchronous.concurrent.AdapterTask;

public class TimedCallableImpl
extends ThreadFactoryUser
implements Callable,
ProcessingTime {
    private final AdapterTask function;
    private final long millis;
    private long endingTime = -1L;
    private long startingTime = -1L;

    public TimedCallableImpl(AdapterTask function, long millis) {
        this.function = function;
        this.millis = millis;
    }

    public Object call() throws Exception {
        FutureResult result = new FutureResult();
        Thread thread = this.getThreadFactory().newThread(result.setter((Callable)this.function));
        thread.start();
        try {
            this.startingTime = System.currentTimeMillis();
            Object obj = result.timedGet(this.millis);
            this.endingTime = System.currentTimeMillis();
            return obj;
        }
        catch (InterruptedException ex) {
            this.endingTime = System.currentTimeMillis();
            this.function.cleanup();
            thread.interrupt();
            throw ex;
        }
    }

    public long getEndingTime() {
        return this.endingTime;
    }

    public long getStartingTime() {
        return this.startingTime;
    }
}

