/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import java.util.Set;
import java.util.Stack;
import org.jboss.beans.metadata.plugins.AbstractFeatureMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.beans.metadata.plugins.TypeProvider;
import org.jboss.beans.metadata.plugins.ValueMetaDataAware;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractParameterMetaData
extends AbstractFeatureMetaData
implements ParameterMetaData,
ValueMetaDataAware,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String type;
    protected ValueMetaData value;
    protected int index;

    public AbstractParameterMetaData() {
    }

    public AbstractParameterMetaData(Object value) {
        this.type = value.getClass().getName();
        this.value = new AbstractValueMetaData(value);
    }

    public AbstractParameterMetaData(ValueMetaData value) {
        this.value = value;
    }

    public AbstractParameterMetaData(String type, Object value) {
        this.type = type;
        this.value = new AbstractValueMetaData(value);
    }

    public AbstractParameterMetaData(String type, String value) {
        this.type = type;
        this.value = new StringValueMetaData(value);
    }

    public AbstractParameterMetaData(String type, ValueMetaData value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.flushJBossObjectCache();
    }

    @Override
    public ValueMetaData getValue() {
        return this.value;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void setValue(ValueMetaData value) {
        this.value = value;
        this.flushJBossObjectCache();
    }

    @Override
    protected void addChildren(Set<MetaDataVisitorNode> children) {
        super.addChildren(children);
        if (this.value != null) {
            children.add(this.value);
        }
    }

    @Override
    public Class getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable {
        if (this.type != null) {
            KernelControllerContext context = visitor.getControllerContext();
            ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
            KernelController controller = (KernelController)context.getController();
            KernelConfigurator configurator = controller.getKernel().getConfigurator();
            return this.applyCollectionOrMapCheck(configurator.getClassInfo(this.type, cl).getType());
        }
        Stack<MetaDataVisitorNode> visitorNodeStack = visitor.visitorNodeStack();
        MetaDataVisitorNode node = visitorNodeStack.pop();
        try {
            if (node instanceof TypeProvider) {
                TypeProvider typeProvider = (TypeProvider)((Object)node);
                Class clazz = typeProvider.getType(visitor, this);
                return clazz;
            }
            throw new IllegalArgumentException("Node not of TypeProvider instance, cannot determine class type.");
        }
        finally {
            visitorNodeStack.push(node);
        }
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        buffer.append("type=").append(this.type);
        buffer.append(" value=").append(this.value);
        super.toString(buffer);
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.type);
    }
}

