/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.deployers.plugins.deployer.AbstractDeploymentUnit;
import org.jboss.deployers.plugins.deployer.DeployerWrapper;
import org.jboss.deployers.plugins.structure.BasicStructuredDeployers;
import org.jboss.deployers.plugins.structure.DefaultStructureBuilder;
import org.jboss.deployers.plugins.structure.StructureMetaDataImpl;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployers.spi.deployment.MainDeployer;
import org.jboss.deployers.spi.managed.ManagedObjectBuilder;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.deployers.spi.structure.DeploymentState;
import org.jboss.deployers.spi.structure.StructureDetermined;
import org.jboss.deployers.spi.structure.vfs.StructureBuilder;
import org.jboss.deployers.spi.structure.vfs.StructureDeployer;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.util.graph.Graph;
import org.jboss.util.graph.Vertex;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainDeployerImpl
implements MainDeployer {
    private static final Logger log = Logger.getLogger(MainDeployerImpl.class);
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private BasicStructuredDeployers structureDeployers = new BasicStructuredDeployers();
    private StructureBuilder structureBuilder = new DefaultStructureBuilder();
    private SortedSet<DeployerWrapper> deployers = new TreeSet<DeployerWrapper>(Deployer.COMPARATOR);
    private Map<String, DeploymentContext> topLevelDeployments = new ConcurrentHashMap<String, DeploymentContext>();
    private Map<String, DeploymentContext> allDeployments = new ConcurrentHashMap<String, DeploymentContext>();
    private Map<String, DeploymentContext> errorDeployments = new ConcurrentHashMap<String, DeploymentContext>();
    private Map<String, DeploymentContext> missingDeployers = new ConcurrentHashMap<String, DeploymentContext>();
    private List<DeploymentContext> undeploy = new CopyOnWriteArrayList<DeploymentContext>();
    private List<DeploymentContext> deploy = new CopyOnWriteArrayList<DeploymentContext>();

    public synchronized Set<StructureDeployer> getStructureDeployers() {
        return this.structureDeployers.getDeployers();
    }

    public synchronized void setStructureDeployers(Set<StructureDeployer> deployers) {
        if (deployers == null) {
            throw new IllegalArgumentException("Null deployers");
        }
        this.structureDeployers.setDeployers(deployers);
    }

    public synchronized void addStructureDeployer(StructureDeployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        this.structureDeployers.addDeployer(deployer);
        log.debug("Added structure deployer: " + deployer);
    }

    public synchronized void removeStructureDeployer(StructureDeployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        this.structureDeployers.removeDeployer(deployer);
        log.debug("Remove structure deployer: " + deployer);
    }

    public synchronized Set<Deployer> getDeployers() {
        TreeSet<Deployer> result = new TreeSet<Deployer>(Deployer.COMPARATOR);
        result.addAll(this.deployers);
        return result;
    }

    public synchronized void setDeployers(Set<Deployer> deployers) {
        if (deployers == null) {
            throw new IllegalArgumentException("Null deployers");
        }
        HashSet<DeployerWrapper> oldDeployers = new HashSet<DeployerWrapper>(this.deployers);
        oldDeployers.removeAll(deployers);
        for (Deployer deployer : oldDeployers) {
            this.removeDeployer(deployer);
        }
        HashSet<Deployer> newDeployers = new HashSet<Deployer>(deployers);
        newDeployers.removeAll(this.deployers);
        for (Deployer deployer : newDeployers) {
            this.addDeployer(deployer);
        }
    }

    public synchronized void addDeployer(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        DeployerWrapper wrapper = new DeployerWrapper(deployer);
        this.deployers.add(wrapper);
        log.debug("Added deployer: " + deployer);
    }

    public synchronized void removeDeployer(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        DeployerWrapper wrapper = new DeployerWrapper(deployer);
        this.deployers.remove(wrapper);
        log.debug("Removed deployer: " + deployer);
    }

    public ManagedObjectBuilder getDeployerManagedObjectBuilder(Deployer deployer) {
        ManagedObjectBuilder managedObjectBuilder = null;
        for (DeployerWrapper wrapper : this.deployers) {
            if (!wrapper.equals(deployer)) continue;
            managedObjectBuilder = wrapper.getManagedObjectBuilder();
        }
        return managedObjectBuilder;
    }

    public void setDeployerManagedObjectBuilder(Deployer deployer, ManagedObjectBuilder managedObjectBuilder) {
        for (DeployerWrapper wrapper : this.deployers) {
            if (!wrapper.equals(deployer)) continue;
            wrapper.setManagedObjectBuilder(managedObjectBuilder);
        }
    }

    @Override
    public DeploymentContext getDeploymentContext(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        return this.allDeployments.get(name);
    }

    @Override
    public Map<String, ManagedObject> getManagedObjects(DeploymentContext context) throws DeploymentException {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        HashMap<String, ManagedObject> managedObjects = new HashMap<String, ManagedObject>();
        for (DeployerWrapper deployer : this.deployers) {
            deployer.build(context.getDeploymentUnit(), managedObjects);
        }
        return managedObjects;
    }

    @Override
    public Graph<Map<String, ManagedObject>> getManagedObjects(String name) throws DeploymentException {
        DeploymentContext context = this.getDeploymentContext(name);
        Graph<Map<String, ManagedObject>> managedObjectsGraph = new Graph<Map<String, ManagedObject>>();
        Vertex<Map<String, ManagedObject>> parent = new Vertex<Map<String, ManagedObject>>(context.getName());
        managedObjectsGraph.setRootVertex(parent);
        Map<String, ManagedObject> managedObjects = this.getManagedObjects(context);
        parent.setData(managedObjects);
        this.processContext(context, managedObjectsGraph, parent);
        return managedObjectsGraph;
    }

    protected void processContext(DeploymentContext context, Graph<Map<String, ManagedObject>> graph, Vertex<Map<String, ManagedObject>> parent) throws DeploymentException {
        Set<DeploymentContext> children = context.getChildren();
        for (DeploymentContext child : children) {
            Vertex<Map<String, ManagedObject>> vertex = new Vertex<Map<String, ManagedObject>>(child.getName());
            Map<String, ManagedObject> managedObjects = this.getManagedObjects(context);
            vertex.setData(managedObjects);
            graph.addEdge(parent, vertex, 0);
            this.processContext(child, graph, vertex);
        }
    }

    public StructureBuilder getStructureBuilder() {
        return this.structureBuilder;
    }

    public void setStructureBuilder(StructureBuilder builder) {
        this.structureBuilder = builder;
    }

    @Override
    public synchronized void addDeploymentContext(DeploymentContext context) throws DeploymentException {
        if (context == null) {
            throw new DeploymentException("Null context");
        }
        if (this.shutdown.get()) {
            throw new DeploymentException("The main deployer is shutdown");
        }
        log.debug("Add deployment context: " + context.getName());
        if (!context.isTopLevel()) {
            throw new DeploymentException("Context is not a top level deployment: " + context.getName());
        }
        String name = context.getName();
        DeploymentContext previous = this.topLevelDeployments.get(name);
        boolean topLevelFound = false;
        if (previous != null) {
            log.debug("Removing previous deployment: " + previous.getName());
            this.removeContext(previous);
            topLevelFound = true;
        }
        if (!topLevelFound && (previous = this.allDeployments.get(name)) != null) {
            throw new IllegalStateException("Deployment already exists as a subdeployment: " + context.getName());
        }
        this.reset(context);
        this.topLevelDeployments.put(name, context);
        try {
            this.determineStructure(context);
        }
        catch (Throwable t) {
            log.error("Unable to determine structure of deployment: " + name, t);
            context.setState(DeploymentState.ERROR);
            context.setProblem(t);
            this.errorDeployments.put(name, context);
        }
        this.addContext(context);
    }

    @Override
    public synchronized boolean removeDeploymentContext(String name) throws DeploymentException {
        if (name == null) {
            throw new DeploymentException("Null name");
        }
        if (this.shutdown.get()) {
            throw new IllegalStateException("The main deployer is shutdown");
        }
        log.debug("Remove deployment context: " + name);
        DeploymentContext context = this.topLevelDeployments.remove(name);
        if (context == null) {
            return false;
        }
        this.removeContext(context);
        return true;
    }

    @Override
    public Collection<DeploymentContext> getAll() {
        return Collections.unmodifiableCollection(this.allDeployments.values());
    }

    @Override
    public Collection<DeploymentContext> getErrors() {
        return Collections.unmodifiableCollection(this.errorDeployments.values());
    }

    @Override
    public Collection<DeploymentContext> getMissingDeployer() {
        return Collections.unmodifiableCollection(this.missingDeployers.values());
    }

    @Override
    public Collection<DeploymentContext> getTopLevel() {
        return Collections.unmodifiableCollection(this.topLevelDeployments.values());
    }

    @Override
    public void process() {
        this.process(MainDeployer.ProcessMode.Runtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DeploymentContext> process(MainDeployer.ProcessMode mode) {
        Deployer[] theDeployers;
        if (this.shutdown.get()) {
            throw new IllegalStateException("The main deployer is shutdown");
        }
        ArrayList<DeploymentContext> undeployContexts = null;
        ArrayList<DeploymentContext> deployContexts = null;
        ArrayList<DeploymentContext> processedContexts = new ArrayList<DeploymentContext>();
        MainDeployerImpl mainDeployerImpl = this;
        synchronized (mainDeployerImpl) {
            if (this.deployers.isEmpty()) {
                throw new IllegalStateException("No deployers");
            }
            if (!this.undeploy.isEmpty()) {
                undeployContexts = new ArrayList<DeploymentContext>(this.undeploy.size());
                for (int i = this.undeploy.size() - 1; i >= 0; --i) {
                    undeployContexts.add(this.undeploy.get(i));
                }
                this.undeploy.clear();
            }
            if (!this.deploy.isEmpty()) {
                deployContexts = new ArrayList<DeploymentContext>(this.deploy);
                this.deploy.clear();
            }
            theDeployers = this.deployers.toArray(new Deployer[this.deployers.size()]);
        }
        if (undeployContexts != null) {
            for (int i = theDeployers.length - 1; i >= 0; --i) {
                Deployer deployer = theDeployers[i];
                for (DeploymentContext context : undeployContexts) {
                    this.prepareUndeploy(deployer, context, true);
                    this.commitUndeploy(deployer, context, true);
                }
            }
            for (DeploymentContext context : undeployContexts) {
                context.removeClassLoader();
                context.setState(DeploymentState.UNDEPLOYED);
                log.debug("Undeployed: " + context.getName());
            }
        }
        if (deployContexts != null) {
            for (int i = 0; i < theDeployers.length; ++i) {
                Deployer deployer = theDeployers[i];
                HashSet<DeploymentContext> errors = new HashSet<DeploymentContext>();
                for (DeploymentContext context : deployContexts) {
                    try {
                        context.getTransientAttachments().addAttachment(MainDeployer.ProcessMode.class, mode);
                        Set<DeploymentContext> components = context.getComponents();
                        this.prepareDeploy(deployer, context, components);
                        this.commitDeploy(deployer, context, components);
                    }
                    catch (DeploymentException e) {
                        context.setState(DeploymentState.ERROR);
                        context.setProblem(e);
                        errors.add(context);
                        this.errorDeployments.put(context.getName(), context);
                        for (int j = i - 1; j >= 0; --j) {
                            Deployer other = theDeployers[j];
                            this.prepareUndeploy(other, context, true);
                        }
                        context.removeClassLoader();
                    }
                }
                deployContexts.removeAll(errors);
            }
            for (DeploymentContext context : deployContexts) {
                String name = context.getName();
                boolean isJar = false;
                VirtualFile root = context.getRoot();
                if (root != null && root.getName().endsWith(".jar")) {
                    isJar = true;
                }
                if (!context.isDeployed() && !isJar) {
                    this.missingDeployers.put(name, context);
                }
                context.setState(DeploymentState.DEPLOYED);
                processedContexts.add(context);
                log.debug("Deployed: " + name);
            }
        }
        return processedContexts;
    }

    private void prepareUndeploy(Deployer deployer, DeploymentContext context, boolean doComponents) {
        Set<DeploymentContext> components;
        DeploymentUnit unit = context.getDeploymentUnit();
        deployer.prepareUndeploy(unit);
        if (doComponents && (components = context.getComponents()) != null && !components.isEmpty()) {
            DeploymentContext[] theComponents = components.toArray(new DeploymentContext[components.size()]);
            for (int i = theComponents.length - 1; i >= 0; --i) {
                this.prepareUndeploy(deployer, theComponents[i], true);
            }
        }
    }

    private void commitUndeploy(Deployer deployer, DeploymentContext context, boolean doComponents) {
        Set<DeploymentContext> components;
        DeploymentUnit unit = context.getDeploymentUnit();
        deployer.commitUndeploy(unit);
        if (doComponents && (components = context.getComponents()) != null && !components.isEmpty()) {
            DeploymentContext[] theComponents = components.toArray(new DeploymentContext[components.size()]);
            for (int i = theComponents.length - 1; i >= 0; --i) {
                this.commitUndeploy(deployer, theComponents[i], true);
            }
        }
    }

    private void prepareDeploy(Deployer deployer, DeploymentContext context, Set<DeploymentContext> components) throws DeploymentException {
        DeploymentContext[] theComponents = null;
        if (components != null && !components.isEmpty()) {
            theComponents = components.toArray(new DeploymentContext[components.size()]);
        }
        DeploymentUnit unit = context.getDeploymentUnit();
        deployer.prepareDeploy(unit);
        try {
            if (theComponents != null) {
                for (int i = 0; i < theComponents.length; ++i) {
                    try {
                        Set<DeploymentContext> componentComponents = theComponents[i].getComponents();
                        this.prepareDeploy(deployer, theComponents[i], componentComponents);
                        continue;
                    }
                    catch (DeploymentException e) {
                        for (int j = i - 1; j >= 0; --j) {
                            this.prepareUndeploy(deployer, theComponents[j], true);
                        }
                        throw e;
                    }
                }
            }
        }
        catch (DeploymentException e) {
            this.prepareUndeploy(deployer, context, false);
            throw e;
        }
    }

    private void commitDeploy(Deployer deployer, DeploymentContext context, Set<DeploymentContext> components) throws DeploymentException {
        DeploymentContext[] theComponents = null;
        if (components != null && !components.isEmpty()) {
            theComponents = components.toArray(new DeploymentContext[components.size()]);
        }
        DeploymentUnit unit = context.getDeploymentUnit();
        deployer.commitDeploy(unit);
        try {
            if (theComponents != null) {
                for (int i = 0; i < theComponents.length; ++i) {
                    try {
                        Set<DeploymentContext> componentComponents = theComponents[i].getComponents();
                        this.commitDeploy(deployer, theComponents[i], componentComponents);
                        continue;
                    }
                    catch (DeploymentException e) {
                        for (int j = i - 1; j >= 0; --j) {
                            this.prepareUndeploy(deployer, theComponents[j], true);
                        }
                        throw e;
                    }
                }
            }
        }
        catch (DeploymentException e) {
            this.prepareUndeploy(deployer, context, false);
            throw e;
        }
    }

    @Override
    public void shutdown() {
        while (!this.topLevelDeployments.isEmpty()) {
            for (DeploymentContext context : this.topLevelDeployments.values()) {
                this.topLevelDeployments.remove(context.getName());
                this.removeContext(context);
            }
            this.process();
        }
        this.shutdown.set(true);
    }

    protected void reset(DeploymentContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (context.getStructureDetermined() == StructureDetermined.YES) {
            context.setStructureDetermined(StructureDetermined.NO);
        }
        context.setProblem(null);
        context.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void determineStructure(DeploymentContext context) throws DeploymentException {
        if (context.getStructureDetermined() == StructureDetermined.PREDETERMINED) {
            return;
        }
        if (context.getRoot() == null) {
            throw new DeploymentException("Unable to determine structure context has not root " + context.getName());
        }
        MainDeployerImpl mainDeployerImpl = this;
        synchronized (mainDeployerImpl) {
            if (this.structureDeployers.isEmpty()) {
                throw new IllegalStateException("No structure deployers");
            }
        }
        VirtualFile root = context.getRoot();
        StructureMetaDataImpl metaData = new StructureMetaDataImpl();
        boolean result = this.structureDeployers.determineStructure(root, metaData);
        if (!result) {
            throw new DeploymentException("No structural deployer recognised the deployment. " + context.getName());
        }
        this.structureBuilder.populateContext(context, metaData);
    }

    private void addContext(DeploymentContext context) {
        this.allDeployments.put(context.getName(), context);
        if (context.getState() == DeploymentState.ERROR) {
            log.debug("Not scheduling addition of context already in error: " + context.getName());
            return;
        }
        context.setDeploymentUnit(new AbstractDeploymentUnit(context));
        context.setState(DeploymentState.DEPLOYING);
        log.debug("Scheduling deployment: " + context.getName());
        this.deploy.add(context);
        Set<DeploymentContext> children = context.getChildren();
        if (children != null) {
            for (DeploymentContext child : children) {
                this.addContext(child);
            }
        }
    }

    private void removeContext(DeploymentContext context) {
        String name = context.getName();
        this.allDeployments.remove(name);
        this.errorDeployments.remove(name);
        this.missingDeployers.remove(name);
        if (context.getState() == DeploymentState.ERROR) {
            log.debug("Not scheduling removal of context already in error: " + name);
            return;
        }
        context.setState(DeploymentState.UNDEPLOYING);
        log.debug("Scheduling undeployment: " + name);
        this.undeploy.add(context);
        Set<DeploymentContext> children = context.getChildren();
        if (children != null) {
            for (DeploymentContext child : children) {
                this.removeContext(child);
            }
        }
    }
}

