/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.structure.vfs;

import java.io.IOException;
import org.jboss.deployers.plugins.structure.vfs.SecurityActions;
import org.jboss.deployers.spi.structure.vfs.ContextInfo;
import org.jboss.deployers.spi.structure.vfs.StructureMetaData;
import org.jboss.deployers.spi.structure.vfs.StructuredDeployers;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.vfs.helpers.AbstractVirtualFileVisitor;

public class AbstractCandidateStructureVisitor
extends AbstractVirtualFileVisitor {
    private static final Logger log = Logger.getLogger(AbstractCandidateStructureVisitor.class);
    private final VirtualFile parent;
    private final StructureMetaData metaData;
    private final StructuredDeployers deployers;
    private boolean ignoreDirectories;
    private VirtualFileFilter filter;

    public AbstractCandidateStructureVisitor(VirtualFile parent, StructureMetaData metaData, StructuredDeployers deployers) {
        this(parent, metaData, deployers, null);
    }

    public AbstractCandidateStructureVisitor(VirtualFile parent, StructureMetaData metaData, StructuredDeployers deployers, VisitorAttributes attributes) {
        super(attributes);
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        this.parent = parent;
        this.metaData = metaData;
        this.deployers = deployers;
    }

    public VirtualFile getParent() {
        return this.parent;
    }

    public boolean isIgnoreDirectories() {
        return this.ignoreDirectories;
    }

    public VirtualFileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(VirtualFileFilter filter) {
        this.filter = filter;
    }

    public void setIgnoreDirectories(boolean ignoreDirectories) {
        this.ignoreDirectories = ignoreDirectories;
    }

    public void visit(VirtualFile file) {
        ContextInfo context = this.metaData.getContext(file.getPathName());
        if (context == null) {
            try {
                if (this.ignoreDirectories && !SecurityActions.isLeaf(file)) {
                    return;
                }
            }
            catch (IOException e) {
                log.debug("Ignoring " + file + " reason=" + e);
                return;
            }
            if (this.filter != null && !this.filter.accepts(file)) {
                return;
            }
            try {
                this.deployers.determineStructure(file, this.metaData);
            }
            catch (Exception e) {
                log.debug("Ignoring " + file + " reason=" + e);
                return;
            }
        }
    }
}

