/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.structure.vfs.war;

import java.io.IOException;
import java.util.List;
import org.jboss.deployers.plugins.structure.ContextInfoImpl;
import org.jboss.deployers.plugins.structure.vfs.AbstractStructureDeployer;
import org.jboss.deployers.plugins.structure.vfs.war.SecurityActions;
import org.jboss.deployers.spi.structure.vfs.StructureMetaData;
import org.jboss.deployers.spi.structure.vfs.StructuredDeployers;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.vfs.helpers.SuffixMatchFilter;

public class WARStructure
extends AbstractStructureDeployer {
    public static final VirtualFileFilter DEFAULT_WEB_INF_LIB_FILTER = new SuffixMatchFilter(".jar", VisitorAttributes.DEFAULT);
    private VirtualFileFilter webInfLibFilter = DEFAULT_WEB_INF_LIB_FILTER;

    public WARStructure() {
        this.setRelativeOrder(1000);
    }

    public VirtualFileFilter getWebInfLibFilter() {
        return this.webInfLibFilter;
    }

    public void setWebInfLibFilter(VirtualFileFilter webInfLibFilter) {
        if (webInfLibFilter == null) {
            throw new IllegalArgumentException("Null filter");
        }
        this.webInfLibFilter = webInfLibFilter;
    }

    public boolean determineStructure(VirtualFile root, StructureMetaData metaData, StructuredDeployers deployers) {
        try {
            if (!SecurityActions.isLeaf(root)) {
                if (!root.getName().endsWith(".war")) {
                    try {
                        root.findChild("WEB-INF");
                        this.log.trace("... ok - directory has a WEB-INF subdirectory");
                    }
                    catch (IOException e) {
                        this.log.trace("... no - doesn't look like a war and no WEB-INF subdirectory.");
                        return false;
                    }
                } else {
                    this.log.trace("... ok - name ends in .war.");
                }
                ContextInfoImpl context = new ContextInfoImpl(root.getPathName());
                context.setMetaDataPath("WEB-INF");
                this.addClassPath(root, root, false, true, context);
                try {
                    VirtualFile classes = root.findChild("WEB-INF/classes");
                    this.addClassPath(root, classes, true, false, context);
                }
                catch (IOException e) {
                    this.log.trace("No WEB-INF/classes for: " + root.getPathName());
                }
                try {
                    VirtualFile webinfLib = root.findChild("WEB-INF/lib");
                    List<VirtualFile> archives = webinfLib.getChildren(this.webInfLibFilter);
                    for (VirtualFile jar : archives) {
                        this.addClassPath(root, jar, true, true, context);
                    }
                }
                catch (IOException ignored) {
                    this.log.trace("No WEB-INF/lib for: " + root.getPathName());
                }
                metaData.addContext(context);
                return true;
            }
            this.log.trace("... no - not a directory or an archive.");
            return false;
        }
        catch (Exception e) {
            this.log.warn("Error determining structure: " + root.getName(), e);
            return false;
        }
    }
}

