/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.J2eeModuleMetaData;
import org.jboss.metadata.IconMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.SecurityRoleMetaData;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.mx.util.MBeanServerLocator;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2eeApplicationMetaData
extends MetaData {
    private String displayName;
    private String description;
    private IconMetaData icon = new IconMetaData();
    private String libDirName = "lib";
    private String version;
    private LoaderRepositoryFactory.LoaderRepositoryConfig loaderCfg;
    private HashMap<String, SecurityRoleMetaData> securityRoles = new HashMap();
    private String securityDomain;
    private String unauthenticatedPrincipal;
    private Map<String, J2eeModuleMetaData> modules = new LinkedHashMap<String, J2eeModuleMetaData>();
    private String jmxName;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSmallIcon() {
        return this.icon.getSmallIcon();
    }

    public String getLargeIcon() {
        return this.icon.getLargeIcon();
    }

    public J2eeModuleMetaData getModule(String path) {
        J2eeModuleMetaData module = this.modules.get(path);
        if (module == null && path.startsWith("/")) {
            path = path.substring(1);
            module = this.modules.get(path);
        }
        return module;
    }

    public Iterator<J2eeModuleMetaData> getModules() {
        return this.modules.values().iterator();
    }

    public boolean hasModule(String name) {
        return this.modules.containsKey(name);
    }

    public Map<String, SecurityRoleMetaData> getSecurityRoles() {
        return new HashMap<String, SecurityRoleMetaData>(this.securityRoles);
    }

    public void addSecurityRole(SecurityRoleMetaData role) {
        this.securityRoles.put(role.getRoleName(), role);
    }

    public SecurityRoleMetaData getSecurityRole(String name) {
        return this.securityRoles.get(name);
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String domain) {
        this.securityDomain = domain;
    }

    public String getUnauthenticatedPrincipal() {
        return this.unauthenticatedPrincipal;
    }

    public void setUnauthenticatedPrincipal(String principal) {
        this.unauthenticatedPrincipal = principal;
    }

    public String getJMXName() {
        return this.jmxName;
    }

    public void setJMXName(String name) {
        this.jmxName = name;
    }

    public String getLibraryDirectory() {
        return this.libDirName;
    }

    public void setLibraryDirectory(String name) {
        this.libDirName = name;
    }

    public LoaderRepositoryFactory.LoaderRepositoryConfig getLoaderCfg() {
        return this.loaderCfg;
    }

    public void setLoaderCfg(LoaderRepositoryFactory.LoaderRepositoryConfig loaderCfg) {
        this.loaderCfg = loaderCfg;
    }

    public void addModule(J2eeModuleMetaData moduleMetaData) {
        this.modules.put(moduleMetaData.getFileName(), moduleMetaData);
    }

    @Override
    public void importXml(Element rootElement) throws DeploymentException {
        String rootTag = rootElement.getOwnerDocument().getDocumentElement().getTagName();
        if (rootTag.equals("application")) {
            this.importApplicationXml(rootElement);
        } else if (rootTag.equals("jboss-app")) {
            this.importJBossAppXml(rootElement);
        } else {
            throw new DeploymentException("Unrecognized root tag: " + rootTag);
        }
    }

    protected void importApplicationXml(Element rootElement) throws DeploymentException {
        this.version = J2eeApplicationMetaData.getElementAttribute(rootElement, "version");
        this.displayName = MetaData.getOptionalChildContent(rootElement, "display-name", "");
        Element descrElement = J2eeApplicationMetaData.getOptionalChild(rootElement, "description");
        this.description = descrElement != null ? J2eeApplicationMetaData.getElementContent(descrElement) : "";
        Element iconElement = J2eeApplicationMetaData.getOptionalChild(rootElement, "icon");
        if (iconElement != null) {
            Element element = J2eeApplicationMetaData.getOptionalChild(iconElement, "small-icon");
            String value = element != null ? J2eeApplicationMetaData.getElementContent(element) : "";
            this.icon.setSmallIcon(value);
            element = J2eeApplicationMetaData.getOptionalChild(iconElement, "large-icon");
            value = element != null ? J2eeApplicationMetaData.getElementContent(element) : "";
            this.icon.setLargeIcon(value);
        }
        this.libDirName = J2eeApplicationMetaData.getOptionalChildContent(rootElement, "library-directory", "lib");
        if (this.libDirName != null && this.libDirName.length() == 0) {
            this.libDirName = null;
        }
        Iterator it = J2eeApplicationMetaData.getChildrenByTagName(rootElement, "module");
        while (it.hasNext()) {
            J2eeModuleMetaData moduleMetaData = new J2eeModuleMetaData();
            moduleMetaData.importXml((Element)it.next());
            this.addModule(moduleMetaData);
        }
    }

    protected void importJBossAppXml(Element rootElement) throws DeploymentException {
        Element unauth;
        Element securityDomainElement = J2eeApplicationMetaData.getOptionalChild(rootElement, "security-domain");
        if (securityDomainElement != null) {
            this.securityDomain = J2eeApplicationMetaData.getElementContent(securityDomainElement);
        }
        if ((unauth = J2eeApplicationMetaData.getOptionalChild(rootElement, "unauthenticated-principal")) != null) {
            this.unauthenticatedPrincipal = J2eeApplicationMetaData.getElementContent(unauth);
        } else {
            try {
                MBeanServer server = MBeanServerLocator.locateJBoss();
                ObjectName oname = new ObjectName("jboss.security:service=JaasSecurityManager");
                this.unauthenticatedPrincipal = (String)server.getAttribute(oname, "DefaultUnauthenticatedPrincipal");
            }
            catch (Exception e) {
                log.error("Cannot obtain unauthenticated principal");
            }
        }
        Element loaderRepository = J2eeApplicationMetaData.getOptionalChild(rootElement, "loader-repository");
        if (loaderRepository != null) {
            try {
                this.loaderCfg = LoaderRepositoryFactory.parseRepositoryConfig(loaderRepository);
            }
            catch (MalformedObjectNameException ex) {
                throw new DeploymentException(ex);
            }
        }
        Iterator iterator = J2eeApplicationMetaData.getChildrenByTagName(rootElement, "security-role");
        while (iterator.hasNext()) {
            Element securityRole = (Element)iterator.next();
            String roleName = J2eeApplicationMetaData.getElementContent(J2eeApplicationMetaData.getUniqueChild(securityRole, "role-name"));
            SecurityRoleMetaData srMetaData = new SecurityRoleMetaData(roleName);
            Iterator itPrincipalNames = J2eeApplicationMetaData.getChildrenByTagName(securityRole, "principal-name");
            while (itPrincipalNames.hasNext()) {
                String principalName = J2eeApplicationMetaData.getElementContent((Element)itPrincipalNames.next());
                srMetaData.addPrincipalName(principalName);
            }
            this.securityRoles.put(roleName, srMetaData);
        }
        Element jmxNameElement = J2eeApplicationMetaData.getOptionalChild(rootElement, "jmx-name");
        if (jmxNameElement != null) {
            this.jmxName = J2eeApplicationMetaData.getElementContent(jmxNameElement);
        }
        Iterator it = J2eeApplicationMetaData.getChildrenByTagName(rootElement, "module");
        while (it.hasNext()) {
            J2eeModuleMetaData moduleMetaData = new J2eeModuleMetaData();
            moduleMetaData.importXml((Element)it.next());
            this.addModule(moduleMetaData);
        }
    }
}

