/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.keygen;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.ejb.EJBException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCIdentityColumnCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;

public class JDBC30GeneratedKeysCreateCommand
extends JDBCIdentityColumnCreateCommand {
    private static final Method CONNECTION_PREPARE;
    private static final Integer GENERATE_KEYS;
    private static final Method GET_GENERATED_KEYS;

    public void init(JDBCStoreManager manager) throws DeploymentException {
        if (CONNECTION_PREPARE == null) {
            throw new DeploymentException("Create command requires JDBC 3.0 (JDK1.4+)");
        }
        super.init(manager);
    }

    protected PreparedStatement prepareStatement(Connection c, String sql, EntityEnterpriseContext ctx) throws SQLException {
        try {
            return (PreparedStatement)CONNECTION_PREPARE.invoke((Object)c, sql, GENERATE_KEYS);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int executeInsert(int paramIndex, PreparedStatement ps, EntityEnterpriseContext ctx) throws SQLException {
        int rows = ps.executeUpdate();
        ResultSet rs = null;
        try {
            rs = (ResultSet)GET_GENERATED_KEYS.invoke((Object)ps, null);
            if (!rs.next()) {
                throw new EJBException("getGeneratedKeys returned an empty ResultSet");
            }
            this.pkField.loadInstanceResults(rs, 1, ctx);
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new EJBException("Error extracting generated keys", e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        return rows;
    }

    static {
        Integer generateKeys;
        Method getGeneratedKeys;
        Method prepare;
        try {
            prepare = Connection.class.getMethod("prepareStatement", String.class, Integer.TYPE);
            getGeneratedKeys = PreparedStatement.class.getMethod("getGeneratedKeys", null);
            Field f = PreparedStatement.class.getField("RETURN_GENERATED_KEYS");
            generateKeys = (Integer)f.get(PreparedStatement.class);
        }
        catch (Exception e) {
            prepare = null;
            getGeneratedKeys = null;
            generateKeys = null;
        }
        CONNECTION_PREPARE = prepare;
        GET_GENERATED_KEYS = getGeneratedKeys;
        GENERATE_KEYS = generateKeys;
    }
}

