/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jms;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.naming.Context;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.jms.JMSContainerInvoker;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.metadata.MetaData;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;

public class DLQHandler
extends ServiceMBeanSupport
implements ExceptionListener {
    public static final String PROPERTY_DELIVERY_COUNT = "JMSXDeliveryCount";
    public static final String JBOSS_ORIG_DESTINATION = "JBOSS_ORIG_DESTINATION";
    public static final String JBOSS_ORIG_MESSAGEID = "JBOSS_ORIG_MESSAGEID";
    private static final String JMS_JBOSS_REDELIVERY_COUNT = "JMS_JBOSS_REDELIVERY_COUNT";
    private static final String JMS_JBOSS_REDELIVERY_LIMIT = "JMS_JBOSS_REDELIVERY_LIMIT";
    private String destinationJNDI = "queue/DLQ";
    private int maxResent = 10;
    private long timeToLive = 0L;
    private int deliveryMode = 2;
    private int priority = 4;
    private String dlqUser;
    private String dlqPass;
    private QueueConnection connection;
    private Queue dlq;
    private JMSProviderAdapter providerAdapter;
    private JMSContainerInvoker invoker;
    private Hashtable resentBuffer = new Hashtable();

    public DLQHandler(JMSProviderAdapter providerAdapter, JMSContainerInvoker invoker) {
        this.providerAdapter = providerAdapter;
        this.invoker = invoker;
    }

    public void onException(JMSException e) {
        if (this.invoker != null && this.invoker.exListener != null) {
            this.invoker.exListener.handleFailure(e);
        } else {
            this.log.warn("DLQHandler got JMS Failure but there is no link to JMSContainerInvoker's exception listener.", e);
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Throwable ignored) {
                    this.log.trace("Ignored error closing connection", ignored);
                }
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createService() throws Exception {
        Context ctx = this.providerAdapter.getInitialContext();
        try {
            String factoryName = this.providerAdapter.getQueueFactoryRef();
            QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup(factoryName);
            this.log.debug("Using factory: " + factory);
            this.connection = this.dlqUser == null ? factory.createQueueConnection() : factory.createQueueConnection(this.dlqUser, this.dlqPass);
            this.log.debug("Created connection: " + this.connection);
            this.dlq = (Queue)ctx.lookup(this.destinationJNDI);
            this.log.debug("Using Queue: " + this.dlq);
        }
        finally {
            ctx.close();
        }
    }

    protected void startService() throws Exception {
        this.connection.setExceptionListener(this);
        this.connection.start();
    }

    protected void stopService() throws Exception {
        try {
            this.connection.setExceptionListener(null);
            this.connection.stop();
        }
        catch (Throwable t) {
            this.log.trace("Ignored error stopping DLQ", t);
        }
    }

    protected void destroyService() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
        this.dlq = null;
        this.providerAdapter = null;
    }

    public boolean handleRedeliveredMessage(Message msg, Transaction tx) {
        boolean handled = false;
        int max = this.maxResent;
        String id = null;
        boolean fromMessage = true;
        int count = 0;
        try {
            if (msg.propertyExists(JMS_JBOSS_REDELIVERY_LIMIT)) {
                max = msg.getIntProperty(JMS_JBOSS_REDELIVERY_LIMIT);
            }
            try {
                if (msg.propertyExists(PROPERTY_DELIVERY_COUNT)) {
                    count = msg.getIntProperty(PROPERTY_DELIVERY_COUNT);
                }
            }
            catch (JMSException ignored) {
                // empty catch block
            }
            if (count > 0) {
                --count;
            } else if (msg.propertyExists(JMS_JBOSS_REDELIVERY_COUNT)) {
                count = msg.getIntProperty(JMS_JBOSS_REDELIVERY_COUNT);
            } else {
                id = msg.getJMSMessageID();
                if (id == null) {
                    this.log.error("Message id is null, can't handle message");
                    return false;
                }
                count = this.incrementResentCount(id);
                fromMessage = false;
            }
            if (count > max) {
                id = msg.getJMSMessageID();
                this.log.warn("Message resent too many times; sending it to DLQ; message id=" + id);
                this.sendMessage(msg);
                this.deleteFromBuffer(id);
                handled = true;
            } else if (!fromMessage && tx != null) {
                DLQSynchronization synch = new DLQSynchronization(id);
                try {
                    tx.registerSynchronization(synch);
                }
                catch (Exception e) {
                    this.log.warn("Error registering DlQ Synchronization with transaction " + tx, e);
                }
            }
        }
        catch (JMSException e) {
            this.log.error("Could not send message to Dead Letter Queue", e);
        }
        return handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(Message msg) throws JMSException {
        boolean trace = this.log.isTraceEnabled();
        Session session = null;
        MessageProducer sender = null;
        try {
            msg = this.makeWritable(msg, trace);
            msg.setStringProperty(JBOSS_ORIG_MESSAGEID, msg.getJMSMessageID());
            Destination d = msg.getJMSDestination();
            if (d != null) {
                msg.setStringProperty(JBOSS_ORIG_DESTINATION, d.toString());
            }
            session = this.connection.createQueueSession(false, 1);
            sender = session.createSender(this.dlq);
            if (trace) {
                this.log.trace("Sending message to DLQ; destination=" + this.dlq + ", session=" + session + ", sender=" + sender);
            }
            sender.send(msg, this.deliveryMode, this.priority, this.timeToLive);
            if (trace) {
                this.log.trace("Message sent.");
            }
        }
        finally {
            try {
                if (sender != null) {
                    sender.close();
                }
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e) {
                this.log.warn("Failed to close sender or session; ignoring", e);
            }
        }
    }

    protected int incrementResentCount(String id) {
        BufferEntry entry = null;
        boolean trace = this.log.isTraceEnabled();
        if (!this.resentBuffer.containsKey(id)) {
            if (trace) {
                this.log.trace("Making new entry for id " + id);
            }
            entry = new BufferEntry();
            entry.id = id;
            entry.count = 1;
            this.resentBuffer.put(id, entry);
        } else {
            entry = (BufferEntry)this.resentBuffer.get(id);
            ++entry.count;
            if (trace) {
                this.log.trace("Incremented old entry for id " + id + " count " + entry.count);
            }
        }
        return entry.count;
    }

    protected void deleteFromBuffer(String id) {
        this.resentBuffer.remove(id);
    }

    protected Message makeWritable(Message msg, boolean trace) throws JMSException {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        Enumeration en = msg.getPropertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            tmp.put(key, msg.getObjectProperty(key));
        }
        msg.clearProperties();
        for (Map.Entry me : tmp.entrySet()) {
            String key = (String)me.getKey();
            try {
                msg.setObjectProperty(key, me.getValue());
            }
            catch (JMSException ignored) {
                if (!trace) continue;
                this.log.trace("Could not copy message property " + key, ignored);
            }
        }
        return msg;
    }

    public void importXml(Element element) throws DeploymentException {
        this.destinationJNDI = MetaData.getElementContent(MetaData.getUniqueChild(element, "DestinationQueue"));
        try {
            String mr = MetaData.getElementContent(MetaData.getUniqueChild(element, "MaxTimesRedelivered"));
            this.maxResent = Integer.parseInt(mr);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            String ttl = MetaData.getElementContent(MetaData.getUniqueChild(element, "TimeToLive"));
            this.timeToLive = Long.parseLong(ttl);
            if (this.timeToLive < 0L) {
                this.log.warn("Invalid TimeToLive: " + this.timeToLive + "; using default");
                this.timeToLive = 0L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dlqUser = MetaData.getElementContent(MetaData.getOptionalChild(element, "DLQUser"));
        this.dlqPass = MetaData.getElementContent(MetaData.getOptionalChild(element, "DLQPassword"));
    }

    public String toString() {
        return super.toString() + "{ destinationJNDI=" + this.destinationJNDI + ", maxResent=" + this.maxResent + ", timeToLive=" + this.timeToLive + " }";
    }

    protected class DLQSynchronization
    implements Synchronization {
        String id;

        public DLQSynchronization(String id) {
            this.id = id;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                DLQHandler.this.deleteFromBuffer(this.id);
            }
        }
    }

    private static class BufferEntry {
        int count;
        String id;

        private BufferEntry() {
        }
    }
}

