/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import org.jboss.annotation.ejb.cache.tree.CacheConfig;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Pool;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.injection.Injector;
import org.jboss.logging.Logger;
import org.jboss.util.id.GUID;

public abstract class AbstractPool
implements Pool {
    private static final Logger log = Logger.getLogger(EJBContainer.class);
    protected Class beanClass;
    protected Class contextClass;
    protected Injector[] injectors;
    protected Container container;

    public void initialize(Container container, Class contextClass, Class beanClass, int maxSize, long timeout) {
        this.beanClass = beanClass;
        this.contextClass = contextClass;
        this.container = container;
    }

    public void setMaxSize(int maxSize) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BeanContext create() {
        BeanContext ctx;
        Object bean;
        try {
            bean = this.container.construct();
            ctx = (BeanContext)this.contextClass.newInstance();
            ctx.setContainer(this.container);
            ctx.setInstance(bean);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (ctx instanceof StatefulBeanContext) {
            StatefulBeanContext sfctx = (StatefulBeanContext)ctx;
            sfctx.setId(new GUID());
            Advisor advisor = (Advisor)((Object)this.container);
            CacheConfig config = (CacheConfig)advisor.resolveAnnotation(CacheConfig.class);
            if (config != null) {
                sfctx.setReplicationIsPassivation(config.replicationIsPassivation());
            }
            sfctx = sfctx.pushContainedIn();
            ctx = sfctx;
        }
        try {
            if (this.injectors != null) {
                for (int i = 0; i < this.injectors.length; ++i) {
                    this.injectors[i].inject(ctx);
                }
            }
            ctx.initialiseInterceptorInstances();
        }
        finally {
            if (ctx instanceof StatefulBeanContext) {
                StatefulBeanContext sfctx = (StatefulBeanContext)ctx;
                sfctx.popContainedIn();
            }
        }
        this.container.invokeInit(bean);
        this.container.invokePostConstruct(ctx, new Object[0]);
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BeanContext create(Class[] initTypes, Object[] initValues) {
        BeanContext ctx;
        Object bean;
        try {
            bean = this.container.construct();
            ctx = (BeanContext)this.contextClass.newInstance();
            ctx.setContainer(this.container);
            ctx.setInstance(bean);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (ctx instanceof StatefulBeanContext) {
            StatefulBeanContext sfctx = (StatefulBeanContext)ctx;
            sfctx.setId(new GUID());
            Advisor advisor = (Advisor)((Object)this.container);
            CacheConfig config = (CacheConfig)advisor.resolveAnnotation(CacheConfig.class);
            if (config != null) {
                sfctx.setReplicationIsPassivation(config.replicationIsPassivation());
            }
            sfctx = sfctx.pushContainedIn();
            ctx = sfctx;
        }
        try {
            if (this.injectors != null) {
                for (int i = 0; i < this.injectors.length; ++i) {
                    this.injectors[i].inject(ctx);
                }
            }
            ctx.initialiseInterceptorInstances();
        }
        finally {
            if (ctx instanceof StatefulBeanContext) {
                StatefulBeanContext sfctx = (StatefulBeanContext)ctx;
                sfctx.popContainedIn();
            }
        }
        this.container.invokeInit(bean, initTypes, initValues);
        this.container.invokePostConstruct(ctx, initValues);
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(BeanContext ctx) {
        try {
            this.container.invokePreDestroy(ctx);
        }
        finally {
            ctx.remove();
        }
    }

    public void discard(BeanContext ctx) {
        this.remove(ctx);
    }

    public void setInjectors(Injector[] injectors) {
        this.injectors = injectors;
    }
}

