/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.ArrayList;
import java.util.List;
import org.jboss.annotation.ejb.Clustered;
import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.annotation.ejb.LocalBindingImpl;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.annotation.ejb.RemoteBindingImpl;
import org.jboss.annotation.ejb.RemoteBindings;
import org.jboss.annotation.ejb.RemoteBindingsImpl;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.remoting.RemoteProxyFactory;
import org.jboss.ejb3.service.ServiceContainer;
import org.jboss.ejb3.service.ServiceLocalProxyFactory;
import org.jboss.ejb3.service.ServiceRemoteProxyFactory;
import org.jboss.ejb3.stateful.StatefulClusterProxyFactory;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulLocalProxyFactory;
import org.jboss.ejb3.stateful.StatefulRemoteProxyFactory;
import org.jboss.ejb3.stateless.StatelessClusterProxyFactory;
import org.jboss.ejb3.stateless.StatelessLocalProxyFactory;
import org.jboss.ejb3.stateless.StatelessRemoteProxyFactory;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyDeployer {
    private static final Logger log = Logger.getLogger(ProxyDeployer.class);
    private Container container;
    private Advisor advisor;
    private ArrayList<ProxyFactory> proxyFactories = new ArrayList();
    private RemoteBindings remoteBindings;
    private LocalBinding localBinding;

    public ProxyDeployer(Container container) {
        this.container = container;
        this.advisor = (Advisor)((Object)container);
    }

    public List<ProxyFactory> getProxyFactories() {
        return this.proxyFactories;
    }

    public void start() throws Exception {
        if (this.remoteBindings != null) {
            RemoteBinding[] list2 = this.remoteBindings.value();
            for (int i = 0; i < list2.length; ++i) {
                Class factoryClass = list2[i].factory();
                if (factoryClass.equals(RemoteProxyFactory.class)) {
                    factoryClass = this.getDefaultRemoteProxyFactory();
                }
                RemoteProxyFactory factory = (RemoteProxyFactory)factoryClass.newInstance();
                factory.setRemoteBinding(list2[i]);
                factory.setContainer(this.container);
                factory.start();
                this.proxyFactories.add(factory);
            }
        }
        if (this.localBinding != null) {
            ProxyFactory factory = null;
            factory = this.container instanceof StatefulContainer ? new StatefulLocalProxyFactory() : (this.container instanceof ServiceContainer ? new ServiceLocalProxyFactory() : new StatelessLocalProxyFactory());
            factory.setContainer(this.container);
            factory.start();
            this.proxyFactories.add(factory);
        }
    }

    public void initializeLocalBindingMetadata() {
        this.localBinding = (LocalBinding)this.advisor.resolveAnnotation(LocalBinding.class);
        if (this.localBinding == null && ProxyFactoryHelper.getLocalInterfaces(this.container) != null) {
            this.localBinding = new LocalBindingImpl(ProxyFactoryHelper.getLocalJndiName(this.container));
            this.advisor.getAnnotations().addClassAnnotation(LocalBinding.class, this.localBinding);
        }
    }

    public void initializeRemoteBindingMetadata() {
        this.remoteBindings = (RemoteBindings)this.advisor.resolveAnnotation(RemoteBindings.class);
        if (this.remoteBindings == null) {
            RemoteBinding binding = (RemoteBinding)this.advisor.resolveAnnotation(RemoteBinding.class);
            if (binding == null) {
                log.debug("no declared remote bindings for : " + this.container.getEjbName());
                if (ProxyFactoryHelper.getRemoteInterfaces(this.container) != null) {
                    log.debug("there is remote interfaces for " + this.container.getEjbName());
                    String jndiName = ProxyFactoryHelper.getDefaultRemoteJndiName(this.container);
                    log.debug("default remote binding has jndiName of " + jndiName);
                    String uri = "";
                    Class factory = null;
                    factory = this.getDefaultRemoteProxyFactory();
                    RemoteBinding[] list2 = new RemoteBinding[]{new RemoteBindingImpl(jndiName, "", uri, factory)};
                    this.remoteBindings = new RemoteBindingsImpl(list2);
                    this.advisor.getAnnotations().addClassAnnotation(RemoteBindings.class, this.remoteBindings);
                }
            } else {
                RemoteBinding[] list3 = new RemoteBinding[]{binding};
                this.remoteBindings = new RemoteBindingsImpl(list3);
                this.advisor.getAnnotations().addClassAnnotation(RemoteBindings.class, this.remoteBindings);
            }
        }
    }

    private Class getDefaultRemoteProxyFactory() {
        Class factory = this.container instanceof StatefulContainer ? (this.advisor.resolveAnnotation(Clustered.class) != null ? StatefulClusterProxyFactory.class : StatefulRemoteProxyFactory.class) : (this.container instanceof ServiceContainer ? ServiceRemoteProxyFactory.class : (this.advisor.resolveAnnotation(Clustered.class) != null ? StatelessClusterProxyFactory.class : StatelessRemoteProxyFactory.class));
        return factory;
    }

    public void stop() throws Exception {
        for (int i = 0; i < this.proxyFactories.size(); ++i) {
            ProxyFactory factory = this.proxyFactories.get(i);
            factory.stop();
        }
    }
}

