/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.destination;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.jms.selector.Selector;
import org.jboss.jms.server.destination.ManagedDestination;
import org.jboss.jms.server.messagecounter.MessageCounter;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.Queue;
import org.jboss.messaging.core.message.Message;

public class ManagedQueue
extends ManagedDestination {
    private static final Logger log = Logger.getLogger(ManagedQueue.class);
    private static boolean trace = log.isTraceEnabled();
    private MessageCounter messageCounter;
    private Queue queue;

    public ManagedQueue() {
    }

    public ManagedQueue(String name, int fullSize, int pageSize, int downCacheSize) {
        super(name, fullSize, pageSize, downCacheSize);
    }

    public boolean isQueue() {
        return true;
    }

    public void setMessageCounterHistoryDayLimit(int limit) throws Exception {
        super.setMessageCounterHistoryDayLimit(limit);
        if (this.messageCounter != null) {
            this.messageCounter.setHistoryLimit(limit);
        }
    }

    public int getMessageCount() throws Exception {
        int count = this.queue.getMessageCount();
        if (trace) {
            log.trace(this + " returning MessageCount = " + count);
        }
        return count;
    }

    public int getScheduledMessageCount() throws Exception {
        int count = this.queue.getScheduledCount();
        if (trace) {
            log.trace(this + " returning ScheduledMessageCount = " + count);
        }
        return count;
    }

    public int getConsumersCount() throws Exception {
        int count = this.queue.getNumberOfReceivers();
        if (trace) {
            log.trace(this + " returning ConsumersCount = " + count);
        }
        return count;
    }

    public void removeAllMessages() throws Throwable {
        this.queue.removeAllReferences();
    }

    public List listAllMessages(String selector) throws Exception {
        return this.listMessages(0, selector);
    }

    public List listDurableMessages(String selector) throws Exception {
        return this.listMessages(1, selector);
    }

    public List listNonDurableMessages(String selector) throws Exception {
        return this.listMessages(2, selector);
    }

    private List listMessages(int type, String selector) throws Exception {
        Selector sel = null;
        if (selector != null && "".equals(selector.trim())) {
            selector = null;
        }
        if (selector != null) {
            sel = new Selector(selector);
        }
        ArrayList<Message> msgs = new ArrayList<Message>();
        List allMsgs = this.queue.browse(sel);
        Iterator iter = allMsgs.iterator();
        while (iter.hasNext()) {
            Message msg = (Message)iter.next();
            if (type != 0 && (type != 1 || !msg.isReliable()) && (type != 2 || msg.isReliable())) continue;
            msgs.add(msg);
        }
        return msgs;
    }

    public MessageCounter getMessageCounter() {
        return this.messageCounter;
    }

    public void setMessageCounter(MessageCounter counter) {
        this.messageCounter = counter;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public String toString() {
        return "ManagedQueue[" + this.name + "]";
    }
}

