/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.messagecounter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.jms.server.messagecounter.MessageCounter;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.plugin.contract.MessagingComponent;

public class MessageCounterManager
implements MessagingComponent {
    private static final Logger log = Logger.getLogger(MessageCounterManager.class);
    private Map messageCounters = new HashMap();
    private boolean started;
    private Timer timer;
    private long period;
    private PingMessageCountersTask task;

    public MessageCounterManager(long period) {
        this.period = period;
    }

    public synchronized void start() {
        if (this.started) {
            log.warn(this + " already started");
            return;
        }
        this.timer = new Timer(true);
        this.task = new PingMessageCountersTask();
        this.timer.schedule((TimerTask)this.task, 0L, this.period);
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            log.warn(this + " isn't started");
            return;
        }
        this.task.stop();
        this.timer.cancel();
        this.timer = null;
        this.started = false;
    }

    public synchronized void reschedule(long newPeriod) {
        boolean wasStarted = this.started;
        if (wasStarted) {
            this.stop();
        }
        this.period = newPeriod;
        if (wasStarted) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageCounter(String name, MessageCounter counter) {
        Map map = this.messageCounters;
        synchronized (map) {
            this.messageCounters.put(name, counter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageCounter unregisterMessageCounter(String name) {
        Map map = this.messageCounters;
        synchronized (map) {
            return (MessageCounter)this.messageCounters.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getMessageCounters() {
        Map map = this.messageCounters;
        synchronized (map) {
            return new HashSet(this.messageCounters.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageCounter getMessageCounter(String name) {
        Map map = this.messageCounters;
        synchronized (map) {
            return (MessageCounter)this.messageCounters.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAllCounters() {
        Map map = this.messageCounters;
        synchronized (map) {
            Iterator iter = this.messageCounters.values().iterator();
            while (iter.hasNext()) {
                MessageCounter counter = (MessageCounter)iter.next();
                counter.resetCounter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAllCounterHistories() {
        Map map = this.messageCounters;
        synchronized (map) {
            Iterator iter = this.messageCounters.values().iterator();
            while (iter.hasNext()) {
                MessageCounter counter = (MessageCounter)iter.next();
                counter.resetHistory();
            }
        }
    }

    class PingMessageCountersTask
    extends TimerTask {
        PingMessageCountersTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            Map map = MessageCounterManager.this.messageCounters;
            synchronized (map) {
                Iterator iter = MessageCounterManager.this.messageCounters.values().iterator();
                while (iter.hasNext()) {
                    MessageCounter counter = (MessageCounter)iter.next();
                    counter.onTimer();
                }
            }
        }

        synchronized void stop() {
            this.cancel();
        }
    }
}

