/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.tx;

import java.util.HashMap;
import java.util.Map;
import org.jboss.jms.tx.ResourceManager;

public class ResourceManagerFactory {
    public static ResourceManagerFactory instance = new ResourceManagerFactory();
    private Map holders = new HashMap();

    private ResourceManagerFactory() {
    }

    public synchronized void clear() {
        this.holders.clear();
    }

    public synchronized int size() {
        return this.holders.size();
    }

    public synchronized boolean containsResourceManager(int serverID) {
        return this.holders.containsKey(new Integer(serverID));
    }

    public synchronized ResourceManager checkOutResourceManager(int serverID) {
        Integer i = new Integer(serverID);
        Holder h = (Holder)this.holders.get(i);
        if (h == null) {
            h = new Holder();
            this.holders.put(i, h);
        } else {
            ++h.refCount;
        }
        return h.rm;
    }

    public synchronized void checkInResourceManager(int serverID) {
        Integer i = new Integer(serverID);
        Holder h = (Holder)this.holders.get(i);
        if (h == null) {
            throw new IllegalArgumentException("Cannot find resource manager for server: " + serverID);
        }
        --h.refCount;
        if (h.refCount == 0) {
            this.holders.remove(i);
        }
    }

    public synchronized void handleFailover(int oldServerID, int newServerID) {
        Holder hOld = (Holder)this.holders.remove(new Integer(oldServerID));
        if (hOld == null) {
            return;
        }
        ResourceManager oldRM = hOld.rm;
        ResourceManager newRM = null;
        Holder hNew = (Holder)this.holders.get(new Integer(newServerID));
        if (hNew != null) {
            newRM = hNew.rm;
            newRM.merge(oldRM);
        } else {
            Holder h = new Holder(oldRM);
            this.holders.put(new Integer(newServerID), h);
        }
    }

    private static class Holder {
        ResourceManager rm;
        int refCount = 1;

        Holder() {
            this.rm = new ResourceManager();
        }

        Holder(ResourceManager rm) {
            this.rm = rm;
        }
    }
}

