/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.util;

import java.util.StringTokenizer;

public class MessageQueueNameHelper {
    private String clientId;
    private String subName;
    private static String SEPARATOR = ".";

    private MessageQueueNameHelper(String messageQueueName) {
        if (messageQueueName == null) {
            throw new IllegalArgumentException("Message queue name is null");
        }
        StringTokenizer tok = new StringTokenizer(messageQueueName, SEPARATOR);
        int count = 0;
        while (tok.hasMoreElements()) {
            String token = (String)tok.nextElement();
            if (count == 0) {
                this.clientId = token;
            } else if (count == 1) {
                this.subName = token;
            }
            ++count;
        }
        if (count != 2) {
            throw new IllegalArgumentException("Invalid message queue name: " + messageQueueName);
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getSubName() {
        return this.subName;
    }

    public static MessageQueueNameHelper createHelper(String messageQueueName) {
        return new MessageQueueNameHelper(messageQueueName);
    }

    public static String createSubscriptionName(String clientID, String subName) {
        if (clientID == null) {
            throw new IllegalArgumentException("clientID name is null");
        }
        if (subName == null) {
            throw new IllegalArgumentException("Subscription name is null");
        }
        return clientID + SEPARATOR + subName;
    }
}

