/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate;
import org.jboss.jms.wireformat.CallbackSupport;

public class ConnectionFactoryUpdate
extends CallbackSupport {
    private ClientConnectionFactoryDelegate[] delegates;
    private Map failoverMap;

    public ConnectionFactoryUpdate(ClientConnectionFactoryDelegate[] delegates, Map failoverMap) {
        super(3);
        this.delegates = delegates;
        this.failoverMap = failoverMap;
    }

    public ConnectionFactoryUpdate() {
    }

    public ClientConnectionFactoryDelegate[] getDelegates() {
        return this.delegates;
    }

    public void setDelegates(ClientConnectionFactoryDelegate[] delegates) {
        this.delegates = delegates;
    }

    public Map getFailoverMap() {
        return this.failoverMap;
    }

    public void setFailoverMap(Map failoverMap) {
        this.failoverMap = failoverMap;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ConnectionFactoryUpdateMessage[");
        if (this.delegates != null) {
            for (int i = 0; i < this.delegates.length; ++i) {
                sb.append(this.delegates[i]);
                if (i >= this.delegates.length - 1) continue;
                sb.append(',');
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public void read(DataInputStream is) throws Exception {
        int len = is.readInt();
        this.delegates = new ClientConnectionFactoryDelegate[len];
        for (int i = 0; i < len; ++i) {
            this.delegates[i] = new ClientConnectionFactoryDelegate();
            this.delegates[i].read(is);
        }
        len = is.readInt();
        this.failoverMap = new HashMap(len);
        for (int c = 0; c < len; ++c) {
            Integer i = new Integer(is.readInt());
            Integer j = new Integer(is.readInt());
            this.failoverMap.put(i, j);
        }
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        int len = this.delegates.length;
        os.writeInt(len);
        for (int i = 0; i < len; ++i) {
            this.delegates[i].write(os);
        }
        os.writeInt(this.failoverMap.size());
        Iterator iter = this.failoverMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Integer i = (Integer)entry.getKey();
            Integer j = (Integer)entry.getValue();
            os.writeInt(i);
            os.writeInt(j);
        }
        os.flush();
    }
}

