/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.server.endpoint.SessionEndpoint;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;
import org.jboss.jms.wireformat.SessionCreateTopicResponse;

public class SessionCreateTopicRequest
extends RequestSupport {
    private String topicName;

    public SessionCreateTopicRequest() {
    }

    public SessionCreateTopicRequest(int objectId, byte version, String topicName) {
        super(objectId, 304, version);
        this.topicName = topicName;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        this.topicName = is.readUTF();
    }

    public ResponseSupport serverInvoke() throws Exception {
        SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        return new SessionCreateTopicResponse(endpoint.createTopic(this.topicName));
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeUTF(this.topicName);
        os.flush();
    }
}

