/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.metadata.basic;

import java.util.ArrayList;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.kernel.plugins.metadata.AbstractKernelMetaDataRepository;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.metadata.plugins.context.AbstractMetaDataContext;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.plugins.loader.reflection.AnnotatedElementMetaDataLoader;
import org.jboss.metadata.plugins.repository.basic.BasicMetaDataRepository;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.stack.MetaDataStack;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicKernelMetaDataRepository
extends AbstractKernelMetaDataRepository {
    public BasicKernelMetaDataRepository() {
        super(new BasicMetaDataRepository());
    }

    @Override
    public MetaData getMetaData(KernelControllerContext context) {
        ScopeKey scope;
        MutableMetaDataRepository repository = this.getMetaDataRepository();
        MetaData metaData = repository.getMetaData(scope = context.getScope());
        if (metaData == null) {
            this.initMetaDataRetrieval(context);
            metaData = repository.getMetaData(scope);
        }
        return metaData;
    }

    @Override
    public MetaDataRetrieval getMetaDataRetrieval(KernelControllerContext context) {
        ScopeKey scope;
        MutableMetaDataRepository repository = this.getMetaDataRepository();
        MetaDataRetrieval metaDataRetrieval = repository.getMetaDataRetrieval(scope = context.getScope());
        if (metaDataRetrieval == null) {
            metaDataRetrieval = this.initMetaDataRetrieval(context);
        }
        return metaDataRetrieval;
    }

    public void popMetaData(KernelControllerContext context) {
        MetaDataStack.pop();
    }

    @Override
    public void addMetaData(KernelControllerContext context) {
        MutableMetaDataRepository repository = this.getMetaDataRepository();
        ScopeKey scope = this.getMutableScope(context);
        MemoryMetaDataLoader mutable = new MemoryMetaDataLoader(scope);
        repository.addMetaDataRetrieval(mutable);
        this.addClassAnnotations(mutable, context);
        this.addPropertyAnnotations(mutable, context);
    }

    @Override
    public void removeMetaData(KernelControllerContext context) {
        MutableMetaDataRepository repository = this.getMetaDataRepository();
        ScopeKey scope = context.getScope();
        repository.removeMetaDataRetrieval(scope);
        scope = this.getMutableScope(context);
        repository.removeMetaDataRetrieval(scope);
    }

    @Override
    public ScopeKey getFullScope(KernelControllerContext context) {
        String bean;
        ScopeKey scope = ScopeKey.DEFAULT_SCOPE.clone();
        scope.addScope(CommonLevels.INSTANCE, context.getName().toString());
        BeanMetaData beanMetaData = context.getBeanMetaData();
        if (beanMetaData != null && (bean = beanMetaData.getBean()) != null) {
            scope.addScope(CommonLevels.CLASS, bean);
        }
        return scope;
    }

    @Override
    public ScopeKey getMutableScope(KernelControllerContext context) {
        return new ScopeKey(CommonLevels.INSTANCE, context.getName().toString());
    }

    protected MetaDataRetrieval initMetaDataRetrieval(KernelControllerContext context) {
        MutableMetaDataRepository repository = this.getMetaDataRepository();
        ScopeKey scopeKey = context.getScope();
        ArrayList<MetaDataRetrieval> retrievals = new ArrayList<MetaDataRetrieval>();
        for (Scope scope : scopeKey.getScopes()) {
            ScopeKey thisScope = new ScopeKey(scope);
            MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(thisScope);
            if (retrieval == null) {
                if (scope.getScopeLevel() == CommonLevels.CLASS) {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    try {
                        Class<?> clazz = cl.loadClass(scope.getQualifier());
                        retrieval = new AnnotatedElementMetaDataLoader(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Unable to load class: " + scope.getQualifier(), e);
                    }
                } else {
                    retrieval = new MemoryMetaDataLoader(thisScope);
                    repository.addMetaDataRetrieval(retrieval);
                }
            }
            retrievals.add(0, retrieval);
        }
        AbstractMetaDataContext metaDataContext = new AbstractMetaDataContext(null, retrievals);
        repository.addMetaDataRetrieval(metaDataContext);
        return metaDataContext;
    }

    private void addClassAnnotations(MemoryMetaDataLoader mutable, KernelControllerContext context) {
        BeanMetaData beanMetaData = context.getBeanMetaData();
        if (beanMetaData != null) {
            this.addAnnotations(mutable, beanMetaData.getAnnotations());
        }
    }

    private void addPropertyAnnotations(MemoryMetaDataLoader mutable, KernelControllerContext context) {
        BeanMetaData beanMetaData = context.getBeanMetaData();
        if (beanMetaData == null) {
            return;
        }
        Set<PropertyMetaData> properties = beanMetaData.getProperties();
        if (properties == null || properties.size() == 0) {
            return;
        }
        BeanInfo beanInfo = context.getBeanInfo();
        if (beanInfo == null) {
            return;
        }
        for (PropertyMetaData property : properties) {
            this.addPropertyAnnotations(mutable, property, beanInfo);
        }
    }

    private void addPropertyAnnotations(MemoryMetaDataLoader mutable, PropertyMetaData propertyMetaData, BeanInfo beanInfo) {
        Set<AnnotationMetaData> propertyAnnotations = propertyMetaData.getAnnotations();
        if (propertyAnnotations == null || propertyAnnotations.size() == 0) {
            return;
        }
        Set<PropertyInfo> propertyInfos = beanInfo.getProperties();
        if (propertyInfos != null && propertyInfos.size() > 0) {
            for (PropertyInfo propertyInfo : propertyInfos) {
                if (!propertyInfo.getName().equals(propertyMetaData.getName())) continue;
                MethodInfo methodInfo = propertyInfo.getGetter();
                if (methodInfo != null) {
                    this.addAnnotations(mutable, methodInfo, propertyAnnotations);
                }
                if ((methodInfo = propertyInfo.getSetter()) == null) continue;
                this.addAnnotations(mutable, methodInfo, propertyAnnotations);
            }
        }
    }

    private void addAnnotations(MemoryMetaDataLoader mutable, MethodInfo methodInfo, Set<AnnotationMetaData> annotations) {
        TypeInfo[] typeInfos = methodInfo.getParameterTypes();
        String[] paramTypes = new String[typeInfos.length];
        for (int i = 0; i < typeInfos.length; ++i) {
            paramTypes[i] = typeInfos[i].getName();
        }
        ScopeKey scope = new ScopeKey(CommonLevels.JOINPOINT_OVERRIDE, methodInfo.getName());
        MemoryMetaDataLoader loader = new MemoryMetaDataLoader(scope);
        this.addAnnotations(loader, annotations);
        mutable.addComponentMetaDataRetrieval(new MethodSignature(methodInfo.getName(), paramTypes), loader);
    }

    private void addAnnotations(MemoryMetaDataLoader mutable, Set<AnnotationMetaData> annotations) {
        if (annotations == null || annotations.size() == 0) {
            return;
        }
        for (AnnotationMetaData annotation : annotations) {
            mutable.addAnnotation(annotation.getAnnotationInstance());
        }
    }
}

