/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.local;

import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.Delivery;
import org.jboss.messaging.core.DeliveryObserver;
import org.jboss.messaging.core.Receiver;
import org.jboss.messaging.core.Router;
import org.jboss.messaging.core.SimpleDelivery;
import org.jboss.messaging.core.message.MessageReference;
import org.jboss.messaging.core.tx.Transaction;

public class RoundRobinPointToPointRouter
implements Router {
    private static final Logger log = Logger.getLogger(RoundRobinPointToPointRouter.class);
    private boolean trace = log.isTraceEnabled();
    private ArrayList receivers = new ArrayList();
    private int target = 0;
    private volatile boolean makeCopy = true;
    private ArrayList receiversCopy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Delivery handle(DeliveryObserver observer, MessageReference ref, Transaction tx) {
        if (this.makeCopy) {
            RoundRobinPointToPointRouter roundRobinPointToPointRouter = this;
            synchronized (roundRobinPointToPointRouter) {
                this.receiversCopy = new ArrayList(this.receivers);
                if (this.target >= this.receiversCopy.size()) {
                    this.target = 0;
                }
                this.makeCopy = false;
            }
        }
        if (this.receiversCopy.isEmpty()) {
            return null;
        }
        Delivery del = null;
        boolean selectorRejected = false;
        int initial = this.target;
        do {
            block12: {
                Receiver r = (Receiver)this.receiversCopy.get(this.target);
                try {
                    Delivery d = r.handle(observer, ref, tx);
                    if (this.trace) {
                        log.trace("receiver " + r + " handled " + ref + " and returned " + d);
                    }
                    if (d == null) break block12;
                    if (d.isSelectorAccepted()) {
                        del = d;
                        this.incTarget();
                        break;
                    }
                    selectorRejected = true;
                }
                catch (Throwable t) {
                    log.error("The receiver " + r + " is broken", t);
                }
            }
            this.incTarget();
        } while (this.target != initial);
        if (del == null && selectorRejected) {
            del = new SimpleDelivery(null, null, true, false);
        }
        return del;
    }

    public synchronized boolean add(Receiver r) {
        if (this.receivers.contains(r)) {
            return false;
        }
        this.receivers.add(r);
        this.makeCopy = true;
        return true;
    }

    public synchronized boolean remove(Receiver r) {
        boolean removed = this.receivers.remove(r);
        if (removed) {
            this.makeCopy = true;
        }
        return removed;
    }

    public synchronized void clear() {
        this.receivers.clear();
        this.makeCopy = true;
    }

    public synchronized boolean contains(Receiver r) {
        return this.receivers.contains(r);
    }

    public synchronized Iterator iterator() {
        return this.receivers.iterator();
    }

    public synchronized int getNumberOfReceivers() {
        return this.receivers.size();
    }

    private void incTarget() {
        ++this.target;
        if (this.target == this.receiversCopy.size()) {
            this.target = 0;
        }
    }
}

