/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.memory;

import org.jboss.logging.Logger;
import org.jboss.messaging.core.memory.MemoryManager;

public class SimpleMemoryManager
implements MemoryManager {
    private static final Logger log = Logger.getLogger(SimpleMemoryManager.class);
    private static final long DEFAULT_MEASURE_INTERVAL = 3000L;
    private static final int DEFAULT_FREE_MEMORY_PERCENT = 25;
    private Runtime runtime = Runtime.getRuntime();
    private long measureInterval = 3000L;
    private int freeMemoryPercent = 25;
    private volatile boolean started;
    private Thread thread;
    private volatile boolean low;

    public boolean isMemoryLow() {
        return this.low;
    }

    public synchronized void start() {
        log.debug("Starting MemoryManager with MEASURE_INTERVAL: " + this.measureInterval + " FREE_MEMORY_PERCENT: " + this.freeMemoryPercent);
        if (this.started) {
            return;
        }
        this.started = true;
        this.thread = new Thread(new MemoryRunnable());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class MemoryRunnable
    implements Runnable {
        private MemoryRunnable() {
        }

        public void run() {
            while (true) {
                try {
                    if (SimpleMemoryManager.this.thread.isInterrupted() && !SimpleMemoryManager.this.started) break;
                    Thread.sleep(SimpleMemoryManager.this.measureInterval);
                }
                catch (InterruptedException ignore) {
                    if (!SimpleMemoryManager.this.started) break;
                }
                long freeMemory = SimpleMemoryManager.this.runtime.freeMemory();
                long maxMemory = SimpleMemoryManager.this.runtime.maxMemory();
                long totalMemory = SimpleMemoryManager.this.runtime.totalMemory();
                long availableMemory = freeMemory + maxMemory - totalMemory;
                if (100L * availableMemory / totalMemory <= (long)SimpleMemoryManager.this.freeMemoryPercent) {
                    SimpleMemoryManager.this.low = true;
                    continue;
                }
                SimpleMemoryManager.this.low = false;
            }
        }
    }
}

