/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.message;

import org.jboss.messaging.core.message.Message;
import org.jboss.messaging.core.message.SimpleMessageStore;

class MessageHolder {
    private int inMemoryChannelCount;
    private Message msg;
    private SimpleMessageStore ms;

    public MessageHolder(Message msg, SimpleMessageStore ms) {
        this.msg = msg;
        this.ms = ms;
    }

    public synchronized void incrementInMemoryChannelCount() {
        ++this.inMemoryChannelCount;
    }

    public synchronized void decrementInMemoryChannelCount() {
        --this.inMemoryChannelCount;
        if (this.inMemoryChannelCount == 0) {
            this.ms.forgetMessage(this.msg.getMessageID());
        }
    }

    public synchronized int getInMemoryChannelCount() {
        return this.inMemoryChannelCount;
    }

    public Message getMessage() {
        return this.msg;
    }
}

