/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.Delivery;
import org.jboss.messaging.core.Filter;
import org.jboss.messaging.core.FilterFactory;
import org.jboss.messaging.core.Queue;
import org.jboss.messaging.core.message.MessageReference;
import org.jboss.messaging.core.plugin.contract.ClusteredPostOffice;
import org.jboss.messaging.core.plugin.contract.Condition;
import org.jboss.messaging.core.plugin.contract.ConditionFactory;
import org.jboss.messaging.core.plugin.contract.FailoverMapper;
import org.jboss.messaging.core.plugin.contract.MessageStore;
import org.jboss.messaging.core.plugin.contract.PersistenceManager;
import org.jboss.messaging.core.plugin.contract.ReplicationListener;
import org.jboss.messaging.core.plugin.contract.Replicator;
import org.jboss.messaging.core.plugin.postoffice.Binding;
import org.jboss.messaging.core.plugin.postoffice.DefaultBinding;
import org.jboss.messaging.core.plugin.postoffice.DefaultPostOffice;
import org.jboss.messaging.core.plugin.postoffice.cluster.BindRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.BindingInfo;
import org.jboss.messaging.core.plugin.postoffice.cluster.CastMessagesCallback;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterRouter;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterRouterFactory;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterTransaction;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusteredBindings;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusteredQueue;
import org.jboss.messaging.core.plugin.postoffice.cluster.DefaultClusteredBindings;
import org.jboss.messaging.core.plugin.postoffice.cluster.FailoverStatus;
import org.jboss.messaging.core.plugin.postoffice.cluster.LeaveClusterRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.LocalClusteredQueue;
import org.jboss.messaging.core.plugin.postoffice.cluster.MessagePullPolicy;
import org.jboss.messaging.core.plugin.postoffice.cluster.MessageRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.PostOfficeAddressInfo;
import org.jboss.messaging.core.plugin.postoffice.cluster.PostOfficeInternal;
import org.jboss.messaging.core.plugin.postoffice.cluster.PutReplicantRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.QueueStats;
import org.jboss.messaging.core.plugin.postoffice.cluster.QueueStatsRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.RemoteQueueStub;
import org.jboss.messaging.core.plugin.postoffice.cluster.RemoveReplicantRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.RollbackPullRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.SharedState;
import org.jboss.messaging.core.plugin.postoffice.cluster.StatsSender;
import org.jboss.messaging.core.plugin.postoffice.cluster.TransactionId;
import org.jboss.messaging.core.plugin.postoffice.cluster.UnbindRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.jchannelfactory.JChannelFactory;
import org.jboss.messaging.core.tx.Transaction;
import org.jboss.messaging.core.tx.TransactionRepository;
import org.jboss.messaging.util.StreamUtils;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;

public class DefaultClusteredPostOffice
extends DefaultPostOffice
implements ClusteredPostOffice,
PostOfficeInternal,
Replicator {
    private static final Logger log = Logger.getLogger(DefaultClusteredPostOffice.class);
    public static final String ADDRESS_INFO_KEY = "ADDRESS_INFO";
    public static final String FAILED_OVER_FOR_KEY = "FAILED_OVER_FOR";
    private boolean failBeforeCommit;
    private boolean failAfterCommit;
    private boolean failHandleResult;
    private boolean trace = log.isTraceEnabled();
    private String groupName;
    private volatile boolean started;
    private volatile boolean stopping;
    private JChannelFactory jChannelFactory;
    private Channel syncChannel;
    private Channel asyncChannel;
    private MessageDispatcher controlMessageDispatcher;
    private Object setStateLock = new Object();
    private boolean stateSet;
    private View currentView;
    private Map replicatedData;
    private Set replicationListeners;
    private Map holdingArea;
    private Map failoverMap;
    private Set leftSet;
    private long stateTimeout;
    private long castTimeout;
    private MessagePullPolicy messagePullPolicy;
    private ClusterRouterFactory routerFactory;
    private FailoverMapper failoverMapper;
    private Map routerMap;
    private StatsSender statsSender;
    private ReplicationListener nodeAddressMapListener;
    private NotificationBroadcasterSupport nbSupport;
    private QueuedExecutor viewExecutor;
    private PooledExecutor pooledExecutor;

    public static String dumpFailoverMap(Map map) {
        StringBuffer sb = new StringBuffer("\n");
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Integer primary = (Integer)entry.getKey();
            Integer secondary = (Integer)entry.getValue();
            sb.append("             ").append(primary).append("->").append(secondary).append("\n");
        }
        return sb.toString();
    }

    public static String dumpClusterMap(Map map) {
        StringBuffer sb = new StringBuffer("\n");
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Integer nodeID = (Integer)entry.getKey();
            PostOfficeAddressInfo info = (PostOfficeAddressInfo)entry.getValue();
            sb.append("             ").append(nodeID).append("->").append(info).append("\n");
        }
        return sb.toString();
    }

    public DefaultClusteredPostOffice(DataSource ds, TransactionManager tm, Properties sqlProperties, boolean createTablesOnStartup, int nodeId, String officeName, MessageStore ms, PersistenceManager pm, TransactionRepository tr, FilterFactory filterFactory, ConditionFactory conditionFactory, String groupName, JChannelFactory JChannelFactory2, long stateTimeout, long castTimeout, MessagePullPolicy redistributionPolicy, ClusterRouterFactory rf, FailoverMapper failoverMapper, long statsSendPeriod, int poolSize) throws Exception {
        super(ds, tm, sqlProperties, createTablesOnStartup, nodeId, officeName, ms, pm, tr, filterFactory, conditionFactory);
        this.groupName = groupName;
        this.stateTimeout = stateTimeout;
        this.castTimeout = castTimeout;
        this.messagePullPolicy = redistributionPolicy;
        this.routerFactory = rf;
        this.failoverMapper = failoverMapper;
        this.routerMap = new HashMap();
        this.statsSender = new StatsSender(this, statsSendPeriod);
        this.holdingArea = new HashMap();
        this.replicatedData = new HashMap();
        this.replicationListeners = new LinkedHashSet();
        this.failoverMap = new LinkedHashMap();
        this.leftSet = new HashSet();
        this.nbSupport = new NotificationBroadcasterSupport();
        this.viewExecutor = new QueuedExecutor();
        this.jChannelFactory = JChannelFactory2;
        this.pooledExecutor = new PooledExecutor((EDU.oswego.cs.dl.util.concurrent.Channel)new LinkedQueue(), poolSize);
        this.pooledExecutor.setMinimumPoolSize(poolSize);
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            log.warn("Attempt to start() but " + this + " is already started");
        }
        if (this.trace) {
            log.trace(this + " starting");
        }
        this.syncChannel = this.jChannelFactory.createSyncChannel();
        this.asyncChannel = this.jChannelFactory.createASyncChannel();
        this.syncChannel.setOpt(3, (Object)Boolean.FALSE);
        this.asyncChannel.setOpt(3, (Object)Boolean.FALSE);
        ControlMessageListener cml = new ControlMessageListener();
        ControlMembershipListener ml = new ControlMembershipListener();
        PostOfficeRequestHandler rh = new PostOfficeRequestHandler();
        this.nodeAddressMapListener = new NodeAddressMapListener();
        this.registerListener(this.nodeAddressMapListener);
        this.controlMessageDispatcher = new MessageDispatcher(this.syncChannel, (MessageListener)cml, (MembershipListener)ml, (RequestHandler)rh, true);
        DataReceiver r = new DataReceiver();
        this.asyncChannel.setReceiver((Receiver)r);
        this.syncChannel.connect(this.groupName);
        this.asyncChannel.connect(this.groupName);
        super.start();
        Address syncAddress = this.syncChannel.getLocalAddress();
        Address asyncAddress = this.asyncChannel.getLocalAddress();
        PostOfficeAddressInfo info = new PostOfficeAddressInfo(syncAddress, asyncAddress);
        this.put((Serializable)((Object)ADDRESS_INFO_KEY), info);
        this.statsSender.start();
        this.started = true;
        log.debug(this + " started");
    }

    public synchronized void stop(boolean sendNotification) throws Exception {
        if (this.trace) {
            log.trace(this + " stopping");
        }
        if (!this.started) {
            log.warn("Attempt to stop() but " + this + " is not started");
            return;
        }
        this.syncSendRequest(new LeaveClusterRequest(this.getNodeId()));
        this.stopping = true;
        Thread.sleep(1000L);
        this.statsSender.stop();
        super.stop(sendNotification);
        this.pooledExecutor.shutdownAfterProcessingCurrentlyQueuedTasks();
        this.asyncChannel.setReceiver(null);
        this.unregisterListener(this.nodeAddressMapListener);
        this.syncChannel.close();
        this.asyncChannel.close();
        this.started = false;
        log.debug(this + " stopped");
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object object) throws IllegalArgumentException {
        this.nbSupport.addNotificationListener(listener, filter, object);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.nbSupport.removeNotificationListener(listener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getNodeIDView() {
        if (this.syncChannel == null) {
            return Collections.EMPTY_SET;
        }
        HashMap addressInfo = null;
        Map map = this.replicatedData;
        synchronized (map) {
            addressInfo = new HashMap((Map)this.replicatedData.get(ADDRESS_INFO_KEY));
        }
        HashSet nodeIDView = null;
        Iterator i = this.syncChannel.getView().getMembers().iterator();
        while (i.hasNext()) {
            if (nodeIDView == null) {
                nodeIDView = new HashSet();
            }
            Address addr = (Address)i.next();
            Iterator j = addressInfo.entrySet().iterator();
            while (j.hasNext()) {
                Map.Entry entry = j.next();
                if (!((PostOfficeAddressInfo)entry.getValue()).getSyncChannelAddress().equals(addr)) continue;
                nodeIDView.add(entry.getKey());
            }
        }
        return nodeIDView;
    }

    public Binding bindClusteredQueue(Condition condition, LocalClusteredQueue queue) throws Exception {
        if (this.trace) {
            log.trace(this.currentNodeId + " binding clustered queue " + queue + " with condition " + condition);
        }
        if (queue.getNodeId() != this.currentNodeId) {
            throw new IllegalArgumentException("Queue node id does not match office node id");
        }
        Binding binding = super.bindQueue(condition, queue);
        this.sendBindRequest(condition, queue, binding);
        return binding;
    }

    public Binding unbindClusteredQueue(String queueName) throws Throwable {
        if (this.trace) {
            log.trace(this.currentNodeId + " unbind clustered queue: " + queueName);
        }
        Binding binding = super.unbindQueue(queueName);
        UnbindRequest request = new UnbindRequest(this.currentNodeId, queueName);
        this.syncSendRequest(request);
        return binding;
    }

    public Collection listAllBindingsForCondition(Condition condition) throws Exception {
        return this.listBindingsForConditionInternal(condition, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBindingFromCluster(int nodeId, String queueName, String conditionText, String filterString, long channelID, boolean durable) throws Exception {
        this.lock.writeLock().acquire();
        log.debug(this + " adding binding from node " + nodeId + ", queue " + queueName + " with condition " + conditionText);
        Condition condition = this.conditionFactory.createCondition(conditionText);
        try {
            if (!this.knowAboutNodeId(nodeId)) {
                throw new IllegalStateException("Don't know about node id: " + nodeId);
            }
            Map nameMap = (Map)this.nameMaps.get(new Integer(nodeId));
            Binding binding = null;
            if (nameMap != null) {
                binding = (Binding)nameMap.get(queueName);
            }
            if (binding != null) {
                throw new IllegalArgumentException(this + " has already this binding for node " + nodeId + ", queue " + queueName);
            }
            binding = this.createBinding(nodeId, condition, queueName, channelID, filterString, durable, true);
            this.addBinding(binding);
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBindingFromCluster(int nodeId, String queueName) throws Exception {
        this.lock.writeLock().acquire();
        if (this.trace) {
            log.trace(this.currentNodeId + " removing binding from node: " + nodeId + " queue: " + queueName);
        }
        try {
            if (!this.knowAboutNodeId(nodeId)) {
                throw new IllegalStateException("Don't know about node id: " + nodeId);
            }
            this.removeBinding(nodeId, queueName);
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNodeLeft(int nodeId) throws Exception {
        Set set = this.leftSet;
        synchronized (set) {
            this.leftSet.add(new Integer(nodeId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putReplicantLocally(int originatorNodeID, Serializable key, Serializable replicant) throws Exception {
        LinkedHashMap<Integer, Serializable> m = null;
        Map map = this.replicatedData;
        synchronized (map) {
            log.debug(this + " puts replicant locally: " + key + "->" + replicant);
            m = (LinkedHashMap<Integer, Serializable>)this.replicatedData.get(key);
            if (m == null) {
                m = new LinkedHashMap<Integer, Serializable>();
                this.replicatedData.put(key, m);
            }
            m.put(new Integer(originatorNodeID), replicant);
            if (this.trace) {
                log.trace(this + " putReplicantLocally completed");
            }
        }
        this.notifyListeners(key, m, true, originatorNodeID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeReplicantLocally(int originatorNodeID, Serializable key) throws Exception {
        Map m = null;
        Map map = this.replicatedData;
        synchronized (map) {
            if (this.trace) {
                log.trace(this + " removes " + originatorNodeID + "'s replicant locally for key " + key);
            }
            if ((m = (Map)this.replicatedData.get(key)) == null) {
                return false;
            }
            Object obj = m.remove(new Integer(originatorNodeID));
            if (obj == null) {
                return false;
            }
            if (m.isEmpty()) {
                this.replicatedData.remove(key);
            }
        }
        this.notifyListeners(key, m, false, originatorNodeID);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void routeFromCluster(org.jboss.messaging.core.message.Message message, String routingKeyText, Map queueNameNodeIdMap) throws Exception {
        if (this.trace) {
            log.trace(this + " routing from cluster " + message + ", routing key " + routingKeyText + ", map " + queueNameNodeIdMap);
        }
        Condition routingKey = this.conditionFactory.createCondition(routingKeyText);
        this.lock.readLock().acquire();
        MessageReference ref = null;
        try {
            if (message.isReliable()) {
                message.setPersisted(true);
            }
            ref = this.ms.reference(message);
            DefaultClusteredBindings cb = (DefaultClusteredBindings)this.conditionMap.get(routingKey);
            if (cb != null) {
                Collection bindings = cb.getAllBindings();
                Iterator iter = bindings.iterator();
                while (iter.hasNext()) {
                    Integer in;
                    Binding binding = (Binding)iter.next();
                    if (binding.getNodeID() != this.currentNodeId) continue;
                    boolean handle = true;
                    if (queueNameNodeIdMap != null && (in = (Integer)queueNameNodeIdMap.get(binding.getQueue().getName())) != null) {
                        boolean bl = handle = in == this.currentNodeId;
                    }
                    if (!handle) continue;
                    LocalClusteredQueue queue = (LocalClusteredQueue)binding.getQueue();
                    Delivery del = queue.handleFromCluster(ref);
                    if (!this.trace) continue;
                    log.trace(this.currentNodeId + " queue " + queue.getName() + " handled reference from cluster " + del);
                }
            }
            Object var14_13 = null;
            if (ref != null) {
                ref.releaseMemoryReference();
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (ref != null) {
                ref.releaseMemoryReference();
            }
            this.lock.readLock().release();
            throw throwable;
        }
        this.lock.readLock().release();
    }

    public void asyncSendRequest(ClusterRequest request) throws Exception {
        if (this.stopping) {
            return;
        }
        if (this.trace) {
            log.trace(this + " sending asynchronously " + request + " to group");
        }
        byte[] bytes = this.writeRequest(request);
        this.asyncChannel.send(new Message(null, null, bytes));
    }

    public void asyncSendRequest(ClusterRequest request, int nodeId) throws Exception {
        if (this.stopping) {
            return;
        }
        Address address = this.getAddressForNodeId(nodeId, false);
        if (address == null) {
            throw new IllegalArgumentException("Cannot find address for node " + nodeId);
        }
        if (this.trace) {
            log.trace(this + " sending asynchronously " + request + " to node  " + nodeId + "/" + address);
        }
        byte[] bytes = this.writeRequest(request);
        this.asyncChannel.send(new Message(address, null, bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void holdTransaction(TransactionId id, ClusterTransaction tx) throws Exception {
        Map map = this.holdingArea;
        synchronized (map) {
            this.holdingArea.put(id, tx);
            if (this.trace) {
                log.trace(this + " added transaction " + tx + " to holding area as " + id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(TransactionId id) throws Throwable {
        if (this.trace) {
            log.trace(this.currentNodeId + " committing transaction " + id);
        }
        ClusterTransaction tx = null;
        Map map = this.holdingArea;
        synchronized (map) {
            tx = (ClusterTransaction)this.holdingArea.remove(id);
        }
        if (tx == null) {
            if (this.trace) {
                log.trace("Cannot find transaction in map, node may have already left");
            }
        } else {
            tx.commit(this);
            if (this.trace) {
                log.trace(this + " committed transaction " + id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction(TransactionId id) throws Throwable {
        if (this.trace) {
            log.trace(this + " rolling back transaction " + id);
        }
        ClusterTransaction tx = null;
        Map map = this.holdingArea;
        synchronized (map) {
            tx = (ClusterTransaction)this.holdingArea.remove(id);
        }
        if (tx == null) {
            if (this.trace) {
                log.trace("Cannot find transaction in map, node may have already left");
            }
        } else {
            tx.rollback(this);
            if (this.trace) {
                log.trace(this + " committed transaction " + id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateQueueStats(int nodeId, List statsList) throws Exception {
        this.lock.readLock().acquire();
        if (this.trace) {
            log.trace(this + " updating queue stats from node " + nodeId + " stats size: " + statsList.size());
        }
        try {
            if (nodeId == this.currentNodeId) {
                throw new IllegalStateException("Received stats from node with ID that matches this node's ID. You may have started two or more nodes with the same node ID!");
            }
            Map nameMap = (Map)this.nameMaps.get(new Integer(nodeId));
            if (nameMap == null) {
                if (this.trace) {
                    log.trace(this + " cannot find node in name map, the node might have left");
                }
            } else {
                Iterator i = statsList.iterator();
                while (i.hasNext()) {
                    ClusterRouter router;
                    LocalClusteredQueue localQueue;
                    QueueStats st = (QueueStats)i.next();
                    Binding bb = (Binding)nameMap.get(st.getQueueName());
                    if (bb == null) {
                        if (!this.trace) continue;
                        log.trace(this + " cannot find binding for queue " + st.getQueueName() + " it could have been unbound");
                        continue;
                    }
                    RemoteQueueStub stub = (RemoteQueueStub)bb.getQueue();
                    stub.setStats(st);
                    if (this.trace) {
                        log.trace(this.currentNodeId + " setting stats: " + st + " on remote stub " + stub.getName());
                    }
                    if ((localQueue = (LocalClusteredQueue)(router = (ClusterRouter)this.routerMap.get(st.getQueueName())).getLocalQueue()) == null) continue;
                    RemoteQueueStub toQueue = (RemoteQueueStub)this.messagePullPolicy.chooseQueue(router.getQueues());
                    if (this.trace) {
                        log.trace(this.currentNodeId + " recalculated pull queue for queue " + st.getQueueName() + " to be " + toQueue);
                    }
                    localQueue.setPullQueue(toQueue);
                    if (toQueue == null || localQueue.getRefCount() != 0) continue;
                    localQueue.deliver();
                    if (!this.trace) continue;
                    log.trace(this + " triggered delivery for " + localQueue.getName());
                }
            }
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueueStats() throws Exception {
        if (!this.started) {
            return;
        }
        this.lock.readLock().acquire();
        ArrayList<QueueStats> statsList = null;
        try {
            Map nameMap = (Map)this.nameMaps.get(new Integer(this.currentNodeId));
            if (nameMap != null) {
                Iterator iter = nameMap.values().iterator();
                while (iter.hasNext()) {
                    QueueStats stats;
                    Binding bb = (Binding)iter.next();
                    Queue q = bb.getQueue();
                    if (!(q instanceof ClusteredQueue) || !q.isActive() || (stats = ((ClusteredQueue)q).getStats()) == null) continue;
                    if (statsList == null) {
                        statsList = new ArrayList<QueueStats>();
                    }
                    statsList.add(stats);
                    if (!this.trace) continue;
                    log.trace(this.currentNodeId + " adding stat for send " + stats);
                }
            }
        }
        finally {
            this.lock.readLock().release();
        }
        if (statsList != null) {
            QueueStatsRequest req = new QueueStatsRequest(this.currentNodeId, statsList);
            this.asyncSendRequest(req);
            if (this.trace) {
                log.trace(this.currentNodeId + " Sent stats");
            }
        }
    }

    public boolean referenceExistsInStorage(long channelID, long messageID) throws Exception {
        return this.pm.referenceExists(channelID, messageID);
    }

    public void handleMessagePullResult(int remoteNodeId, long holdingTxId, String queueName, org.jboss.messaging.core.message.Message message) throws Throwable {
        if (this.trace) {
            log.trace(this.currentNodeId + " handling pull result " + message + " for " + queueName);
        }
        Binding binding = this.getBindingForQueueName(queueName);
        boolean handled = false;
        if (!this.failHandleResult && binding != null) {
            Map bindings;
            LocalClusteredQueue localQueue = (LocalClusteredQueue)binding.getQueue();
            RemoteQueueStub remoteQueue = localQueue.getPullQueue();
            if (remoteNodeId != remoteQueue.getNodeId() && (bindings = (Map)this.nameMaps.get(new Integer(remoteNodeId))) != null && (binding = (Binding)bindings.get(queueName)) != null) {
                remoteQueue = (RemoteQueueStub)binding.getQueue();
            }
            if (remoteQueue != null) {
                localQueue.handlePullMessagesResult(remoteQueue, message, holdingTxId, this.failBeforeCommit, this.failAfterCommit);
                handled = true;
            }
        }
        if (!handled && message.isReliable()) {
            this.asyncSendRequest(new RollbackPullRequest(this.currentNodeId, holdingTxId), remoteNodeId);
            if (this.trace) {
                log.trace(this.currentNodeId + " send rollback pull request");
            }
        }
    }

    public PooledExecutor getPooledExecutor() {
        return this.pooledExecutor;
    }

    public void put(Serializable key, Serializable replicant) throws Exception {
        this.putReplicantLocally(this.currentNodeId, key, replicant);
        PutReplicantRequest request = new PutReplicantRequest(this.currentNodeId, key, replicant);
        this.syncSendRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map get(Serializable key) throws Exception {
        Map map = this.replicatedData;
        synchronized (map) {
            Map m = (Map)this.replicatedData.get(key);
            return m == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(m);
        }
    }

    public boolean remove(Serializable key) throws Exception {
        if (this.removeReplicantLocally(this.currentNodeId, key)) {
            RemoveReplicantRequest request = new RemoveReplicantRequest(this.currentNodeId, key);
            this.syncSendRequest(request);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(ReplicationListener listener) {
        Set set = this.replicationListeners;
        synchronized (set) {
            if (this.replicationListeners.contains(listener)) {
                throw new IllegalArgumentException("Listener " + listener + " is already registered");
            }
            this.replicationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(ReplicationListener listener) {
        Set set = this.replicationListeners;
        synchronized (set) {
            boolean removed = this.replicationListeners.remove(listener);
            if (!removed) {
                throw new IllegalArgumentException("Cannot find listener " + listener + " to remove");
            }
        }
    }

    public FailoverMapper getFailoverMapper() {
        return this.failoverMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean route(MessageReference ref, Condition condition, Transaction tx) throws Exception {
        if (this.trace) {
            log.trace(this + " routing " + ref + " with condition '" + condition + "'" + (tx == null ? "" : " transactionally in " + tx));
        }
        if (ref == null) {
            throw new IllegalArgumentException("Message reference is null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Condition is null");
        }
        boolean routed = false;
        this.lock.readLock().acquire();
        try {
            ClusteredBindings cb = (ClusteredBindings)this.conditionMap.get(condition);
            int lastNodeId = -1;
            boolean startInternalTx = false;
            if (cb != null) {
                if (this.trace) {
                    log.trace(this + " found " + cb);
                }
                if (tx == null && ref.getMessage().isReliable() && cb.getDurableCount() != 0 && (cb.getDurableCount() != 1 || cb.getLocalDurableCount() != 1)) {
                    startInternalTx = true;
                    if (this.trace) {
                        log.trace(this + " starting internal transaction since it needs to deliver persistent message to more than one durable sub or remote durable subs");
                    }
                }
                if (startInternalTx) {
                    tx = this.tr.createTransaction();
                }
                int numberRemote = 0;
                long lastChannelId = -1L;
                HashMap<String, Integer> queueNameNodeIdMap = null;
                Iterator i = cb.getRouters().iterator();
                while (i.hasNext()) {
                    Delivery del;
                    ClusterRouter router = (ClusterRouter)i.next();
                    if (this.trace) {
                        log.trace(this + " sending " + ref + " to " + router);
                    }
                    if ((del = router.handle(null, ref, tx)) == null || !del.isSelectorAccepted()) continue;
                    routed = true;
                    Queue queue = (Queue)del.getObserver();
                    if (queue.isClustered()) {
                        ClusteredQueue cq = (ClusteredQueue)queue;
                        if (this.trace) {
                            log.trace(this + " successfully routed message to " + (cq.isLocal() ? "LOCAL" : "REMOTE") + " destination '" + cq.getName() + "' on node " + cq.getNodeId());
                        }
                        if (router.getNumberOfReceivers() > 1) {
                            if (queueNameNodeIdMap == null) {
                                queueNameNodeIdMap = new HashMap<String, Integer>();
                            }
                            queueNameNodeIdMap.put(queue.getName(), new Integer(cq.getNodeId()));
                        }
                        if (cq.isLocal()) continue;
                        ++numberRemote;
                        lastNodeId = cq.getNodeId();
                        lastChannelId = queue.getChannelID();
                        continue;
                    }
                    if (!this.trace) continue;
                    log.trace(this + " successfully routed message to non clustered destination '" + queue.getName());
                }
                if (numberRemote > 0) {
                    if (tx == null) {
                        if (this.trace) {
                            log.trace(this + " multicasting message to group");
                        }
                        this.asyncSendRequest(new MessageRequest(condition.toText(), ref.getMessage(), queueNameNodeIdMap));
                    } else {
                        CastMessagesCallback callback = (CastMessagesCallback)tx.getCallback(this);
                        if (callback == null) {
                            callback = new CastMessagesCallback(this.currentNodeId, tx.getId(), this, this.failBeforeCommit, this.failAfterCommit);
                            tx.addFirstCallback(callback, this);
                        }
                        callback.addMessage(condition, ref.getMessage(), queueNameNodeIdMap, numberRemote == 1 ? lastNodeId : -1, lastChannelId);
                    }
                }
                if (startInternalTx) {
                    if (this.trace) {
                        log.trace(this + " committing " + tx);
                    }
                    tx.commit();
                    if (this.trace) {
                        log.trace(this + " committed " + tx);
                    }
                }
            }
        }
        finally {
            this.lock.readLock().release();
        }
        return routed;
    }

    public boolean isLocal() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTransactions(Integer nodeId) throws Throwable {
        if (this.trace) {
            log.trace(this + " checking for any stranded transactions for node " + nodeId);
        }
        Map map = this.holdingArea;
        synchronized (map) {
            Iterator iter = this.holdingArea.entrySet().iterator();
            ArrayList<TransactionId> toRemove = new ArrayList<TransactionId>();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                TransactionId id = (TransactionId)entry.getKey();
                if (id.getNodeId() != nodeId.intValue()) continue;
                ClusterTransaction tx = (ClusterTransaction)entry.getValue();
                if (this.trace) {
                    log.trace("found transaction " + tx + " in holding area");
                }
                boolean commit = tx.check(this);
                if (this.trace) {
                    log.trace("transaction " + tx + " will be " + (commit ? "COMMITTED" : "ROLLED BACK"));
                }
                if (commit) {
                    tx.commit(this);
                } else {
                    tx.rollback(this);
                }
                toRemove.add(id);
                if (!this.trace) continue;
                log.trace("resolved " + tx);
            }
            iter = toRemove.iterator();
            while (iter.hasNext()) {
                TransactionId id = (TransactionId)((Object)iter.next());
                this.holdingArea.remove(id);
            }
        }
        if (this.trace) {
            log.trace(this + " transaction check complete");
        }
    }

    public int getNodeId() {
        return this.currentNodeId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ClusteredPostOffice[");
        sb.append(this.currentNodeId).append(":").append(this.getOfficeName()).append(":");
        if (this.syncChannel == null) {
            sb.append("UNINITIALIZED");
        } else {
            Address addr = this.syncChannel.getLocalAddress();
            if (addr == null) {
                sb.append("UNCONNECTED");
            } else {
                sb.append(addr);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public String printBindingInformation() {
        Map.Entry entry;
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        out.print(super.printBindingInformation());
        out.println("<br>Router Information");
        out.println("<table border=1><tr><td>Queue Route</td><td>Local Queue</td><td>Elements</td></tr>");
        Iterator iterRouter = this.routerMap.entrySet().iterator();
        while (iterRouter.hasNext()) {
            entry = iterRouter.next();
            ClusterRouter router = (ClusterRouter)entry.getValue();
            out.println("<tr><td>" + entry.getKey() + "</td><td>" + router.getLocalQueue() + "</td>");
            out.println("<td>");
            out.println("<table border=1>");
            out.println("<tr><td><b>Queues</b></td><</tr>");
            Iterator queuesIterator = router.getQueues().iterator();
            while (queuesIterator.hasNext()) {
                Object queueRouted = queuesIterator.next();
                out.println("<tr><td>" + queueRouted + "</td></tr>");
            }
            out.println("</table>");
            out.println("</td></tr>");
        }
        out.println("</table>");
        out.println("Replicator's Information");
        out.println("<table border=1><tr><td>Node</td><td>Key</td><td>Value</td></tr>");
        Iterator iter = this.replicatedData.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            Map subMap = (Map)entry.getValue();
            Iterator subIterator = subMap.entrySet().iterator();
            while (subIterator.hasNext()) {
                Map.Entry subValue = subIterator.next();
                out.println("<tr><td>" + entry.getKey() + "</td>");
                out.println("<td>" + subValue.getKey() + "</td><td>" + subValue.getValue() + "</td></tr>");
            }
        }
        out.println("</table>");
        out.println("View Information");
        out.println("<table border=1><tr><td>Members</td></tr>");
        Iterator iterMembers = this.currentView.getMembers().iterator();
        while (iterMembers.hasNext()) {
            Address address = (Address)iterMembers.next();
            out.println("<tr><td>" + address + "</td></tr>");
        }
        out.println("</table>");
        return buffer.toString();
    }

    public void setFail(boolean beforeCommit, boolean afterCommit, boolean handleResult) {
        this.failBeforeCommit = beforeCommit;
        this.failAfterCommit = afterCommit;
        this.failHandleResult = handleResult;
    }

    public Collection getHoldingTransactions() {
        return this.holdingArea.values();
    }

    protected void addToConditionMap(Binding binding) {
        Condition condition = binding.getCondition();
        ClusteredBindings bindings = (ClusteredBindings)this.conditionMap.get(condition);
        if (bindings == null) {
            bindings = new DefaultClusteredBindings(this.currentNodeId);
            this.conditionMap.put(condition, bindings);
        }
        bindings.addBinding(binding);
        String queueName = binding.getQueue().getName();
        ClusterRouter router = (ClusterRouter)this.routerMap.get(queueName);
        if (router == null) {
            router = this.routerFactory.createRouter();
            this.routerMap.put(queueName, router);
            bindings.addRouter(queueName, router);
        }
        router.add(binding.getQueue());
    }

    protected void removeFromConditionMap(Binding binding) {
        String queueName;
        ClusterRouter router;
        ClusteredBindings bindings = (ClusteredBindings)this.conditionMap.get(binding.getCondition());
        if (bindings == null) {
            throw new IllegalStateException("Cannot find condition bindings for " + binding.getCondition());
        }
        boolean removed = bindings.removeBinding(binding);
        if (!removed) {
            throw new IllegalStateException("Cannot find binding in condition binding list");
        }
        if (bindings.isEmpty()) {
            this.conditionMap.remove(binding.getCondition());
        }
        if ((router = (ClusterRouter)this.routerMap.get(queueName = binding.getQueue().getName())) == null) {
            throw new IllegalStateException("Cannot find router with name " + queueName);
        }
        removed = router.remove(binding.getQueue());
        if (!removed) {
            throw new IllegalStateException("Cannot find router in map");
        }
        if (router.getQueues().isEmpty()) {
            this.routerMap.remove(queueName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBindings(boolean nonClusteredOnly) throws Exception {
        boolean isState;
        if (this.trace) {
            log.trace(this + " loading bindings");
        }
        if (!(isState = this.syncChannel.getState(null, this.stateTimeout))) {
            if (this.trace) {
                log.trace(this + " is the first member of group, so will load bindings from database");
            }
            super.loadBindings(false);
        } else {
            if (this.trace) {
                log.trace(this + " not first member of group, so waiting for state to arrive....");
            }
            Object object = this.setStateLock;
            synchronized (object) {
                while (!this.stateSet) {
                    this.setStateLock.wait();
                }
            }
            super.loadBindings(true);
            if (this.trace) {
                log.trace(this + " received state");
            }
        }
    }

    protected Binding createBinding(int nodeId, Condition condition, String queueName, long channelId, String filterString, boolean durable, boolean isClustered) throws Exception {
        Filter filter = this.filterFactory.createFilter(filterString);
        return this.createBinding(nodeId, condition, queueName, channelId, filter, durable, isClustered);
    }

    /*
     * WARNING - void declaration
     */
    protected Binding createBinding(int nodeID, Condition condition, String queueName, long channelId, Filter filter, boolean durable, boolean isClustered) {
        void var9_8;
        if (isClustered) {
            ClusteredQueue queue = nodeID == this.currentNodeId ? new LocalClusteredQueue(this, nodeID, queueName, channelId, this.ms, this.pm, true, durable, -1, filter, this.tr) : new RemoteQueueStub(nodeID, queueName, channelId, durable, this.pm, filter);
        } else {
            return super.createBinding(nodeID, condition, queueName, channelId, filter, durable, isClustered);
        }
        return new DefaultBinding(nodeID, condition, (Queue)var9_8);
    }

    private void sendBindRequest(Condition condition, LocalClusteredQueue queue, Binding binding) throws Exception {
        BindRequest request = new BindRequest(this.currentNodeId, queue.getName(), condition.toText(), queue.getFilter() == null ? null : queue.getFilter().getFilterString(), binding.getQueue().getChannelID(), queue.isRecoverable());
        this.syncSendRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean leaveMessageReceived(Integer nodeId) throws Exception {
        Set set = this.leftSet;
        synchronized (set) {
            return this.leftSet.remove(nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanLocalDataForNode(Integer nodeToRemove) throws Exception {
        Iterator<Object> i;
        Object toRemove;
        log.debug(this + " cleaning local data for node " + nodeToRemove);
        this.lock.writeLock().acquire();
        try {
            Map nameMap = (Map)this.nameMaps.get(nodeToRemove);
            if (nameMap != null) {
                Binding binding;
                toRemove = new ArrayList();
                i = nameMap.values().iterator();
                while (i.hasNext()) {
                    binding = (Binding)i.next();
                    if (binding.getQueue().isRecoverable()) continue;
                    toRemove.add(binding);
                }
                i = toRemove.iterator();
                while (i.hasNext()) {
                    binding = (Binding)i.next();
                    this.removeBinding(nodeToRemove, binding.getQueue().getName());
                }
            }
        }
        finally {
            this.lock.writeLock().release();
        }
        HashMap<String, Map> toNotify = new HashMap<String, Map>();
        toRemove = this.replicatedData;
        synchronized (toRemove) {
            i = this.replicatedData.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                String key = (String)entry.getKey();
                Map replicants = (Map)entry.getValue();
                replicants.remove(nodeToRemove);
                if (replicants.isEmpty()) {
                    i.remove();
                }
                toNotify.put(key, replicants);
            }
        }
        Iterator i2 = toNotify.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry entry = i2.next();
            String key = (String)entry.getKey();
            Map replicants = (Map)entry.getValue();
            this.notifyListeners((Serializable)((Object)key), replicants, false, nodeToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(Serializable key, Map updatedReplicantMap, boolean added, int originatorNodeId) {
        HashSet clone;
        Set set = this.replicationListeners;
        synchronized (set) {
            clone = new HashSet(this.replicationListeners);
        }
        Iterator i = clone.iterator();
        while (i.hasNext()) {
            ReplicationListener listener = (ReplicationListener)i.next();
            listener.onReplicationChange(key, updatedReplicantMap, added, originatorNodeId);
        }
    }

    private void syncSendRequest(ClusterRequest request) throws Exception {
        if (this.stopping) {
            return;
        }
        if (this.trace) {
            log.trace(this + " sending synch request " + request);
        }
        Message message = new Message(null, null, this.writeRequest(request));
        this.controlMessageDispatcher.castMessage(null, message, 2, this.castTimeout);
        if (this.trace) {
            log.trace(this + " request sent OK");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getNodeIDForSyncAddress(Address address) throws Exception {
        Map map = this.replicatedData;
        synchronized (map) {
            Map map2 = this.get((Serializable)((Object)ADDRESS_INFO_KEY));
            if (map2 == null) {
                throw new IllegalStateException("Cannot find node id -> address mapping");
            }
            Integer nid = null;
            Iterator i = map2.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                PostOfficeAddressInfo info = (PostOfficeAddressInfo)entry.getValue();
                if (!info.getSyncChannelAddress().equals(address)) continue;
                nid = (Integer)entry.getKey();
                break;
            }
            return nid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean knowAboutNodeId(int nodeId) {
        Map map = this.replicatedData;
        synchronized (map) {
            Map nodeIdAddressMapping = (Map)this.replicatedData.get(ADDRESS_INFO_KEY);
            if (nodeIdAddressMapping == null) {
                return false;
            }
            Object obj = nodeIdAddressMapping.get(new Integer(nodeId));
            boolean bl = obj != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getStateAsBytes() throws Exception {
        Map copy;
        Object iter2;
        ArrayList<BindingInfo> bindings = new ArrayList<BindingInfo>();
        Iterator iter = this.nameMaps.values().iterator();
        while (iter.hasNext()) {
            Map map = (Map)iter.next();
            iter2 = map.values().iterator();
            while (iter2.hasNext()) {
                Binding binding = (Binding)iter2.next();
                Queue queue = binding.getQueue();
                if (!queue.isClustered()) continue;
                BindingInfo info = new BindingInfo(binding.getNodeID(), queue.getName(), binding.getCondition().toText(), queue.getFilter() == null ? null : queue.getFilter().getFilterString(), queue.getChannelID(), queue.isRecoverable());
                bindings.add(info);
            }
        }
        iter2 = this.replicatedData;
        synchronized (iter2) {
            copy = this.copyReplicatedData(this.replicatedData);
        }
        SharedState state = new SharedState(bindings, copy);
        return StreamUtils.toBytes(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStateBytes(byte[] bytes) throws Exception {
        if (this.trace) {
            log.trace(this + " received state from group");
        }
        SharedState state = new SharedState();
        StreamUtils.fromBytes(state, bytes);
        if (this.trace) {
            log.trace(this + " received " + state.getBindings().size() + " bindings and map " + state.getReplicatedData());
        }
        this.nameMaps.clear();
        this.conditionMap.clear();
        List bindings = state.getBindings();
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            BindingInfo info = (BindingInfo)iter.next();
            Condition condition = this.conditionFactory.createCondition(info.getConditionText());
            Binding binding = this.createBinding(info.getNodeId(), condition, info.getQueueName(), info.getChannelId(), info.getFilterString(), info.isDurable(), true);
            if (binding.getNodeID() == this.currentNodeId) {
                binding.getQueue().deactivate();
            }
            this.addBinding(binding);
        }
        Map map = this.replicatedData;
        synchronized (map) {
            this.replicatedData = this.copyReplicatedData(state.getReplicatedData());
        }
    }

    private Map copyReplicatedData(Map toCopy) {
        HashMap copy = new HashMap();
        Iterator iter = toCopy.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Serializable key = (Serializable)entry.getKey();
            Map replicants = (Map)entry.getValue();
            LinkedHashMap m = new LinkedHashMap();
            m.putAll(replicants);
            copy.put(key, m);
        }
        return copy;
    }

    private byte[] writeRequest(ClusterRequest request) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        DataOutputStream daos = new DataOutputStream(baos);
        ClusterRequest.writeToStream(daos, request);
        daos.flush();
        return baos.toByteArray();
    }

    private ClusterRequest readRequest(byte[] bytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream dais = new DataInputStream(bais);
        ClusterRequest request = ClusterRequest.createFromStream(dais);
        dais.close();
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address getAddressForNodeId(int nodeId, boolean sync) throws Exception {
        Map map = this.replicatedData;
        synchronized (map) {
            Map map2 = this.get((Serializable)((Object)ADDRESS_INFO_KEY));
            if (map2 == null) {
                throw new IllegalStateException("Cannot find address mapping");
            }
            PostOfficeAddressInfo info = (PostOfficeAddressInfo)map2.get(new Integer(nodeId));
            if (info != null) {
                if (sync) {
                    return info.getSyncChannelAddress();
                }
                return info.getAsyncChannelAddress();
            }
            return null;
        }
    }

    private void nodeJoined(Address address) throws Exception {
        log.debug(this + ": " + address + " joined");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nodeLeft(Address address) throws Throwable {
        log.debug(this + ": " + address + " left");
        Integer leftNodeID = this.getNodeIDForSyncAddress(address);
        if (leftNodeID == null) {
            throw new IllegalStateException(this + " cannot find node ID for address " + address);
        }
        boolean crashed = !this.leaveMessageReceived(leftNodeID);
        log.debug(this + ": node " + leftNodeID + " has " + (crashed ? "crashed" : "cleanly left the group"));
        this.checkTransactions(leftNodeID);
        Map map = this.failoverMap;
        synchronized (map) {
            Integer failoverNode = (Integer)this.failoverMap.get(leftNodeID);
            if (failoverNode == null) {
                throw new IllegalStateException(this + " cannot find failover node for node " + leftNodeID);
            }
            this.cleanLocalDataForNode(leftNodeID);
            if (this.currentNodeId == failoverNode && crashed) {
                log.info(this + ": I am the failover node for node " + leftNodeID + " that crashed");
                this.performFailover(leftNodeID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performFailover(Integer failedNodeID) throws Exception {
        this.lock.writeLock().acquire();
        try {
            log.debug(this + " performing failover for failed node " + failedNodeID);
            Map failoverData = this.get((Serializable)((Object)FAILED_OVER_FOR_KEY));
            FailoverStatus status = (FailoverStatus)failoverData.get(new Integer(this.currentNodeId));
            if (status == null) {
                status = new FailoverStatus();
            }
            status.startFailingOverForNode(failedNodeID);
            log.debug(this + " announcing the cluster it is starting failover procedure");
            this.put((Serializable)((Object)FAILED_OVER_FOR_KEY), status);
            log.debug(this + " announced the cluster it is starting failover procedure");
            Map subMaps = (Map)this.nameMaps.get(failedNodeID);
            if (subMaps == null || subMaps.size() == 0) {
                log.warn(this + " couldn't find any binding to fail over from server " + failedNodeID);
            } else {
                Binding binding;
                Map.Entry entry;
                ArrayList namesToRemove = new ArrayList();
                Iterator i = subMaps.entrySet().iterator();
                while (i.hasNext()) {
                    entry = i.next();
                    binding = (Binding)entry.getValue();
                    if (!binding.getQueue().isRecoverable()) {
                        throw new IllegalStateException("Found non recoverable queue " + binding.getQueue().getName() + "in map, these should have been removed!");
                    }
                    if (!binding.getQueue().isClustered()) {
                        throw new IllegalStateException("Queue " + binding.getQueue().getName() + " is not clustered!");
                    }
                    ClusteredQueue queue = (ClusteredQueue)binding.getQueue();
                    if (!queue.isClustered()) {
                        log.debug("Not failing over non clustered queue " + queue.getName());
                        continue;
                    }
                    namesToRemove.add(entry);
                }
                if (this.trace) {
                    log.trace("deleting " + namesToRemove.size() + " bindings from old node");
                }
                i = namesToRemove.iterator();
                while (i.hasNext()) {
                    entry = i.next();
                    binding = (Binding)entry.getValue();
                    RemoteQueueStub stub = (RemoteQueueStub)binding.getQueue();
                    String queueName = (String)entry.getKey();
                    this.removeBinding(failedNodeID, queueName);
                    this.deleteBinding(failedNodeID, queueName);
                    log.debug(this + " deleted binding for " + queueName);
                    Binding current = this.internalGetBindingForQueueName(queueName);
                    if (current == null) {
                        log.debug(this + " did not have a " + queueName + " queue so no need to merge");
                    } else {
                        log.debug(this + " has already a " + queueName + " queue so merging queues");
                    }
                    if (current != null) {
                        log.debug("Merging queue " + queueName);
                        LocalClusteredQueue currentQueue = (LocalClusteredQueue)current.getQueue();
                        currentQueue.mergeIn(stub);
                        log.debug("Merged queue");
                        continue;
                    }
                    Binding newBinding = this.createBinding(this.currentNodeId, binding.getCondition(), stub.getName(), stub.getChannelID(), stub.getFilter(), stub.isRecoverable(), true);
                    this.insertBinding(newBinding);
                    LocalClusteredQueue clusteredQueue = (LocalClusteredQueue)newBinding.getQueue();
                    clusteredQueue.deactivate();
                    clusteredQueue.load();
                    clusteredQueue.activate();
                    log.debug(this + " loaded " + clusteredQueue);
                    this.addBinding(newBinding);
                    this.sendBindRequest(binding.getCondition(), clusteredQueue, newBinding);
                }
            }
            log.debug(this + " finished to fail over destinations");
            status.finishFailingOver();
            log.debug(this + " announcing the cluster that failover procedure is complete");
            this.put((Serializable)((Object)FAILED_OVER_FOR_KEY), status);
            log.debug(this + " announced the cluster that failover procedure is complete");
            this.sendJMXNotification("FAILOVER_COMPLETED");
            log.info(this + ": server side fail over is now complete");
        }
        finally {
            this.lock.writeLock().release();
        }
    }

    private void sendJMXNotification(String notificationType) {
        Notification n = new Notification(notificationType, "", 0L);
        this.nbSupport.sendNotification(n);
        log.debug(this + " sent " + notificationType + " JMX notification");
    }

    private class NodeAddressMapListener
    implements ReplicationListener {
        private NodeAddressMapListener() {
        }

        public void onReplicationChange(Serializable key, Map updatedReplicantMap, boolean added, int originatorNodeID) {
            log.debug(DefaultClusteredPostOffice.this + " received " + key + " replication change from node " + originatorNodeID + ", new map " + updatedReplicantMap);
            if (key instanceof String && ((String)((Object)key)).equals(DefaultClusteredPostOffice.ADDRESS_INFO_KEY)) {
                log.debug("Updated cluster map:\n" + DefaultClusteredPostOffice.dumpClusterMap(updatedReplicantMap));
                DefaultClusteredPostOffice.this.failoverMap = DefaultClusteredPostOffice.this.failoverMapper.generateMapping(updatedReplicantMap.keySet());
                log.debug("Updated failover map:\n" + DefaultClusteredPostOffice.dumpFailoverMap(DefaultClusteredPostOffice.this.failoverMap));
            }
        }
    }

    private class PostOfficeRequestHandler
    implements RequestHandler {
        private PostOfficeRequestHandler() {
        }

        public Object handle(Message message) {
            if (DefaultClusteredPostOffice.this.stopping) {
                return null;
            }
            if (DefaultClusteredPostOffice.this.trace) {
                log.trace(DefaultClusteredPostOffice.this + ".RequestHandler received " + message + " on the SYNC channel");
            }
            try {
                byte[] bytes = message.getBuffer();
                ClusterRequest request = DefaultClusteredPostOffice.this.readRequest(bytes);
                return request.execute(DefaultClusteredPostOffice.this);
            }
            catch (Throwable e) {
                log.error("Caught Exception in RequestHandler", e);
                IllegalStateException e2 = new IllegalStateException(e.getMessage());
                e2.setStackTrace(e.getStackTrace());
                throw e2;
            }
        }
    }

    private class DataReceiver
    implements Receiver {
        private DataReceiver() {
        }

        public void block() {
        }

        public void suspect(Address address) {
        }

        public void viewAccepted(View view) {
        }

        public byte[] getState() {
            return null;
        }

        public void receive(Message message) {
            if (DefaultClusteredPostOffice.this.trace) {
                log.trace(this + " received " + message + " on the ASYNC channel");
            }
            try {
                byte[] bytes = message.getBuffer();
                ClusterRequest request = DefaultClusteredPostOffice.this.readRequest(bytes);
                request.execute(DefaultClusteredPostOffice.this);
            }
            catch (Throwable e) {
                log.error("Caught Exception in Receiver", e);
                IllegalStateException e2 = new IllegalStateException(e.getMessage());
                e2.setStackTrace(e.getStackTrace());
                throw e2;
            }
        }

        public void setState(byte[] bytes) {
        }
    }

    private class HandleViewAcceptedRunnable
    implements Runnable {
        private View newView;

        HandleViewAcceptedRunnable(View newView) {
            this.newView = newView;
        }

        public void run() {
            log.info(DefaultClusteredPostOffice.this + " got new view " + this.newView);
            View oldView = DefaultClusteredPostOffice.this.currentView;
            DefaultClusteredPostOffice.this.currentView = this.newView;
            try {
                Address address;
                Iterator i;
                if (oldView != null) {
                    i = oldView.getMembers().iterator();
                    while (i.hasNext()) {
                        address = (Address)i.next();
                        if (this.newView.containsMember(address)) continue;
                        DefaultClusteredPostOffice.this.nodeLeft(address);
                    }
                }
                i = this.newView.getMembers().iterator();
                while (i.hasNext()) {
                    address = (Address)i.next();
                    if (oldView != null && oldView.containsMember(address)) continue;
                    DefaultClusteredPostOffice.this.nodeJoined(address);
                }
                DefaultClusteredPostOffice.this.sendJMXNotification("VIEW_CHANGED");
            }
            catch (Throwable e) {
                log.error("Caught Exception in MembershipListener", e);
                IllegalStateException e2 = new IllegalStateException(e.getMessage());
                e2.setStackTrace(e.getStackTrace());
                throw e2;
            }
        }
    }

    private class ControlMembershipListener
    implements MembershipListener {
        private ControlMembershipListener() {
        }

        public void block() {
        }

        public void suspect(Address address) {
        }

        public void viewAccepted(View newView) {
            if (DefaultClusteredPostOffice.this.stopping) {
                return;
            }
            try {
                DefaultClusteredPostOffice.this.viewExecutor.execute((Runnable)new HandleViewAcceptedRunnable(newView));
            }
            catch (InterruptedException e) {
                log.warn("Caught InterruptedException", e);
            }
        }

        public byte[] getState() {
            return null;
        }
    }

    private class ControlMessageListener
    implements MessageListener {
        private ControlMessageListener() {
        }

        public byte[] getState() {
            if (DefaultClusteredPostOffice.this.stopping) {
                return null;
            }
            try {
                DefaultClusteredPostOffice.this.lock.writeLock().acquire();
            }
            catch (InterruptedException e) {
                log.error("Thread Interrupted", e);
            }
            try {
                if (DefaultClusteredPostOffice.this.trace) {
                    log.trace(DefaultClusteredPostOffice.this + ".ControlMessageListener got state");
                }
                byte[] e = DefaultClusteredPostOffice.this.getStateAsBytes();
                return e;
            }
            catch (Exception e) {
                log.error("Caught Exception in MessageListener", e);
                IllegalStateException e2 = new IllegalStateException(e.getMessage());
                e2.setStackTrace(e.getStackTrace());
                throw e2;
            }
            finally {
                DefaultClusteredPostOffice.this.lock.writeLock().release();
            }
        }

        public void receive(Message message) {
            if (DefaultClusteredPostOffice.this.stopping) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(byte[] bytes) {
            if (DefaultClusteredPostOffice.this.stopping) {
                return;
            }
            if (bytes != null) {
                try {
                    DefaultClusteredPostOffice.this.lock.writeLock().acquire();
                }
                catch (InterruptedException e) {
                    log.error("Thread interrupted", e);
                }
                try {
                    DefaultClusteredPostOffice.this.processStateBytes(bytes);
                    if (DefaultClusteredPostOffice.this.trace) {
                        log.trace(DefaultClusteredPostOffice.this + ".ControlMessageListener has set state");
                    }
                }
                catch (Exception e) {
                    log.error("Caught Exception in MessageListener", e);
                    IllegalStateException e2 = new IllegalStateException(e.getMessage());
                    e2.setStackTrace(e.getStackTrace());
                    throw e2;
                }
                finally {
                    DefaultClusteredPostOffice.this.lock.writeLock().release();
                }
            }
            Object object = DefaultClusteredPostOffice.this.setStateLock;
            synchronized (object) {
                DefaultClusteredPostOffice.this.stateSet = true;
                DefaultClusteredPostOffice.this.setStateLock.notify();
            }
        }
    }
}

