/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.Delivery;
import org.jboss.messaging.core.DeliveryObserver;
import org.jboss.messaging.core.Queue;
import org.jboss.messaging.core.Receiver;
import org.jboss.messaging.core.message.MessageReference;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterRouter;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusteredQueue;
import org.jboss.messaging.core.plugin.postoffice.cluster.DefaultRouter;
import org.jboss.messaging.core.tx.Transaction;

public class RoundRobinRouter
implements ClusterRouter {
    private static final Logger log = Logger.getLogger(DefaultRouter.class);
    private boolean trace = log.isTraceEnabled();
    private ArrayList queues = new ArrayList();
    private ClusteredQueue localQueue;
    private int target;

    public Delivery handle(DeliveryObserver observer, MessageReference ref, Transaction tx) {
        if (this.trace) {
            log.trace(this + " routing " + ref);
        }
        if (!this.queues.isEmpty()) {
            ClusteredQueue queue = (ClusteredQueue)this.queues.get(this.target);
            Delivery del = queue.handle(observer, ref, tx);
            if (this.trace) {
                log.trace(this + " routed to remote queue, it returned " + del);
            }
            this.incTarget();
            return del;
        }
        if (this.trace) {
            log.trace(this + " no queues to route to so return null");
        }
        return null;
    }

    public boolean contains(Receiver queue) {
        return this.queues.contains(queue);
    }

    public Iterator iterator() {
        return this.queues.iterator();
    }

    public boolean add(Receiver receiver) {
        return this.add(receiver, false);
    }

    public boolean remove(Receiver queue) {
        if (queue == this.localQueue) {
            this.localQueue = null;
        }
        if (this.queues.remove(queue)) {
            if (this.target >= this.queues.size() - 1) {
                this.target = this.queues.size() - 1;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this.queues.clear();
        this.localQueue = null;
        this.target = 0;
    }

    public int getNumberOfReceivers() {
        return this.queues.size();
    }

    public List getQueues() {
        return this.queues;
    }

    public boolean add(Receiver receiver, boolean failedOver) {
        ClusteredQueue queue = (ClusteredQueue)receiver;
        if (queue.isLocal()) {
            if (this.localQueue == null) {
                this.localQueue = queue;
            } else {
                throw new IllegalStateException("Local queue already exists");
            }
        }
        this.queues.add(receiver);
        return true;
    }

    public Queue getLocalQueue() {
        return this.localQueue;
    }

    public int size() {
        return this.queues.size();
    }

    public String toString() {
        return "Router[" + Integer.toHexString(this.hashCode()) + "]";
    }

    private void incTarget() {
        ++this.target;
        if (this.target == this.queues.size()) {
            this.target = 0;
        }
    }
}

