/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.messaging.core.plugin.postoffice.cluster.MessageHolder;
import org.jboss.messaging.core.plugin.postoffice.cluster.PostOfficeInternal;
import org.jboss.messaging.core.plugin.postoffice.cluster.TransactionRequest;

class SendTransactionRequest
extends TransactionRequest {
    static final int TYPE = 8;
    private List messageHolders;

    SendTransactionRequest() {
    }

    SendTransactionRequest(int nodeId, long txId, List messageHolders, long channelID) {
        super(nodeId, txId, true, channelID);
        this.messageHolders = messageHolders;
    }

    SendTransactionRequest(int nodeId, long txId) {
        super(nodeId, txId, false);
    }

    public void read(DataInputStream in) throws Exception {
        super.read(in);
        byte b = in.readByte();
        if (b == 0) {
            this.messageHolders = null;
        } else {
            int size = in.readInt();
            this.messageHolders = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                MessageHolder holder = new MessageHolder();
                holder.read(in);
                this.messageHolders.add(holder);
            }
        }
    }

    public void write(DataOutputStream out) throws Exception {
        super.write(out);
        if (this.messageHolders != null) {
            out.writeByte(11);
            out.writeInt(this.messageHolders.size());
            Iterator iter = this.messageHolders.iterator();
            while (iter.hasNext()) {
                MessageHolder holder = (MessageHolder)iter.next();
                holder.write(out);
            }
        } else {
            out.writeByte(0);
        }
    }

    public void commit(PostOfficeInternal office) throws Exception {
        Iterator iter = this.messageHolders.iterator();
        while (iter.hasNext()) {
            MessageHolder holder = (MessageHolder)iter.next();
            office.routeFromCluster(holder.getMessage(), holder.getRoutingKey(), holder.getQueueNameToNodeIdMap());
        }
    }

    public void rollback(PostOfficeInternal office) throws Exception {
    }

    public boolean check(PostOfficeInternal office) throws Exception {
        Iterator iter = this.messageHolders.iterator();
        MessageHolder holder = (MessageHolder)iter.next();
        return office.referenceExistsInStorage(this.checkChannelID, holder.getMessage().getMessageID());
    }

    public byte getType() {
        return 8;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SendTransactionRequest[");
        if (this.messageHolders == null) {
            sb.append("EMPTY");
        } else {
            Iterator i = this.messageHolders.iterator();
            while (i.hasNext()) {
                sb.append(((MessageHolder)i.next()).getMessage());
                if (!i.hasNext()) continue;
                sb.append(',');
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

