/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.serviceref;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.soap.FactoryLoader;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.logging.Logger;
import org.jboss.ws.integration.KernelLocator;
import org.jboss.ws.integration.ServiceRefElement;
import org.jboss.ws.integration.ServiceRefHandler;
import org.jboss.ws.integration.ServiceRefMetaData;
import org.jboss.ws.integration.UnifiedVirtualFile;
import org.jboss.xb.binding.UnmarshallingContext;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class ServiceRefDelegate
implements ServiceRefHandler {
    private static final Logger log = Logger.getLogger(ServiceRefDelegate.class);
    private static ServiceRefHandler delegate;

    public ServiceRefDelegate() {
        if (delegate == null) {
            Kernel kernel = KernelLocator.getKernel();
            if (kernel != null) {
                KernelRegistry registry = kernel.getRegistry();
                KernelRegistryEntry entry = registry.getEntry("ServiceRefHandler");
                delegate = (ServiceRefHandler)entry.getTarget();
            } else {
                String propName = ServiceRefHandler.class.getName();
                String defaultImpl = "org.jboss.ws.core.client.ServiceRefHandlerImpl";
                delegate = (ServiceRefHandler)FactoryLoader.loadFactory((String)propName, (String)defaultImpl);
            }
        }
        if (delegate == null) {
            log.warn("Not registered: ServiceRefHandler");
        }
    }

    public ServiceRefMetaData newServiceRefMetaData() {
        ServiceRefMetaData sref = delegate != null ? delegate.newServiceRefMetaData() : new DummyServiceRef();
        return sref;
    }

    public Object newChild(ServiceRefElement ref, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Object child = null;
        if (delegate != null) {
            child = delegate.newChild(ref, navigator, namespaceURI, localName, attrs);
        }
        return child;
    }

    public void setValue(ServiceRefElement ref, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (delegate != null) {
            delegate.setValue(ref, navigator, namespaceURI, localName, value);
        }
    }

    public void bindServiceRef(Context encCtx, String encName, UnifiedVirtualFile vfsRoot, ClassLoader loader, ServiceRefMetaData sref) throws NamingException {
        if (delegate != null) {
            delegate.bindServiceRef(encCtx, encName, vfsRoot, loader, sref);
        }
    }

    public static class DummyServiceRef
    extends ServiceRefMetaData {
        private String refName;

        public void setServiceRefName(String name) {
            this.refName = name;
        }

        public String getServiceRefName() {
            return this.refName;
        }

        public Object getAnnotatedElement() {
            return null;
        }

        public void setAnnotatedElement(Object anElement) {
        }

        public void importJBossXml(Element element) {
        }

        public void importStandardXml(Element element) {
        }

        public boolean isProcessed() {
            return false;
        }

        public void setProcessed(boolean flag) {
        }

        public void merge(ServiceRefMetaData serviceRef) {
        }
    }
}

