/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metamodel.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.metamodel.descriptor.EjbLocalRef;
import org.jboss.metamodel.descriptor.EjbRef;
import org.jboss.metamodel.descriptor.EnvEntry;
import org.jboss.metamodel.descriptor.JndiRef;
import org.jboss.metamodel.descriptor.MessageDestinationRef;
import org.jboss.metamodel.descriptor.PersistenceContextRef;
import org.jboss.metamodel.descriptor.PersistenceUnitRef;
import org.jboss.metamodel.descriptor.ResourceEnvRef;
import org.jboss.metamodel.descriptor.ResourceRef;
import org.jboss.ws.integration.ServiceRefMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnvironmentRefGroup {
    private static final Logger log = Logger.getLogger(EnvironmentRefGroup.class);
    protected HashMap<String, EjbLocalRef> ejbLocalRefs = new HashMap();
    protected HashMap<String, EjbRef> ejbRefs = new HashMap();
    protected HashMap<String, EnvEntry> envEntries = new HashMap();
    protected HashMap<String, ResourceEnvRef> resourceEnvRefs = new HashMap();
    protected HashMap<String, ResourceRef> resourceRefs = new HashMap();
    protected HashMap<String, MessageDestinationRef> messageDestinationRefs = new HashMap();
    protected HashMap<String, MessageDestinationRef> messageDestinationRefsByLink = new HashMap();
    protected HashMap<String, ServiceRefMetaData> serviceRefs = new LinkedHashMap<String, ServiceRefMetaData>();
    protected HashMap<String, JndiRef> jndiRefs = new HashMap();
    protected List<PersistenceContextRef> persistenceContextRefs = new ArrayList<PersistenceContextRef>();
    protected List<PersistenceUnitRef> persistenceUnitRefs = new ArrayList<PersistenceUnitRef>();

    public Collection<MessageDestinationRef> getMessageDestinationRefs() {
        return this.messageDestinationRefs.values();
    }

    public void addMessageDestinationRef(MessageDestinationRef ref) {
        log.debug("addMessageDestinationRef, " + ref);
        this.messageDestinationRefs.put(ref.getMessageDestinationRefName(), ref);
        String link = ref.getMessageDestinationLink();
        if (link != null) {
            this.messageDestinationRefsByLink.put(link, ref);
        }
    }

    public Collection<EjbLocalRef> getEjbLocalRefs() {
        return this.ejbLocalRefs.values();
    }

    public void addEjbLocalRef(EjbLocalRef ref) {
        this.ejbLocalRefs.put(ref.getEjbRefName(), ref);
    }

    public Collection<EjbRef> getEjbRefs() {
        return this.ejbRefs.values();
    }

    public void addEjbRef(EjbRef ref) {
        this.ejbRefs.put(ref.getEjbRefName(), ref);
    }

    public Collection<EnvEntry> getEnvEntries() {
        return this.envEntries.values();
    }

    public void addEnvEntry(EnvEntry entry) {
        this.envEntries.put(entry.getEnvEntryName(), entry);
    }

    public Collection<ResourceEnvRef> getResourceEnvRefs() {
        return this.resourceEnvRefs.values();
    }

    public void addResourceEnvRef(ResourceEnvRef envRef) {
        this.resourceEnvRefs.put(envRef.getResRefName(), envRef);
    }

    public Collection<ResourceRef> getResourceRefs() {
        return this.resourceRefs.values();
    }

    public void addResourceRef(ResourceRef ref) {
        this.resourceRefs.put(ref.getResRefName(), ref);
    }

    public Collection<JndiRef> getJndiRefs() {
        return this.jndiRefs.values();
    }

    public void addJndiRef(JndiRef ref) {
        this.jndiRefs.put(ref.getJndiRefName(), ref);
    }

    public Collection<ServiceRefMetaData> getServiceRefs() {
        return this.serviceRefs.values();
    }

    public void addServiceRef(ServiceRefMetaData ref) {
        this.serviceRefs.put(ref.getServiceRefName(), ref);
    }

    public ServiceRefMetaData getServiceRef(String name) {
        return this.serviceRefs.get(name);
    }

    public void updateEjbRef(EjbRef updatedRef) {
        EjbRef ref = this.ejbRefs.get(updatedRef.getEjbRefName());
        if (ref != null) {
            ref.setMappedName(updatedRef.getMappedName());
            ref.setIgnoreDependency(updatedRef.isIgnoreDependency());
        } else {
            this.ejbRefs.put(updatedRef.getEjbRefName(), updatedRef);
        }
    }

    public void updateEjbLocalRef(EjbLocalRef updatedRef) {
        EjbLocalRef ref = this.ejbLocalRefs.get(updatedRef.getEjbRefName());
        if (ref != null) {
            ref.setMappedName(updatedRef.getMappedName());
            ref.setIgnoreDependency(updatedRef.isIgnoreDependency());
        } else {
            this.ejbLocalRefs.put(updatedRef.getEjbRefName(), updatedRef);
        }
    }

    public void updateResourceRef(ResourceRef updatedRef) {
        ResourceRef ref = this.resourceRefs.get(updatedRef.getResRefName());
        if (ref != null) {
            ref.setMappedName(updatedRef.getMappedName());
            ref.setResUrl(updatedRef.getResUrl());
            ref.setResourceName(updatedRef.getResourceName());
        } else {
            this.resourceRefs.put(updatedRef.getResRefName(), updatedRef);
        }
    }

    public void updateResourceEnvRef(ResourceEnvRef updatedRef) {
        ResourceEnvRef ref = this.resourceEnvRefs.get(updatedRef.getResRefName());
        if (ref != null) {
            ref.setMappedName(updatedRef.getMappedName());
        } else {
            this.resourceEnvRefs.put(updatedRef.getResRefName(), updatedRef);
        }
    }

    public void updateMessageDestinationRef(MessageDestinationRef updatedRef) {
        log.debug("updateMessageDestinationRef, " + updatedRef);
        MessageDestinationRef ref = this.messageDestinationRefs.get(updatedRef.getMessageDestinationRefName());
        if (ref != null) {
            ref.setMappedName(updatedRef.getMappedName());
        } else {
            this.messageDestinationRefs.put(updatedRef.getMessageDestinationRefName(), updatedRef);
            ref = updatedRef;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        return sb.toString();
    }

    public List<PersistenceContextRef> getPersistenceContextRefs() {
        return this.persistenceContextRefs;
    }

    public List<PersistenceUnitRef> getPersistenceUnitRefs() {
        return this.persistenceUnitRefs;
    }

    public void addPersistenceContextRef(PersistenceContextRef ref) {
        this.persistenceContextRefs.add(ref);
    }

    public void addPersistenceUnitRef(PersistenceUnitRef ref) {
        this.persistenceUnitRefs.add(ref);
    }

    public MessageDestinationRef getMessageDestinationRefForLink(String link) {
        MessageDestinationRef ref = this.messageDestinationRefsByLink.get(link);
        return ref;
    }
}

