/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ServerSocketFactory;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.invocation.jrmp.server.JRMPProxyFactoryMBean;
import org.jboss.naming.NamingServiceMBean;
import org.jboss.naming.Util;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.threadpool.BasicThreadPoolMBean;
import org.jboss.util.threadpool.ThreadPool;
import org.jnp.interfaces.MarshalledValuePair;
import org.jnp.interfaces.Naming;
import org.jnp.server.Main;
import org.jnp.server.NamingBean;

public class NamingService
extends ServiceMBeanSupport
implements NamingServiceMBean {
    private NamingBean namingBean;
    private Main namingMain = new Main();
    private Map marshalledInvocationMapping = new HashMap();
    private JRMPProxyFactoryMBean proxyFactory;

    public NamingBean getNaming() {
        return this.namingBean;
    }

    public void setNaming(NamingBean bean) {
        this.namingBean = bean;
        this.namingMain.setNamingInfo(bean);
    }

    public Naming getNamingInstance() {
        return this.namingBean.getNamingInstance();
    }

    public void setLookupPool(BasicThreadPoolMBean poolMBean) {
        ThreadPool lookupPool = poolMBean.getInstance();
        this.namingMain.setLookupPool(lookupPool);
    }

    public boolean getCallByValue() {
        return !MarshalledValuePair.getEnableCallByReference();
    }

    public void setCallByValue(boolean flag) {
        boolean callByValue = !flag;
        MarshalledValuePair.setEnableCallByReference(callByValue);
    }

    public void setPort(int port) {
        this.namingMain.setPort(port);
    }

    public int getPort() {
        return this.namingMain.getPort();
    }

    public void setRmiPort(int port) {
        this.namingMain.setRmiPort(port);
    }

    public int getRmiPort() {
        return this.namingMain.getRmiPort();
    }

    public String getBindAddress() {
        return this.namingMain.getBindAddress();
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.namingMain.setBindAddress(host);
    }

    public String getRmiBindAddress() {
        return this.namingMain.getRmiBindAddress();
    }

    public void setRmiBindAddress(String host) throws UnknownHostException {
        this.namingMain.setRmiBindAddress(host);
    }

    public int getBacklog() {
        return this.namingMain.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.namingMain.setBacklog(backlog);
    }

    public boolean getInstallGlobalService() {
        return this.namingMain.getInstallGlobalService();
    }

    public void setInstallGlobalService(boolean flag) {
        this.namingMain.setInstallGlobalService(flag);
    }

    public boolean getUseGlobalService() {
        return this.namingMain.getUseGlobalService();
    }

    public void setUseGlobalService(boolean flag) {
        this.namingMain.setUseGlobalService(flag);
    }

    public String getClientSocketFactory() {
        return this.namingMain.getClientSocketFactory();
    }

    public void setClientSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.namingMain.setClientSocketFactory(factoryClassName);
    }

    public RMIClientSocketFactory getClientSocketFactoryBean() {
        return this.namingMain.getClientSocketFactoryBean();
    }

    public void setClientSocketFactoryBean(RMIClientSocketFactory factory) {
        this.namingMain.setClientSocketFactoryBean(factory);
    }

    public String getServerSocketFactory() {
        return this.namingMain.getServerSocketFactory();
    }

    public void setServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.namingMain.setServerSocketFactory(factoryClassName);
    }

    public RMIServerSocketFactory getServerSocketFactoryBean() {
        return this.namingMain.getServerSocketFactoryBean();
    }

    public void setServerSocketFactoryBean(RMIServerSocketFactory factory) {
        this.namingMain.setServerSocketFactoryBean(factory);
    }

    public String getJNPServerSocketFactory() {
        return this.namingMain.getJNPServerSocketFactory();
    }

    public void setJNPServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.namingMain.setJNPServerSocketFactory(factoryClassName);
    }

    public ServerSocketFactory getJNPServerSocketFactoryBean() {
        return this.namingMain.getJNPServerSocketFactoryBean();
    }

    public void setJNPServerSocketFactoryBean(ServerSocketFactory factory) {
        this.namingMain.setJNPServerSocketFactoryBean(factory);
    }

    public void setInvokerProxyFactory(JRMPProxyFactoryMBean proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        boolean debug = this.log.isDebugEnabled();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = loader.getResourceAsStream("jndi.properties");
        if (is == null) {
            throw new RuntimeException("Cannot find jndi.properties, it should be at conf/jndi.properties by default.");
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        finally {
            is.close();
        }
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = props.getProperty(key);
            if (debug) {
                this.log.debug("System.setProperty, key=" + key + ", value=" + value);
            }
            System.setProperty(key, value);
        }
        if (this.proxyFactory != null) {
            this.namingMain.setNamingProxy(this.proxyFactory.getProxy());
        }
        this.namingMain.start();
        HashMap<Long, Method> tmpMap = new HashMap<Long, Method>(13);
        Method[] methods = Naming.class.getMethods();
        for (int m = 0; m < methods.length; ++m) {
            Method method = methods[m];
            Long hash = new Long(MarshalledInvocation.calculateHash(method));
            tmpMap.put(hash, method);
        }
        this.marshalledInvocationMapping = Collections.unmodifiableMap(tmpMap);
    }

    protected void stopService() throws Exception {
        this.namingMain.stop();
        this.log.debug("JNP server stopped");
    }

    protected Main getNamingServer() {
        return this.namingMain;
    }

    public Map getMethodMap() {
        return this.marshalledInvocationMapping;
    }

    public void createAlias(String fromName, String toName) throws Exception {
        Util.createLinkRef(fromName, toName);
        this.log.info("Created alias " + fromName + "->" + toName);
    }

    public void removeAlias(String name) throws Exception {
        this.log.info("Removing alias " + name);
        Util.removeLinkRef(name);
    }

    public Object invoke(Invocation invocation) throws Exception {
        Naming theServer = this.namingMain.getNamingInstance();
        if (invocation instanceof MarshalledInvocation) {
            MarshalledInvocation mi = (MarshalledInvocation)invocation;
            mi.setMethodMap(this.marshalledInvocationMapping);
        }
        Method method = invocation.getMethod();
        Object[] args = invocation.getArguments();
        Object value = null;
        try {
            value = method.invoke((Object)theServer, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new UndeclaredThrowableException(t, method.toString());
        }
        return value;
    }
}

