/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.ejb;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EJBProxyFactory;
import org.jboss.ejb.EJBProxyFactoryContainer;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationContext;
import org.jboss.invocation.InvocationKey;
import org.jboss.invocation.Invoker;
import org.jboss.logging.Logger;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.InvokerProxyBindingMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.naming.Util;
import org.jboss.proxy.ClientContainer;
import org.jboss.proxy.ClientContainerEx;
import org.jboss.proxy.IClientContainer;
import org.jboss.proxy.Interceptor;
import org.jboss.proxy.ejb.EJBMetaDataImpl;
import org.jboss.proxy.ejb.handle.HomeHandleImpl;
import org.jboss.system.Registry;
import org.jboss.util.NestedRuntimeException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProxyFactory
implements EJBProxyFactory {
    protected static final String HOME_INTERCEPTOR = "home";
    protected static final String BEAN_INTERCEPTOR = "bean";
    protected static final String LIST_ENTITY_INTERCEPTOR = "list-entity";
    protected static Logger log = Logger.getLogger(ProxyFactory.class);
    public EJBMetaData ejbMetaData;
    protected boolean isServiceEndpointOnly;
    protected EJBHome home;
    protected EJBObject statelessObject;
    protected String jndiBinding;
    protected ObjectName jmxName;
    protected int jmxNameHash;
    private Integer jmxNameHashInteger;
    protected Invoker beanInvoker;
    protected Invoker homeInvoker;
    protected InvokerProxyBindingMetaData invokerMetaData;
    protected ArrayList homeInterceptorClasses = new ArrayList();
    protected ArrayList beanInterceptorClasses = new ArrayList();
    protected ArrayList listEntityInterceptorClasses = new ArrayList();
    protected boolean includeIClientIface;
    protected Container container;
    protected Constructor proxyClassConstructor;

    public void setContainer(Container con) {
        this.container = con;
    }

    public void setInvokerMetaData(InvokerProxyBindingMetaData metadata) {
        this.invokerMetaData = metadata;
    }

    public void setInvokerBinding(String binding) {
        this.jndiBinding = binding;
    }

    public void create() throws Exception {
        this.jmxName = this.container.getJmxName();
        this.jmxNameHash = this.jmxName.hashCode();
        this.jmxNameHashInteger = new Integer(this.jmxNameHash);
        BeanMetaData bmd = this.container.getBeanMetaData();
        boolean isSession = !(bmd instanceof EntityMetaData);
        boolean isStatelessSession = false;
        if (isSession) {
            SessionMetaData smd = (SessionMetaData)bmd;
            if (bmd.getRemote() == null) {
                this.isServiceEndpointOnly = true;
                return;
            }
            isStatelessSession = smd.isStateless();
        }
        Class<?> pkClass = null;
        if (!isSession) {
            EntityMetaData metaData = (EntityMetaData)bmd;
            String pkClassName = metaData.getPrimaryKeyClass();
            try {
                pkClass = pkClassName != null ? this.container.getClassLoader().loadClass(pkClassName) : this.container.getClassLoader().loadClass(metaData.getEjbClass()).getField(metaData.getPrimKeyField()).getClass();
            }
            catch (NoSuchFieldException e) {
                log.error("Unable to identify Bean's Primary Key class! Did you specify a primary key class and/or field?  Does that field exist?");
                throw new RuntimeException("Primary Key Problem");
            }
            catch (NullPointerException e) {
                log.error("Unable to identify Bean's Primary Key class! Did you specify a primary key class and/or field?  Does that field exist?");
                throw new RuntimeException("Primary Key Problem");
            }
        }
        this.ejbMetaData = new EJBMetaDataImpl(((EJBProxyFactoryContainer)((Object)this.container)).getRemoteClass(), ((EJBProxyFactoryContainer)((Object)this.container)).getHomeClass(), pkClass, isSession, isStatelessSession, new HomeHandleImpl(this.jndiBinding));
        log.debug("Proxy Factory for " + this.jndiBinding + " initialized");
        this.initInterceptorClasses();
    }

    public void start() throws Exception {
        if (!this.isServiceEndpointOnly) {
            this.setupInvokers();
            this.bindProxy();
        }
    }

    protected void setupInvokers() throws Exception {
        ObjectName oname = new ObjectName(this.invokerMetaData.getInvokerMBean());
        Invoker invoker = (Invoker)Registry.lookup(oname);
        if (invoker == null) {
            throw new RuntimeException("invoker is null: " + oname);
        }
        this.homeInvoker = this.beanInvoker = invoker;
    }

    protected void initInterceptorClasses() throws Exception {
        HashMap<String, Element> interceptors = new HashMap<String, Element>();
        Element proxyConfig = this.invokerMetaData.getProxyFactoryConfig();
        Element clientInterceptors = MetaData.getOptionalChild(proxyConfig, "client-interceptors", null);
        if (clientInterceptors != null) {
            String value = MetaData.getElementAttribute(clientInterceptors, "exposeContainer");
            this.includeIClientIface = Boolean.valueOf(value);
            NodeList children = clientInterceptors.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node currentChild = children.item(i);
                if (currentChild.getNodeType() != 1) continue;
                Element interceptor = (Element)children.item(i);
                interceptors.put(interceptor.getTagName(), interceptor);
            }
        } else {
            log.debug("client interceptors element is null");
        }
        Element homeInterceptorConf = (Element)interceptors.get(HOME_INTERCEPTOR);
        this.loadInterceptorClasses(this.homeInterceptorClasses, homeInterceptorConf);
        if (this.homeInterceptorClasses.size() == 0) {
            throw new DeploymentException("There are no home interface interceptors configured");
        }
        Element beanInterceptorConf = (Element)interceptors.get(BEAN_INTERCEPTOR);
        this.loadInterceptorClasses(this.beanInterceptorClasses, beanInterceptorConf);
        if (this.beanInterceptorClasses.size() == 0) {
            throw new DeploymentException("There are no bean interface interceptors configured");
        }
        Element listEntityInterceptorConf = (Element)interceptors.get(LIST_ENTITY_INTERCEPTOR);
        this.loadInterceptorClasses(this.listEntityInterceptorClasses, listEntityInterceptorConf);
    }

    protected void loadInterceptorClasses(ArrayList classes, Element interceptors) throws Exception {
        Iterator interceptorElements = MetaData.getChildrenByTagName(interceptors, "interceptor");
        ClassLoader loader = this.container.getClassLoader();
        while (interceptorElements != null && interceptorElements.hasNext()) {
            Class<?> clazz;
            Element ielement = (Element)interceptorElements.next();
            String className = null;
            className = MetaData.getElementContent(ielement);
            String byValueAttr = MetaData.getElementAttribute(ielement, "call-by-value");
            if (byValueAttr != null) {
                if (this.container.isCallByValue() != new Boolean(byValueAttr).booleanValue()) continue;
                clazz = loader.loadClass(className);
                classes.add(clazz);
                continue;
            }
            clazz = loader.loadClass(className);
            classes.add(clazz);
        }
    }

    protected void loadInterceptorChain(ArrayList chain, ClientContainer client) throws Exception {
        Interceptor last = null;
        for (int i = 0; i < chain.size(); ++i) {
            Class clazz = (Class)chain.get(i);
            Interceptor interceptor = (Interceptor)clazz.newInstance();
            if (last == null) {
                last = interceptor;
                client.setNext(interceptor);
                continue;
            }
            last.setNext(interceptor);
            last = interceptor;
        }
    }

    protected void bindProxy() throws Exception {
        try {
            InvocationContext context = new InvocationContext();
            context.setObjectName(this.jmxNameHashInteger);
            context.setValue(InvocationKey.JNDI_NAME, this.jndiBinding);
            context.setInvoker(this.homeInvoker);
            context.setValue(InvocationKey.EJB_METADATA, this.ejbMetaData);
            context.setInvokerProxyBinding(this.invokerMetaData.getName());
            ClientContainer client = null;
            EJBProxyFactoryContainer pfc = (EJBProxyFactoryContainer)((Object)this.container);
            Class[] ifaces = new Class[]{pfc.getHomeClass(), Class.forName("javax.ejb.Handle")};
            if (this.includeIClientIface) {
                ifaces = new Class[]{IClientContainer.class, pfc.getHomeClass(), Class.forName("javax.ejb.Handle")};
                client = new ClientContainerEx(context);
            } else {
                client = new ClientContainer(context);
            }
            this.loadInterceptorChain(this.homeInterceptorClasses, client);
            this.home = (EJBHome)Proxy.newProxyInstance(pfc.getHomeClass().getClassLoader(), ifaces, (InvocationHandler)client);
            if (this.ejbMetaData.isStatelessSession()) {
                context = new InvocationContext();
                context.setObjectName(this.jmxNameHashInteger);
                context.setValue(InvocationKey.JNDI_NAME, this.jndiBinding);
                context.setInvoker(this.beanInvoker);
                context.setInvokerProxyBinding(this.invokerMetaData.getName());
                context.setValue(InvocationKey.EJB_HOME, this.home);
                Class[] ssifaces = new Class[]{pfc.getRemoteClass()};
                if (this.includeIClientIface) {
                    ssifaces = new Class[]{IClientContainer.class, pfc.getRemoteClass()};
                    client = new ClientContainerEx(context);
                } else {
                    client = new ClientContainer(context);
                }
                this.loadInterceptorChain(this.beanInterceptorClasses, client);
                this.statelessObject = (EJBObject)Proxy.newProxyInstance(pfc.getRemoteClass().getClassLoader(), ssifaces, (InvocationHandler)client);
            } else {
                Class[] intfs = new Class[]{pfc.getRemoteClass()};
                if (this.includeIClientIface) {
                    intfs = new Class[]{IClientContainer.class, pfc.getRemoteClass()};
                }
                Class<?> proxyClass = Proxy.getProxyClass(pfc.getRemoteClass().getClassLoader(), intfs);
                Class[] constructorParams = new Class[]{InvocationHandler.class};
                this.proxyClassConstructor = proxyClass.getConstructor(constructorParams);
            }
            this.rebindHomeProxy();
        }
        catch (Exception e) {
            throw new ServerException("Could not bind home", e);
        }
    }

    protected void rebindHomeProxy() throws NamingException {
        log.debug("(re-)Binding Home " + this.jndiBinding);
        Util.rebind((Context)new InitialContext(), this.jndiBinding, this.getEJBHome());
        log.info("Bound EJB Home '" + this.container.getBeanMetaData().getEjbName() + "' to jndi '" + this.jndiBinding + "'");
    }

    public void stop() {
    }

    public void destroy() {
        if (!this.isServiceEndpointOnly) {
            log.info("Unbind EJB Home '" + this.container.getBeanMetaData().getEjbName() + "' from jndi '" + this.jndiBinding + "'");
            try {
                InitialContext ctx = new InitialContext();
                ctx.unbind(this.jndiBinding);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.homeInterceptorClasses.clear();
            this.beanInterceptorClasses.clear();
            this.listEntityInterceptorClasses.clear();
        }
        this.container = null;
        this.ejbMetaData = null;
        this.home = null;
        this.statelessObject = null;
        this.beanInvoker = null;
        this.homeInvoker = null;
        this.invokerMetaData = null;
        this.proxyClassConstructor = null;
    }

    public boolean isIdentical(Container container, Invocation mi) {
        throw new UnsupportedOperationException("TODO provide a default implementation");
    }

    public EJBMetaData getEJBMetaData() {
        return this.ejbMetaData;
    }

    public Object getEJBHome() {
        return this.home;
    }

    public Object getStatelessSessionEJBObject() {
        return this.statelessObject;
    }

    public Object getStatefulSessionEJBObject(Object id) {
        InvocationContext context = new InvocationContext();
        context.setObjectName(this.jmxNameHashInteger);
        context.setCacheId(id);
        context.setValue(InvocationKey.JNDI_NAME, this.jndiBinding);
        context.setInvoker(this.beanInvoker);
        log.debug("seting invoker proxy binding for stateful session: " + this.invokerMetaData.getName());
        context.setInvokerProxyBinding(this.invokerMetaData.getName());
        context.setValue(InvocationKey.EJB_HOME, this.home);
        context.setValue("InvokerID", Invoker.ID);
        ClientContainer client = this.includeIClientIface ? new ClientContainerEx(context) : new ClientContainer(context);
        try {
            this.loadInterceptorChain(this.beanInterceptorClasses, client);
        }
        catch (Exception e) {
            throw new NestedRuntimeException("Failed to load interceptor chain", e);
        }
        try {
            return (EJBObject)this.proxyClassConstructor.newInstance(client);
        }
        catch (Exception ex) {
            throw new NestedRuntimeException(ex);
        }
    }

    public Object getEntityEJBObject(Object id) {
        Object result;
        if (id == null) {
            result = null;
        } else {
            InvocationContext context = new InvocationContext();
            context.setObjectName(this.jmxNameHashInteger);
            context.setCacheId(id);
            context.setValue(InvocationKey.JNDI_NAME, this.jndiBinding);
            context.setInvoker(this.beanInvoker);
            context.setInvokerProxyBinding(this.invokerMetaData.getName());
            context.setValue(InvocationKey.EJB_HOME, this.home);
            ClientContainer client = this.includeIClientIface ? new ClientContainerEx(context) : new ClientContainer(context);
            try {
                this.loadInterceptorChain(this.beanInterceptorClasses, client);
            }
            catch (Exception e) {
                throw new NestedRuntimeException("Failed to load interceptor chain", e);
            }
            try {
                result = this.proxyClassConstructor.newInstance(client);
            }
            catch (Exception ex) {
                throw new NestedRuntimeException(ex);
            }
        }
        return result;
    }

    public Collection getEntityCollection(Collection ids) {
        ArrayList<Object> list2 = new ArrayList<Object>(ids.size());
        for (Object nextId : ids) {
            list2.add(this.getEntityEJBObject(nextId));
        }
        return list2;
    }
}

