/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jboss.logging.Logger;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;
import org.jboss.reflect.spi.ProgressionConvertor;
import org.jboss.reflect.spi.ProgressionConvertorFactory;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.propertyeditor.PropertyEditors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueConvertor {
    private static final Logger log = Logger.getLogger(ValueConvertor.class);

    public static Object convertValue(Class<? extends Object> clazz, Object value) throws Throwable {
        return ValueConvertor.convertValue(clazz, value, false);
    }

    public static Object convertValue(Class<? extends Object> clazz, Object value, boolean replaceProperties) throws Throwable {
        PropertyEditor editor;
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (replaceProperties && valueClass == String.class) {
            String string = (String)value;
            value = StringPropertyReplacer.replaceProperties(string);
        }
        if (clazz.isAssignableFrom(valueClass)) {
            return value;
        }
        if (clazz.isEnum()) {
            Class<Enum> eclazz = clazz.asSubclass(Enum.class);
            return Enum.valueOf(eclazz, value.toString());
        }
        if (valueClass == String.class && (editor = PropertyEditorManager.findEditor(clazz)) != null) {
            editor.setAsText((String)value);
            return editor.getValue();
        }
        try {
            Method method = clazz.getMethod("valueOf", valueClass);
            int modifiers = method.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && clazz.isAssignableFrom(method.getReturnType())) {
                return ReflectionUtils.invoke(null, method, new Object[]{value});
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (valueClass == String.class) {
            try {
                Constructor<? extends Object> constructor = clazz.getConstructor(valueClass);
                if (Modifier.isPublic(constructor.getModifiers())) {
                    return ReflectionUtils.newInstance(constructor, new Object[]{value});
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return value;
    }

    public static Object progressValue(Class<? extends Object> clazz, Object value) throws Throwable {
        if (value != null) {
            ProgressionConvertor convertor = ProgressionConvertorFactory.getInstance().getConvertor();
            if (convertor.canProgress(clazz, value.getClass())) {
                return convertor.doProgression(clazz, value);
            }
            return null;
        }
        return value;
    }

    static {
        try {
            PropertyEditors.init();
        }
        catch (Throwable t) {
            log.debug("Unable to initialise property editors", t);
        }
    }
}

