/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.container.modules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthParam;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.module.ServerAuthModule;
import org.jboss.security.SimplePrincipal;

public class SimpleServerAuthModule
implements ServerAuthModule {
    private Class[] supportedTypes = null;
    private List principals = new ArrayList();
    private Object credential = null;
    private MessagePolicy requestPolicy = null;
    private MessagePolicy responsePolicy = null;
    private CallbackHandler handler = null;
    private Map options = null;

    public SimpleServerAuthModule(Class[] supportedTypes) {
        this.supportedTypes = supportedTypes;
    }

    public void cleanSubject(Subject subject, Map sharedState) throws AuthException {
        subject.getPrincipals().remove(this.principals);
        subject.getPublicCredentials().remove(this.credential);
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.requestPolicy = requestPolicy;
        this.responsePolicy = responsePolicy;
        this.handler = handler;
        this.options = options;
    }

    public AuthStatus secureResponse(AuthParam param, Subject source, Map sharedState) throws AuthException {
        if (source.getPrincipals() == null) {
            throw new AuthException("Principal Set is null");
        }
        if (source.getPublicCredentials() == null) {
            throw new AuthException("Public Credentials is null");
        }
        source.getPrincipals().addAll(this.principals);
        source.getPublicCredentials().add(this.credential);
        return AuthStatus.PROCEED;
    }

    public AuthStatus validateRequest(AuthParam param, Subject source, Subject recipient, Map sharedState) throws AuthException {
        Set<SimplePrincipal> sourceSet = source.getPrincipals(SimplePrincipal.class);
        Set<SimplePrincipal> recipientSet = recipient.getPrincipals(SimplePrincipal.class);
        if (sourceSet == null && recipientSet == null) {
            throw new AuthException("Principals are null");
        }
        if (sourceSet.size() != recipientSet.size()) {
            throw new AuthException("Principals size are different");
        }
        Set<SimplePrincipal> publicPrincipals = recipient.getPublicCredentials(SimplePrincipal.class);
        Iterator<SimplePrincipal> iter = publicPrincipals.iterator();
        while (iter.hasNext()) {
            this.principals.add(iter.next());
        }
        return AuthStatus.PROCEED;
    }

    public Class[] getSupportedMessageTypes() {
        return this.supportedTypes;
    }
}

