/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextUtil;
import org.jboss.security.SubjectInfo;
import org.jboss.security.plugins.JBossSecurityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossSecurityContextUtil
extends SecurityContextUtil {
    @Override
    public <T> T get(SecurityContext sc, String key) {
        if ("RunAsIdentity".equals(key)) {
            return (T)sc.getRunAs();
        }
        return (T)sc.getData().get(key);
    }

    @Override
    public String getUserName(SubjectInfo subjectInfo) {
        Principal p = this.getUserPrincipal(subjectInfo);
        return p != null ? p.getName() : null;
    }

    @Override
    public Principal getUserPrincipal(SubjectInfo subjectInfo) {
        return subjectInfo.getAuthenticationPrincipal();
    }

    @Override
    public <T> void set(SecurityContext sc, String key, T obj) {
        if (!(sc instanceof JBossSecurityContext)) {
            throw new IllegalArgumentException("Not JBoss security context:" + sc);
        }
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        if (obj != null) {
            if ("RunAsIdentity".equals(key) && !(obj instanceof RunAsIdentity)) {
                throw new IllegalArgumentException("Not RunAsIdentity:" + obj);
            }
            if ("Roles".equals(key) && !(obj instanceof Group)) {
                throw new IllegalArgumentException("Not Group:" + obj);
            }
        }
        if ("RunAsIdentity".equals(key)) {
            this.setRunAsIdentity(sc, (RunAsIdentity)obj);
        } else {
            sc.getData().put(key, obj);
        }
    }

    @Override
    public <T> T remove(SecurityContext sc, String key) {
        if (!(sc instanceof JBossSecurityContext)) {
            throw new IllegalArgumentException("Not JBoss security context:" + sc);
        }
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        Map<String, Object> contextMap = sc.getData();
        if ("RunAsIdentity".equals(key)) {
            RunAs runAs = sc.getRunAs();
            sc.setRunAs((RunAs)contextMap.get("CallerRunAsIdentity"));
            contextMap.remove("CallerRunAsIdentity");
            return (T)runAs;
        }
        return (T)contextMap.remove(key);
    }

    private void setRunAsIdentity(SecurityContext sc, RunAsIdentity rai) {
        Map<String, Object> contextMap = sc.getData();
        RunAs currentRA = sc.getRunAs();
        contextMap.put("CallerRunAsIdentity", currentRA);
        sc.setRunAs(rai);
    }
}

