/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.handler;

import java.util.List;
import java.util.Observable;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.PortInfo;
import org.jboss.logging.Logger;
import org.jboss.ws.core.jaxws.handler.HandlerChainExecutor;
import org.jboss.ws.core.jaxws.handler.HandlerResolverImpl;
import org.jboss.ws.core.jaxws.handler.PortInfoImpl;
import org.jboss.ws.core.server.ServerHandlerDelegate;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerDelegateJAXWS
extends ServerHandlerDelegate {
    private static Logger log = Logger.getLogger(HandlerDelegateJAXWS.class);
    private HandlerResolverImpl resolver = new HandlerResolverImpl();
    private ThreadLocal<HandlerChainExecutor> preExecutor = new ThreadLocal();
    private ThreadLocal<HandlerChainExecutor> jaxwsExecutor = new ThreadLocal();
    private ThreadLocal<HandlerChainExecutor> postExecutor = new ThreadLocal();

    public HandlerDelegateJAXWS(ServerEndpointMetaData sepMetaData) {
        super(sepMetaData);
        sepMetaData.registerConfigObserver(this);
    }

    @Override
    protected HandlerMetaData.HandlerType[] getHandlerTypeOrder() {
        return new HandlerMetaData.HandlerType[]{HandlerMetaData.HandlerType.POST, HandlerMetaData.HandlerType.ENDPOINT, HandlerMetaData.HandlerType.PRE};
    }

    @Override
    public boolean callRequestHandlerChain(ServerEndpointMetaData sepMetaData, HandlerMetaData.HandlerType type) {
        log.debug("callRequestHandlerChain: " + (Object)((Object)type));
        if (!this.isInitialized()) {
            this.resolver.initHandlerChain(sepMetaData, HandlerMetaData.HandlerType.PRE, true);
            this.resolver.initHandlerChain(sepMetaData, HandlerMetaData.HandlerType.ENDPOINT, true);
            this.resolver.initHandlerChain(sepMetaData, HandlerMetaData.HandlerType.POST, true);
            this.setInitialized(true);
        }
        HandlerChainExecutor executor = this.createExecutor(sepMetaData, type);
        MessageContext msgContext = (MessageContext)((Object)MessageContextAssociation.peekMessageContext());
        return executor.handleMessage(msgContext);
    }

    @Override
    public boolean callResponseHandlerChain(ServerEndpointMetaData sepMetaData, HandlerMetaData.HandlerType type) {
        log.debug("callResponseHandlerChain: " + (Object)((Object)type));
        HandlerChainExecutor executor = this.getExecutor(type);
        MessageContext msgContext = (MessageContext)((Object)MessageContextAssociation.peekMessageContext());
        return executor != null ? executor.handleMessage(msgContext) : true;
    }

    @Override
    public void closeHandlerChain(ServerEndpointMetaData sepMetaData, HandlerMetaData.HandlerType type) {
        log.debug("closeHandlerChain");
        HandlerChainExecutor executor = this.getExecutor(type);
        MessageContext msgContext = (MessageContext)((Object)MessageContextAssociation.peekMessageContext());
        if (executor != null) {
            executor.close(msgContext);
            this.removeExecutor(type);
        }
    }

    @Override
    public boolean callFaultHandlerChain(ServerEndpointMetaData sepMetaData, HandlerMetaData.HandlerType type, Exception ex) {
        log.debug("callFaultHandlerChain: " + (Object)((Object)type));
        HandlerChainExecutor executor = this.getExecutor(type);
        MessageContext msgContext = (MessageContext)((Object)MessageContextAssociation.peekMessageContext());
        return executor != null ? executor.handleFault(msgContext, ex) : true;
    }

    private List<Handler> getHandlerChain(EndpointMetaData epMetaData, HandlerMetaData.HandlerType type) {
        PortInfo info = this.getPortInfo(epMetaData);
        return this.resolver.getHandlerChain(info, type);
    }

    private PortInfo getPortInfo(EndpointMetaData epMetaData) {
        QName serviceName = epMetaData.getServiceMetaData().getServiceName();
        QName portName = epMetaData.getPortName();
        String bindingId = epMetaData.getBindingId();
        PortInfoImpl info = new PortInfoImpl(serviceName, portName, bindingId);
        return info;
    }

    @Override
    public Set<QName> getHeaders() {
        return this.resolver.getHeaders();
    }

    private HandlerChainExecutor createExecutor(ServerEndpointMetaData sepMetaData, HandlerMetaData.HandlerType type) {
        if (type == HandlerMetaData.HandlerType.ALL) {
            throw new IllegalArgumentException("Invalid handler type: " + (Object)((Object)type));
        }
        HandlerChainExecutor executor = new HandlerChainExecutor(sepMetaData, this.getHandlerChain(sepMetaData, type));
        if (type == HandlerMetaData.HandlerType.PRE) {
            this.preExecutor.set(executor);
        } else if (type == HandlerMetaData.HandlerType.ENDPOINT) {
            this.jaxwsExecutor.set(executor);
        } else if (type == HandlerMetaData.HandlerType.POST) {
            this.postExecutor.set(executor);
        }
        return executor;
    }

    private HandlerChainExecutor getExecutor(HandlerMetaData.HandlerType type) {
        if (type == HandlerMetaData.HandlerType.ALL) {
            throw new IllegalArgumentException("Invalid handler type: " + (Object)((Object)type));
        }
        HandlerChainExecutor executor = null;
        if (type == HandlerMetaData.HandlerType.PRE) {
            executor = this.preExecutor.get();
        } else if (type == HandlerMetaData.HandlerType.ENDPOINT) {
            executor = this.jaxwsExecutor.get();
        } else if (type == HandlerMetaData.HandlerType.POST) {
            executor = this.postExecutor.get();
        }
        return executor;
    }

    private void removeExecutor(HandlerMetaData.HandlerType type) {
        if (type == HandlerMetaData.HandlerType.ALL) {
            throw new IllegalArgumentException("Invalid handler type: " + (Object)((Object)type));
        }
        if (type == HandlerMetaData.HandlerType.PRE) {
            this.preExecutor.remove();
        } else if (type == HandlerMetaData.HandlerType.ENDPOINT) {
            this.jaxwsExecutor.remove();
        } else if (type == HandlerMetaData.HandlerType.POST) {
            this.postExecutor.remove();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
    }
}

