/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap.attachment;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.jboss.ws.core.utils.IOUtils;
import org.jboss.ws.core.utils.MimeUtils;

public class ByteArrayContentHandler
implements DataContentHandler {
    private DataFlavor[] flavors = new ActivationDataFlavor[]{new ActivationDataFlavor(ByteArrayInputStream.class, "application/octet-stream", "OCTETS")};

    public Object getContent(DataSource dataSource) throws IOException {
        return dataSource.getInputStream();
    }

    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws UnsupportedFlavorException, IOException {
        return this.getContent(dataSource);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        if (object instanceof byte[]) {
            outputStream.write((byte[])object);
        } else if (object instanceof DataHandler) {
            IOUtils.copyStream(outputStream, ((DataHandler)object).getInputStream());
        } else {
            MimeUtils.ByteArrayConverter converter = MimeUtils.getConverterForJavaType(object.getClass());
            converter.writeTo(object, outputStream);
        }
    }
}

