/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.utils;

import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.HashSet;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaUtils {
    private static final Logger log = Logger.getLogger(JavaUtils.class);
    private static HashMap<String, Class> primitiveNames = new HashMap(8);
    private static HashMap<String, String> primitiveNameDescriptors = new HashMap(8);
    private static HashSet<String> reservedKeywords = new HashSet(50);

    public static Class loadJavaType(String typeName) throws ClassNotFoundException {
        return JavaUtils.loadJavaType(typeName, null);
    }

    public static Class loadJavaType(String typeName, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> javaType;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if ((javaType = primitiveNames.get(typeName)) == null) {
            javaType = JavaUtils.getArray(typeName, classLoader);
        }
        if (javaType == null) {
            javaType = classLoader.loadClass(typeName);
        }
        return javaType;
    }

    public static boolean isPrimitive(String javaType) {
        return JavaUtils.getPrimitiveType(javaType) != null;
    }

    public static boolean isPrimitive(Class javaType) {
        return javaType.isPrimitive() || javaType.isArray() && JavaUtils.isPrimitive(javaType.getComponentType());
    }

    public static Class getPrimitiveType(String javaType) {
        Class type = primitiveNames.get(javaType);
        if (type != null) {
            return type;
        }
        try {
            type = JavaUtils.getArray(javaType, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return type;
    }

    private static Class getArray(String javaType, ClassLoader loader) throws ClassNotFoundException {
        if (javaType.charAt(0) == '[') {
            return JavaUtils.getArrayFromJVMName(javaType, loader);
        }
        if (javaType.endsWith("[]")) {
            return JavaUtils.getArrayFromSourceName(javaType, loader);
        }
        return null;
    }

    private static Class getArrayFromJVMName(String javaType, ClassLoader loader) throws ClassNotFoundException {
        Class<Constable> componentType;
        int componentStart = javaType.lastIndexOf(91) + 1;
        switch (javaType.charAt(componentStart)) {
            case 'I': {
                componentType = Integer.TYPE;
                break;
            }
            case 'S': {
                componentType = Short.TYPE;
                break;
            }
            case 'Z': {
                componentType = Boolean.TYPE;
                break;
            }
            case 'B': {
                componentType = Byte.TYPE;
                break;
            }
            case 'J': {
                componentType = Long.TYPE;
                break;
            }
            case 'D': {
                componentType = Double.TYPE;
                break;
            }
            case 'F': {
                componentType = Float.TYPE;
                break;
            }
            case 'C': {
                componentType = Character.TYPE;
                break;
            }
            case 'L': {
                if (loader == null) {
                    return null;
                }
                String name = javaType.substring(componentStart + 1, javaType.length() - 1);
                componentType = loader.loadClass(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid binary component for array: " + javaType.charAt(componentStart));
            }
        }
        return Array.newInstance(componentType, new int[componentStart]).getClass();
    }

    private static Class getArrayFromSourceName(String javaType, ClassLoader loader) throws ClassNotFoundException {
        int arrayStart = javaType.indexOf(91);
        String componentName = javaType.substring(0, arrayStart);
        Class<?> componentType = primitiveNames.get(componentName);
        if (componentType == null) {
            if (loader == null) {
                return null;
            }
            componentType = loader.loadClass(componentName);
        }
        int dimensions = javaType.length() - arrayStart >> 1;
        return Array.newInstance(componentType, new int[dimensions]).getClass();
    }

    public static Class getPrimitiveType(Class javaType) {
        if (javaType == Integer.class) {
            return Integer.TYPE;
        }
        if (javaType == Short.class) {
            return Short.TYPE;
        }
        if (javaType == Boolean.class) {
            return Boolean.TYPE;
        }
        if (javaType == Byte.class) {
            return Byte.TYPE;
        }
        if (javaType == Long.class) {
            return Long.TYPE;
        }
        if (javaType == Double.class) {
            return Double.TYPE;
        }
        if (javaType == Float.class) {
            return Float.TYPE;
        }
        if (javaType == Character.class) {
            return Character.TYPE;
        }
        if (javaType == Integer[].class) {
            return int[].class;
        }
        if (javaType == Short[].class) {
            return short[].class;
        }
        if (javaType == Boolean[].class) {
            return boolean[].class;
        }
        if (javaType == Byte[].class) {
            return byte[].class;
        }
        if (javaType == Long[].class) {
            return long[].class;
        }
        if (javaType == Double[].class) {
            return double[].class;
        }
        if (javaType == Float[].class) {
            return float[].class;
        }
        if (javaType == Character[].class) {
            return char[].class;
        }
        if (javaType.isArray() && javaType.getComponentType().isArray()) {
            Class compType = JavaUtils.getPrimitiveType(javaType.getComponentType());
            return Array.newInstance(compType, 0).getClass();
        }
        return javaType;
    }

    public static Object getPrimitiveValueArray(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> javaType = value.getClass();
        if (javaType.isArray()) {
            int length = Array.getLength(value);
            Object destArr = Array.newInstance(JavaUtils.getPrimitiveType(javaType.getComponentType()), length);
            for (int i = 0; i < length; ++i) {
                Object srcObj = Array.get(value, i);
                Array.set(destArr, i, JavaUtils.getPrimitiveValueArray(srcObj));
            }
            return destArr;
        }
        return value;
    }

    public static Class getWrapperType(Class javaType) {
        if (javaType == Integer.TYPE) {
            return Integer.class;
        }
        if (javaType == Short.TYPE) {
            return Short.class;
        }
        if (javaType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (javaType == Byte.TYPE) {
            return Byte.class;
        }
        if (javaType == Long.TYPE) {
            return Long.class;
        }
        if (javaType == Double.TYPE) {
            return Double.class;
        }
        if (javaType == Float.TYPE) {
            return Float.class;
        }
        if (javaType == Character.TYPE) {
            return Character.class;
        }
        if (javaType == int[].class) {
            return Integer[].class;
        }
        if (javaType == short[].class) {
            return Short[].class;
        }
        if (javaType == boolean[].class) {
            return Boolean[].class;
        }
        if (javaType == byte[].class) {
            return Byte[].class;
        }
        if (javaType == long[].class) {
            return Long[].class;
        }
        if (javaType == double[].class) {
            return Double[].class;
        }
        if (javaType == float[].class) {
            return Float[].class;
        }
        if (javaType == char[].class) {
            return Character[].class;
        }
        if (javaType.isArray() && javaType.getComponentType().isArray()) {
            Class compType = JavaUtils.getWrapperType(javaType.getComponentType());
            return Array.newInstance(compType, 0).getClass();
        }
        return javaType;
    }

    public static Object getWrapperValueArray(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> javaType = value.getClass();
        if (javaType.isArray()) {
            int length = Array.getLength(value);
            Object destArr = Array.newInstance(JavaUtils.getWrapperType(javaType.getComponentType()), length);
            for (int i = 0; i < length; ++i) {
                Object srcObj = Array.get(value, i);
                Array.set(destArr, i, JavaUtils.getWrapperValueArray(srcObj));
            }
            return destArr;
        }
        return value;
    }

    public static Object syncArray(Object array, Class target) {
        return JavaUtils.isPrimitive(target) ? JavaUtils.getPrimitiveValueArray(array) : JavaUtils.getWrapperValueArray(array);
    }

    public static boolean isAssignableFrom(Class dest, Class src) {
        if (dest == null) {
            throw new IllegalArgumentException("Destination class cannot be null");
        }
        if (src == null) {
            throw new IllegalArgumentException("Source class cannot be null");
        }
        boolean isAssignable = dest.isAssignableFrom(src);
        if (!isAssignable && dest.getName().equals(src.getName())) {
            ClassLoader destLoader = dest.getClassLoader();
            ClassLoader srcLoader = src.getClassLoader();
            if (log.isDebugEnabled()) {
                log.debug("Not assignable because of conflicting class loaders:\ndstLoader=" + destLoader + "\nsrcLoader=" + srcLoader);
            }
        }
        if (!isAssignable && JavaUtils.isPrimitive(dest)) {
            dest = JavaUtils.getWrapperType(dest);
            isAssignable = dest.isAssignableFrom(src);
        }
        if (!isAssignable && JavaUtils.isPrimitive(src)) {
            src = JavaUtils.getWrapperType(src);
            isAssignable = dest.isAssignableFrom(src);
        }
        return isAssignable;
    }

    public static String convertJVMNameToSourceName(String typeName, ClassLoader loader) {
        try {
            Class javaType = JavaUtils.loadJavaType(typeName, loader);
            typeName = JavaUtils.getSourceName(javaType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return typeName;
    }

    public static String toSignature(String externalName) {
        if (externalName == null) {
            return null;
        }
        String ret = primitiveNameDescriptors.get(externalName);
        if (ret != null) {
            return ret;
        }
        ret = externalName.replace('.', '/');
        return ret.charAt(0) == '[' ? ret : "L" + ret + ";";
    }

    public static String printArray(Object[] val) {
        if (val == null) {
            return "null";
        }
        StringBuilder out = new StringBuilder("[");
        for (int i = 0; i < val.length; ++i) {
            if (i > 0) {
                out.append(",");
            }
            out.append(val[i].getClass().isArray() ? JavaUtils.printArray((Object[])val[i]) : val[i]);
        }
        return out.append("]").toString();
    }

    public static String getSourceName(Class type) {
        if (!type.isArray()) {
            return type.getName();
        }
        String arrayNotation = "";
        Class<?> component = type;
        while (component.isArray()) {
            component = component.getComponentType();
            arrayNotation = arrayNotation + "[]";
        }
        return component.getName() + arrayNotation;
    }

    public static String capitalize(String source) {
        if (source == null) {
            return null;
        }
        if (source.length() == 0) {
            return source;
        }
        if (Character.isUpperCase(source.charAt(0))) {
            return source;
        }
        char c = Character.toUpperCase(source.charAt(0));
        return c + source.substring(1);
    }

    public static boolean isLoaded(String className, ClassLoader loader) {
        try {
            JavaUtils.loadJavaType(className, loader);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static String getPackageName(Class<?> clazz) {
        String fullName = clazz.getName();
        return fullName.substring(0, fullName.lastIndexOf("."));
    }

    public static boolean isReservedKeyword(String keyword) {
        return reservedKeywords.contains(keyword);
    }

    public static Class erasure(Type type) {
        if (type instanceof ParameterizedType) {
            return JavaUtils.erasure(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            return JavaUtils.erasure(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return JavaUtils.erasure(((WildcardType)type).getUpperBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(JavaUtils.erasure(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        return (Class)type;
    }

    public static String[] getRawParameterTypeArguments(ParameterizedType type) {
        Type[] arguments = type.getActualTypeArguments();
        String[] ret = new String[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Class raw = JavaUtils.erasure(arguments[i]);
            ret[i] = raw.getName();
        }
        return ret;
    }

    public static boolean isRetro14() {
        return !(String.class instanceof Type);
    }

    public static boolean isJBossRepositoryClassLoader(ClassLoader loader) {
        Class<?> clazz = loader.getClass();
        while (!clazz.getName().startsWith("java")) {
            if ("org.jboss.mx.loading.RepositoryClassLoader".equals(clazz.getName())) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static void clearBlacklists(ClassLoader loader) {
        block3: {
            if (JavaUtils.isJBossRepositoryClassLoader(loader)) {
                try {
                    loader.getClass().getMethod("clearBlacklists", new Class[0]).invoke((Object)loader, new Object[0]);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("Could not clear blacklists on " + loader);
                }
            }
        }
    }

    static {
        primitiveNames.put("int", Integer.TYPE);
        primitiveNames.put("short", Short.TYPE);
        primitiveNames.put("boolean", Boolean.TYPE);
        primitiveNames.put("byte", Byte.TYPE);
        primitiveNames.put("long", Long.TYPE);
        primitiveNames.put("double", Double.TYPE);
        primitiveNames.put("float", Float.TYPE);
        primitiveNames.put("char", Character.TYPE);
        primitiveNameDescriptors.put("int", "I");
        primitiveNameDescriptors.put("short", "S");
        primitiveNameDescriptors.put("boolean", "Z");
        primitiveNameDescriptors.put("byte", "B");
        primitiveNameDescriptors.put("long", "J");
        primitiveNameDescriptors.put("double", "D");
        primitiveNameDescriptors.put("float", "F");
        primitiveNameDescriptors.put("char", "C");
        reservedKeywords.add("abstract");
        reservedKeywords.add("continue");
        reservedKeywords.add("for");
        reservedKeywords.add("new");
        reservedKeywords.add("switch");
        reservedKeywords.add("assert");
        reservedKeywords.add("default");
        reservedKeywords.add("if");
        reservedKeywords.add("package");
        reservedKeywords.add("synchronized");
        reservedKeywords.add("boolean");
        reservedKeywords.add("do");
        reservedKeywords.add("goto");
        reservedKeywords.add("private");
        reservedKeywords.add("this");
        reservedKeywords.add("break");
        reservedKeywords.add("double");
        reservedKeywords.add("implements");
        reservedKeywords.add("protected");
        reservedKeywords.add("throw");
        reservedKeywords.add("byte");
        reservedKeywords.add("else");
        reservedKeywords.add("import");
        reservedKeywords.add("public");
        reservedKeywords.add("throws");
        reservedKeywords.add("case");
        reservedKeywords.add("enum");
        reservedKeywords.add("instanceof");
        reservedKeywords.add("return");
        reservedKeywords.add("transient");
        reservedKeywords.add("catch");
        reservedKeywords.add("extends");
        reservedKeywords.add("int");
        reservedKeywords.add("short");
        reservedKeywords.add("try");
        reservedKeywords.add("char");
        reservedKeywords.add("final");
        reservedKeywords.add("interface");
        reservedKeywords.add("static");
        reservedKeywords.add("void");
        reservedKeywords.add("class");
        reservedKeywords.add("finally");
        reservedKeywords.add("long");
        reservedKeywords.add("strictfp");
        reservedKeywords.add("volatile");
        reservedKeywords.add("const");
        reservedKeywords.add("float");
        reservedKeywords.add("native");
        reservedKeywords.add("super");
        reservedKeywords.add("while");
    }
}

