/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing.jaxrpc;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingException;
import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
import org.jboss.logging.Logger;
import org.jboss.ws.extensions.addressing.soap.SOAPAddressingPropertiesImpl;

public class WSAddressingClientHandler
extends GenericHandler {
    private static Logger log = Logger.getLogger(WSAddressingClientHandler.class);
    private AddressingBuilder addrBuilder = AddressingBuilder.getAddressingBuilder();
    private boolean normalize;

    public QName[] getHeaders() {
        return new QName[0];
    }

    public void init(HandlerInfo handlerInfo) {
        super.init(handlerInfo);
        this.normalize = "true".equals(handlerInfo.getHandlerConfig().get("normalize"));
    }

    public boolean handleRequest(MessageContext msgContext) {
        SOAPAddressingProperties addrProps;
        if (log.isDebugEnabled()) {
            log.debug("handleRequest");
        }
        if ((addrProps = (SOAPAddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.outbound")) != null) {
            if (this.normalize) {
                this.normalizeRequest(msgContext, addrProps);
            }
            SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
            addrProps.writeHeaders(soapMessage);
        } else {
            addrProps = (SOAPAddressingPropertiesImpl)this.addrBuilder.newAddressingProperties();
            msgContext.setProperty("javax.xml.ws.addressing.context.outbound", addrProps);
            if (this.normalize) {
                this.normalizeRequest(msgContext, addrProps);
            }
        }
        return true;
    }

    private void normalizeRequest(MessageContext msgContext, SOAPAddressingProperties addrProps) {
    }

    public boolean handleResponse(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug("handleResponse");
        }
        try {
            SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
            if (soapMessage.getSOAPPart().getEnvelope() != null) {
                SOAPAddressingBuilder builder = (SOAPAddressingBuilder)SOAPAddressingBuilder.getAddressingBuilder();
                SOAPAddressingProperties addrProps = (SOAPAddressingProperties)builder.newAddressingProperties();
                addrProps.readHeaders(soapMessage);
                msgContext.setProperty("javax.xml.ws.addressing.context.inbound", addrProps);
            }
        }
        catch (SOAPException ex) {
            throw new AddressingException("Cannot handle response", ex);
        }
        return true;
    }
}

