/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.eventing.deployment;

import org.jboss.ws.WSException;
import org.jboss.ws.core.server.ServiceEndpoint;
import org.jboss.ws.core.server.ServiceEndpointInfo;
import org.jboss.ws.extensions.eventing.deployment.EventingEndpointDI;
import org.jboss.ws.extensions.eventing.metadata.EventingEpMetaExt;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerFactory;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerMBean;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;

public class EventingEndpoint
extends ServiceEndpoint {
    private SubscriptionManagerFactory factory = SubscriptionManagerFactory.getInstance();

    public EventingEndpoint(ServiceEndpointInfo seInfo) {
        super(seInfo);
    }

    public void create() throws Exception {
        super.create();
        ServerEndpointMetaData epMetaData = this.seInfo.getServerEndpointMetaData();
        EventingEpMetaExt ext = (EventingEpMetaExt)epMetaData.getExtension("http://schemas.xmlsoap.org/ws/2004/08/eventing");
        if (null == ext) {
            throw new WSException("Cannot obtain eventing meta data");
        }
        EventingEndpointDI desc = new EventingEndpointDI(ext.getEventSourceNS(), ext.getNotificationSchema(), ext.getNotificationRootElementNS());
        desc.setEndpointAddress(epMetaData.getEndpointAddress());
        desc.setPortName(epMetaData.getPortName());
        SubscriptionManagerMBean manager = this.factory.getSubscriptionManager();
        manager.registerEventSource(desc);
    }

    public void destroy() {
        ServerEndpointMetaData epMetaData = this.seInfo.getServerEndpointMetaData();
        EventingEpMetaExt ext = (EventingEpMetaExt)epMetaData.getExtension("http://schemas.xmlsoap.org/ws/2004/08/eventing");
        if (null == ext) {
            throw new WSException("Cannot obtain eventing meta data");
        }
        SubscriptionManagerMBean manager = this.factory.getSubscriptionManager();
        manager.removeEventSource(ext.getEventSourceURI());
        super.destroy();
    }
}

