/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxws;

import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.bind.api.TypeReference;
import java.io.File;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jws.HandlerChain;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPMessageHandlers;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.ws.BindingType;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebFault;
import javax.xml.ws.addressing.Action;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.Style;
import org.jboss.ws.core.jaxrpc.Use;
import org.jboss.ws.core.jaxws.DynamicWrapperGenerator;
import org.jboss.ws.core.jaxws.WrapperGenerator;
import org.jboss.ws.core.utils.HolderUtils;
import org.jboss.ws.core.utils.JBossWSEntityResolver;
import org.jboss.ws.core.utils.JavaUtils;
import org.jboss.ws.extensions.addressing.AddressingPropertiesImpl;
import org.jboss.ws.extensions.addressing.metadata.AddressingOpMetaExt;
import org.jboss.ws.metadata.acessor.JAXBAccessor;
import org.jboss.ws.metadata.builder.MetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.JAXWSWebServiceMetaDataBuilder;
import org.jboss.ws.metadata.j2ee.serviceref.HandlerChainsObjectFactory;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.TypeMappingMetaData;
import org.jboss.ws.metadata.umdm.TypesMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingMessageReference;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLMIMEPart;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSMetaDataBuilder
extends MetaDataBuilder {
    protected static final Logger log = Logger.getLogger(JAXWSWebServiceMetaDataBuilder.class);
    protected List<Class> javaTypes = new ArrayList<Class>();
    protected JAXBRIContext jaxbCtx;
    protected List<TypeReference> typeRefs = new ArrayList<TypeReference>();
    protected WrapperGenerator wrapperGenerator;

    protected void processBindingType(EndpointMetaData epMetaData, Class<?> wsClass) {
        if (wsClass.isAnnotationPresent(BindingType.class)) {
            log.debug("processBindingType on: " + wsClass.getName());
            BindingType anBindingType = wsClass.getAnnotation(BindingType.class);
            epMetaData.setBindingId(anBindingType.value());
        }
    }

    protected void processSOAPBinding(EndpointMetaData epMetaData, Class<?> wsClass) {
        if (wsClass.isAnnotationPresent(SOAPBinding.class)) {
            log.debug("processSOAPBinding on: " + wsClass.getName());
            SOAPBinding anSoapBinding = wsClass.getAnnotation(SOAPBinding.class);
            SOAPBinding.Style attrStyle = anSoapBinding.style();
            Style style = attrStyle == SOAPBinding.Style.RPC ? Style.RPC : Style.DOCUMENT;
            epMetaData.setStyle(style);
            SOAPBinding.Use attrUse = anSoapBinding.use();
            if (attrUse == SOAPBinding.Use.ENCODED) {
                throw new WSException("SOAP encoding is not supported for JSR-181 deployments");
            }
            epMetaData.setEncodingStyle(Use.LITERAL);
            SOAPBinding.ParameterStyle paramStyle = anSoapBinding.parameterStyle();
            epMetaData.setParameterStyle(paramStyle);
        }
    }

    protected void processHandlerChain(EndpointMetaData epMetaData, Class<?> wsClass) {
        if (wsClass.isAnnotationPresent(SOAPMessageHandlers.class)) {
            throw new WSException("Cannot combine @HandlerChain with @SOAPMessageHandlers");
        }
        if (wsClass.isAnnotationPresent(HandlerChain.class)) {
            HandlerChain anHandlerChain = wsClass.getAnnotation(HandlerChain.class);
            String filename = anHandlerChain.file();
            UnifiedHandlerChainsMetaData handlerChainsMetaData = JAXWSMetaDataBuilder.getHandlerChainsMetaData(wsClass, filename);
            for (UnifiedHandlerChainMetaData UnifiedHandlerChainMetaData2 : handlerChainsMetaData.getHandlerChains()) {
                for (UnifiedHandlerMetaData uhmd : UnifiedHandlerChainMetaData2.getHandlers()) {
                    epMetaData.addHandler(uhmd.getHandlerMetaDataJAXWS(HandlerMetaData.HandlerType.ENDPOINT));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UnifiedHandlerChainsMetaData getHandlerChainsMetaData(Class<?> wsClass, String filename) {
        URL fileURL = null;
        log.debug("processHandlerChain [" + filename + "] on: " + wsClass.getName());
        try {
            fileURL = new URL(filename);
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        if (fileURL == null) {
            try {
                File file = new File(filename);
                if (file.exists()) {
                    fileURL = file.toURL();
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (fileURL == null) {
            fileURL = wsClass.getClassLoader().getResource(filename);
        }
        if (fileURL == null) {
            String filepath = filename;
            String packagePath = wsClass.getPackage().getName().replace('.', '/');
            String resourcePath = packagePath + "/" + filepath;
            while (filepath.startsWith("../")) {
                packagePath = packagePath.substring(0, packagePath.lastIndexOf("/"));
                filepath = filepath.substring(3);
                resourcePath = packagePath + "/" + filepath;
            }
            fileURL = wsClass.getClassLoader().getResource(resourcePath);
        }
        if (fileURL == null) {
            throw new WSException("Cannot resolve handler file '" + filename + "' on " + wsClass.getName());
        }
        UnifiedHandlerChainsMetaData handlerChainsMetaData = null;
        try {
            InputStream is = fileURL.openStream();
            try {
                Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                unmarshaller.setValidation(true);
                unmarshaller.setSchemaValidation(true);
                unmarshaller.setEntityResolver(new JBossWSEntityResolver());
                HandlerChainsObjectFactory factory = new HandlerChainsObjectFactory();
                handlerChainsMetaData = (UnifiedHandlerChainsMetaData)unmarshaller.unmarshal(is, (ObjectModelFactory)factory, null);
            }
            finally {
                is.close();
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot process handler chain: " + filename, ex);
        }
        return handlerChainsMetaData;
    }

    private void addFault(OperationMetaData omd, Class<?> exception) {
        String namespace;
        String name;
        if (omd.isOneWay()) {
            throw new IllegalStateException("JSR-181 4.3.1 - A JSR-181 processor is REQUIRED to report an error if an operation marked @Oneway has a return value, declares any checked exceptions or has any INOUT or OUT parameters.");
        }
        WebFault annotation = exception.getAnnotation(WebFault.class);
        String faultBeanName = null;
        QName xmlType = new QName(omd.getQName().getNamespaceURI(), exception.getSimpleName());
        boolean generate = true;
        if (annotation != null) {
            Class<?> faultBean;
            name = annotation.name();
            namespace = annotation.targetNamespace();
            if (namespace.length() == 0) {
                namespace = omd.getQName().getNamespaceURI();
            }
            if ((faultBean = this.getFaultInfo(exception)) != null) {
                generate = false;
                faultBeanName = faultBean.getName();
            }
        } else {
            name = xmlType.getLocalPart();
            namespace = xmlType.getNamespaceURI();
        }
        if (faultBeanName == null) {
            faultBeanName = JavaUtils.getPackageName(omd.getEndpointMetaData().getServiceEndpointInterface()) + ".jaxws." + exception.getSimpleName() + "Bean";
        }
        QName xmlName = new QName(namespace, name);
        FaultMetaData fmd = new FaultMetaData(omd, xmlName, xmlType, exception.getName());
        fmd.setFaultBeanName(faultBeanName);
        if (fmd.loadFaultBean() == null) {
            this.wrapperGenerator.generate(fmd);
        }
        this.javaTypes.add(fmd.getFaultBean());
        this.typeRefs.add(new TypeReference(fmd.getXmlName(), (Type)fmd.getFaultBean(), new Annotation[0]));
        omd.addFault(fmd);
    }

    private String convertToVariable(String localName) {
        return JAXBRIContext.mangleNameToVariableName((String)localName.intern());
    }

    private String[] convertTypeArguments(Class rawType, Type type) {
        if (!Collection.class.isAssignableFrom(rawType) && !Map.class.isAssignableFrom(rawType)) {
            return null;
        }
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType paramType = (ParameterizedType)type;
        Type[] arguments = paramType.getActualTypeArguments();
        String[] ret = new String[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            ret[i] = JavaUtils.erasure(arguments[i]).getName();
        }
        return ret;
    }

    private ParameterMetaData createRequestWrapper(OperationMetaData operation, Method method) {
        QName xmlName;
        String requestWrapperType = null;
        QName xmlType = xmlName = operation.getQName();
        if (method.isAnnotationPresent(RequestWrapper.class)) {
            RequestWrapper anReqWrapper = method.getAnnotation(RequestWrapper.class);
            String localName = anReqWrapper.localName().length() > 0 ? anReqWrapper.localName() : xmlName.getLocalPart();
            String targetNamespace = anReqWrapper.targetNamespace().length() > 0 ? anReqWrapper.targetNamespace() : xmlName.getNamespaceURI();
            xmlName = new QName(targetNamespace, localName);
            if (anReqWrapper.className().length() > 0) {
                requestWrapperType = anReqWrapper.className();
            }
        }
        if (requestWrapperType == null) {
            String packageName = JavaUtils.getPackageName(method.getDeclaringClass()) + ".jaxws";
            requestWrapperType = packageName + "." + JavaUtils.capitalize(method.getName());
        }
        ParameterMetaData wrapperParameter = new ParameterMetaData(operation, xmlName, xmlType, requestWrapperType);
        wrapperParameter.setAccessorFactoryCreator(JAXBAccessor.FACTORY_CREATOR);
        operation.addParameter(wrapperParameter);
        return wrapperParameter;
    }

    private ParameterMetaData createResponseWrapper(OperationMetaData operation, Method method) {
        QName xmlName;
        QName operationQName = operation.getQName();
        QName xmlType = xmlName = new QName(operationQName.getNamespaceURI(), operationQName.getLocalPart() + "Response");
        String responseWrapperType = null;
        if (method.isAnnotationPresent(ResponseWrapper.class)) {
            ResponseWrapper anResWrapper = method.getAnnotation(ResponseWrapper.class);
            String localName = anResWrapper.localName().length() > 0 ? anResWrapper.localName() : xmlName.getLocalPart();
            String targetNamespace = anResWrapper.targetNamespace().length() > 0 ? anResWrapper.targetNamespace() : xmlName.getNamespaceURI();
            xmlName = new QName(targetNamespace, localName);
            if (anResWrapper.className().length() > 0) {
                responseWrapperType = anResWrapper.className();
            }
        }
        if (responseWrapperType == null) {
            String packageName = JavaUtils.getPackageName(method.getDeclaringClass()) + ".jaxws";
            responseWrapperType = packageName + "." + JavaUtils.capitalize(method.getName()) + "Response";
        }
        ParameterMetaData retMetaData = new ParameterMetaData(operation, xmlName, xmlType, responseWrapperType);
        retMetaData.setAccessorFactoryCreator(JAXBAccessor.FACTORY_CREATOR);
        operation.setReturnParameter(retMetaData);
        return retMetaData;
    }

    private Class<?> getFaultInfo(Class<?> exception) {
        try {
            Method method = exception.getMethod("getFaultInfo", new Class[0]);
            Class<?> returnType = method.getReturnType();
            if (returnType == Void.TYPE) {
                return null;
            }
            return returnType;
        }
        catch (SecurityException e) {
            throw new WSException("Unexpected security exception: " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private ParameterMode getParameterMode(WebParam anWebParam, Class javaType) {
        if (anWebParam != null) {
            if (anWebParam.mode() == WebParam.Mode.INOUT) {
                return ParameterMode.INOUT;
            }
            if (anWebParam.mode() == WebParam.Mode.OUT) {
                return ParameterMode.OUT;
            }
        }
        return HolderUtils.isHolderType(javaType) ? ParameterMode.INOUT : ParameterMode.IN;
    }

    private WebParam getWebParamAnnotation(Method method, int pos) {
        for (Annotation annotation : method.getParameterAnnotations()[pos]) {
            if (!(annotation instanceof WebParam)) continue;
            return (WebParam)annotation;
        }
        return null;
    }

    private QName getWebParamName(OperationMetaData opMetaData, int index, WebParam webParam) {
        String namespace = null;
        String name = null;
        boolean header = false;
        if (webParam != null) {
            if (webParam.targetNamespace().length() > 0) {
                namespace = webParam.targetNamespace();
            }
            if (webParam.partName().length() > 0 && opMetaData.isRPCLiteral()) {
                name = webParam.partName();
            } else if (webParam.name().length() > 0) {
                name = webParam.name();
            }
            header = webParam.header();
        }
        if (namespace == null && (opMetaData.isDocumentBare() || header)) {
            namespace = opMetaData.getQName().getNamespaceURI();
        } else if (opMetaData.isRPCLiteral() && !header) {
            namespace = null;
        }
        if (name == null) {
            name = opMetaData.isDocumentBare() && !header ? opMetaData.getQName().getLocalPart() : "arg" + index;
        }
        return namespace != null ? new QName(namespace, name) : new QName(name);
    }

    private QName getWebResultName(OperationMetaData opMetaData, WebResult anWebResult) {
        String name = null;
        String namespace = null;
        boolean header = false;
        if (anWebResult != null) {
            if (anWebResult.targetNamespace().length() > 0) {
                namespace = anWebResult.targetNamespace();
            }
            if (anWebResult.partName().length() > 0 && opMetaData.isRPCLiteral()) {
                name = anWebResult.partName();
            } else if (anWebResult.name().length() > 0) {
                name = anWebResult.name();
            }
            header = anWebResult.header();
        }
        if (namespace == null && (opMetaData.isDocumentBare() || header)) {
            namespace = opMetaData.getQName().getNamespaceURI();
        } else if (opMetaData.isRPCLiteral() && !header) {
            namespace = null;
        }
        if (name == null) {
            name = opMetaData.isDocumentBare() && !header ? opMetaData.getResponseName().getLocalPart() : "return";
        }
        return namespace != null ? new QName(namespace, name) : new QName(name);
    }

    private void processMetaExtensions(Method method, EndpointMetaData epMetaData, OperationMetaData opMetaData) {
        AddressingPropertiesImpl ADDR = new AddressingPropertiesImpl();
        AddressingOpMetaExt addrExt = new AddressingOpMetaExt(ADDR.getNamespaceURI());
        Action anAction = method.getAnnotation(Action.class);
        if (anAction != null) {
            addrExt.setInboundAction(anAction.input());
            addrExt.setOutboundAction(anAction.output());
        } else {
            String tns = epMetaData.getPortName().getNamespaceURI();
            String portTypeName = epMetaData.getPortName().getLocalPart();
            addrExt.setInboundAction(tns + "/" + portTypeName + "/IN");
            if (!opMetaData.isOneWay()) {
                addrExt.setOutboundAction(tns + "/" + portTypeName + "/OUT");
            }
        }
        opMetaData.addExtension(addrExt);
    }

    private void processWebMethod(EndpointMetaData epMetaData, Method method) {
        String javaName = method.getName();
        if (method.getName().endsWith("Async")) {
            return;
        }
        String soapAction = "";
        String operationName = method.getName();
        if (method.isAnnotationPresent(WebMethod.class)) {
            WebMethod anWebMethod = method.getAnnotation(WebMethod.class);
            soapAction = anWebMethod.action();
            if (anWebMethod.operationName().length() > 0) {
                operationName = anWebMethod.operationName();
            }
        }
        String targetNS = epMetaData.getPortTypeName().getNamespaceURI();
        OperationMetaData opMetaData = new OperationMetaData(epMetaData, new QName(targetNS, operationName), javaName);
        opMetaData.setOneWay(method.isAnnotationPresent(Oneway.class));
        opMetaData.setSOAPAction(soapAction);
        if (method.isAnnotationPresent(SOAPBinding.class)) {
            SOAPBinding anBinding = method.getAnnotation(SOAPBinding.class);
            if (anBinding.style() != SOAPBinding.Style.DOCUMENT || epMetaData.getStyle() != Style.DOCUMENT) {
                throw new IllegalArgumentException("@SOAPBinding must be specified using DOCUMENT style when placed on a method");
            }
            opMetaData.setParameterStyle(anBinding.parameterStyle());
        }
        epMetaData.addOperation(opMetaData);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericTypes = method.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ParameterMetaData wrapperParameter = null;
        ParameterMetaData wrapperOutputParameter = null;
        ArrayList<WrappedParameter> wrappedParameters = null;
        ArrayList<WrappedParameter> wrappedOutputParameters = null;
        if (method.isAnnotationPresent(RequestWrapper.class) || method.isAnnotationPresent(ResponseWrapper.class)) {
            epMetaData.setParameterStyle(SOAPBinding.ParameterStyle.WRAPPED);
        }
        if (opMetaData.isDocumentWrapped()) {
            wrapperParameter = this.createRequestWrapper(opMetaData, method);
            wrappedParameters = new ArrayList<WrappedParameter>(parameterTypes.length);
            wrapperParameter.setWrappedParameters(wrappedParameters);
            if (!opMetaData.isOneWay()) {
                wrapperOutputParameter = this.createResponseWrapper(opMetaData, method);
                wrappedOutputParameters = new ArrayList<WrappedParameter>(parameterTypes.length + 1);
                wrapperOutputParameter.setWrappedParameters(wrappedOutputParameters);
            }
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class javaType = parameterTypes[i];
            Type genericType = genericTypes[i];
            String javaTypeName = javaType.getName();
            WebParam anWebParam = this.getWebParamAnnotation(method, i);
            boolean isHeader = anWebParam != null && anWebParam.header();
            boolean isWrapped = opMetaData.isDocumentWrapped() && !isHeader;
            ParameterMode mode = this.getParameterMode(anWebParam, javaType);
            if (opMetaData.isOneWay() && mode != ParameterMode.IN) {
                throw new IllegalArgumentException("A one-way operation can not have output parameters [method = " + method.getName() + ", parameter = " + i + "]");
            }
            if (HolderUtils.isHolderType(javaType)) {
                genericType = HolderUtils.getGenericValueType(genericType);
                javaType = JavaUtils.erasure(genericType);
                javaTypeName = javaType.getName();
            }
            if (isWrapped) {
                QName wrappedElementName = this.getWebParamName(opMetaData, i, anWebParam);
                String variable = this.convertToVariable(wrappedElementName.getLocalPart());
                WrappedParameter wrappedParameter = new WrappedParameter(wrappedElementName, javaTypeName, variable, i);
                wrappedParameter.setTypeArguments(this.convertTypeArguments(javaType, genericType));
                if (mode != ParameterMode.OUT) {
                    wrappedParameters.add(wrappedParameter);
                }
                if (mode == ParameterMode.IN) continue;
                wrappedParameter.setHolder(true);
                if (mode == ParameterMode.INOUT) {
                    wrappedParameter = new WrappedParameter(wrappedParameter);
                }
                wrappedOutputParameters.add(wrappedParameter);
                continue;
            }
            QName xmlName = this.getWebParamName(opMetaData, i, anWebParam);
            ParameterMetaData paramMetaData = new ParameterMetaData(opMetaData, xmlName, javaTypeName);
            paramMetaData.setInHeader(isHeader);
            paramMetaData.setIndex(i);
            paramMetaData.setMode(mode);
            if (anWebParam != null && !opMetaData.isDocumentWrapped() && anWebParam.partName().length() > 0) {
                paramMetaData.setPartName(anWebParam.partName());
            }
            opMetaData.addParameter(paramMetaData);
            this.javaTypes.add(javaType);
            this.typeRefs.add(new TypeReference(xmlName, genericType, parameterAnnotations[i]));
            this.processMIMEBinding(epMetaData, opMetaData, paramMetaData);
        }
        Class<?> returnType = method.getReturnType();
        Type genericReturnType = method.getGenericReturnType();
        String returnTypeName = returnType.getName();
        if (returnType != Void.TYPE) {
            if (opMetaData.isOneWay()) {
                throw new IllegalArgumentException("[JSR-181 2.5.1] The method '" + method.getName() + "' can not have a return value if it is marked OneWay");
            }
            WebResult anWebResult = method.getAnnotation(WebResult.class);
            boolean isHeader = anWebResult != null && anWebResult.header();
            boolean isWrappedBody = opMetaData.isDocumentWrapped() && !isHeader;
            QName xmlName = this.getWebResultName(opMetaData, anWebResult);
            if (isWrappedBody) {
                WrappedParameter wrapped = new WrappedParameter(xmlName, returnTypeName, this.convertToVariable(xmlName.getLocalPart()), -1);
                wrapped.setTypeArguments(this.convertTypeArguments(returnType, genericReturnType));
                wrappedOutputParameters.add(0, wrapped);
            } else {
                ParameterMetaData retMetaData = new ParameterMetaData(opMetaData, xmlName, returnTypeName);
                retMetaData.setInHeader(isHeader);
                retMetaData.setIndex(-1);
                retMetaData.setMode(ParameterMode.OUT);
                if (opMetaData.isDocumentWrapped()) {
                    opMetaData.addParameter(retMetaData);
                } else {
                    if (anWebResult != null && anWebResult.partName().length() > 0) {
                        retMetaData.setPartName(anWebResult.partName());
                    }
                    opMetaData.setReturnParameter(retMetaData);
                }
                this.javaTypes.add(returnType);
                this.typeRefs.add(new TypeReference(xmlName, genericReturnType, method.getAnnotations()));
                this.processMIMEBinding(epMetaData, opMetaData, retMetaData);
            }
        }
        if (opMetaData.isDocumentWrapped()) {
            if (wrapperParameter.loadWrapperBean() == null) {
                this.wrapperGenerator.generate(wrapperParameter);
            }
            Class wrapperClass = wrapperParameter.getJavaType();
            this.javaTypes.add(wrapperClass);
            this.typeRefs.add(new TypeReference(wrapperParameter.getXmlName(), (Type)wrapperClass, new Annotation[0]));
            if (!opMetaData.isOneWay()) {
                if (wrapperOutputParameter.loadWrapperBean() == null) {
                    this.wrapperGenerator.generate(wrapperOutputParameter);
                }
                wrapperClass = wrapperOutputParameter.getJavaType();
                this.javaTypes.add(wrapperClass);
                this.typeRefs.add(new TypeReference(wrapperOutputParameter.getXmlName(), (Type)wrapperClass, new Annotation[0]));
            }
        }
        for (Class<?> exClass : method.getExceptionTypes()) {
            if (RemoteException.class.isAssignableFrom(exClass)) continue;
            this.addFault(opMetaData, exClass);
        }
        this.processMetaExtensions(method, epMetaData, opMetaData);
    }

    private void processMIMEBinding(EndpointMetaData epMetaData, OperationMetaData opMetaData, ParameterMetaData paramMetaData) {
        WSDLDefinitions wsdlDef = epMetaData.getServiceMetaData().getWsdlDefinitions();
        if (wsdlDef != null) {
            for (WSDLBinding binding : wsdlDef.getBindings()) {
                block1: for (WSDLBindingOperation bindingOp : binding.getOperations()) {
                    WSDLBindingMessageReference[] inOrOutPut;
                    WSDLBindingMessageReference[] wSDLBindingMessageReferenceArray = inOrOutPut = paramMetaData.getMode().equals(ParameterMode.IN) || paramMetaData.getMode().equals(ParameterMode.INOUT) ? (WSDLBindingMessageReference[])bindingOp.getInputs() : (WSDLBindingMessageReference[])bindingOp.getOutputs();
                    if (inOrOutPut.length <= 0 || !bindingOp.getRef().equals(opMetaData.getQName())) continue;
                    WSDLBindingMessageReference bindingInput = inOrOutPut[0];
                    for (WSDLMIMEPart mimePart : bindingInput.getMimeParts()) {
                        String partName = mimePart.getPartName();
                        if (!paramMetaData.getPartName().equals(partName)) continue;
                        log.debug("Identified 'mime:content' binding: " + partName + ", mimeTypes=" + mimePart.getMimeTypes());
                        paramMetaData.setSwA(true);
                        paramMetaData.setMimeTypes(mimePart.getMimeTypes());
                        continue block1;
                    }
                }
            }
        }
    }

    protected void processWebMethods(EndpointMetaData epMetaData, Class wsClass) {
        boolean exclude;
        WebMethod annotation;
        epMetaData.clearOperations();
        int webMethodCount = 0;
        for (Method method : wsClass.getMethods()) {
            annotation = method.getAnnotation(WebMethod.class);
            boolean bl = exclude = annotation != null && annotation.exclude();
            if (exclude || annotation == null && !wsClass.isInterface()) continue;
            this.processWebMethod(epMetaData, method);
            ++webMethodCount;
        }
        if (webMethodCount == 0 && !wsClass.isInterface()) {
            for (Method method : wsClass.getMethods()) {
                annotation = method.getAnnotation(WebMethod.class);
                boolean bl = exclude = annotation != null && annotation.exclude();
                if (exclude || method.getDeclaringClass() == Object.class) continue;
                this.processWebMethod(epMetaData, method);
                ++webMethodCount;
            }
        }
        if (webMethodCount == 0) {
            throw new WSException("No exposable methods found");
        }
    }

    protected void initWrapperGenerator(ClassLoader loader) {
        if (this.wrapperGenerator == null) {
            this.wrapperGenerator = new DynamicWrapperGenerator(loader);
        } else {
            this.wrapperGenerator.reset(loader);
        }
    }

    protected void resetMetaDataBuilder(ClassLoader loader) {
        this.initWrapperGenerator(loader);
        this.javaTypes.clear();
        this.typeRefs.clear();
        this.jaxbCtx = null;
    }

    protected void createJAXBContext(EndpointMetaData epMetaData) {
        try {
            String targetNS = epMetaData.getPortTypeName().getNamespaceURI().intern();
            if (log.isDebugEnabled()) {
                log.debug("JAXBContext [types=" + this.javaTypes + ",tns=" + targetNS + "]");
            }
            this.jaxbCtx = JAXBRIContext.newInstance((Class[])this.javaTypes.toArray(new Class[0]), this.typeRefs, (String)targetNS, (boolean)false);
        }
        catch (JAXBException ex) {
            throw new IllegalStateException("Cannot build JAXB context", ex);
        }
    }

    private void populateXmlType(FaultMetaData faultMetaData) {
        EndpointMetaData epMetaData = faultMetaData.getOperationMetaData().getEndpointMetaData();
        TypesMetaData types = epMetaData.getServiceMetaData().getTypesMetaData();
        QName xmlType = faultMetaData.getXmlType();
        String faultBeanName = faultMetaData.getFaultBeanName();
        types.addTypeMapping(new TypeMappingMetaData(types, xmlType, faultBeanName));
    }

    private void populateXmlType(ParameterMetaData paramMetaData) {
        EndpointMetaData epMetaData = paramMetaData.getOperationMetaData().getEndpointMetaData();
        TypesMetaData types = epMetaData.getServiceMetaData().getTypesMetaData();
        QName xmlName = paramMetaData.getXmlName();
        QName xmlType = paramMetaData.getXmlType();
        Class javaType = paramMetaData.getJavaType();
        String javaName = paramMetaData.getJavaTypeName();
        if (xmlType == null) {
            try {
                xmlType = this.jaxbCtx.getTypeName(new TypeReference(xmlName, (Type)javaType, new Annotation[0]));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Cannot obtain xml type for: [xmlName=" + xmlName + ",javaName=" + javaName + "]");
            }
            if (xmlType == null) {
                xmlType = new QName(xmlName.getNamespaceURI(), ">" + xmlName.getLocalPart());
            }
            paramMetaData.setXmlType(xmlType);
        }
        types.addTypeMapping(new TypeMappingMetaData(types, xmlType, javaName));
    }

    protected void populateXmlTypes(EndpointMetaData epMetaData) {
        for (OperationMetaData operation : epMetaData.getOperations()) {
            for (ParameterMetaData paramMetaData : operation.getParameters()) {
                this.populateXmlType(paramMetaData);
            }
            ParameterMetaData returnParameter = operation.getReturnParameter();
            if (returnParameter != null) {
                this.populateXmlType(returnParameter);
            }
            for (FaultMetaData faultMetaData : operation.getFaults()) {
                this.populateXmlType(faultMetaData);
            }
        }
    }

    public void setWrapperGenerator(WrapperGenerator wrapperGenerator) {
        this.wrapperGenerator = wrapperGenerator;
    }
}

