/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.umdm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.Style;
import org.jboss.ws.core.jaxrpc.Use;
import org.jboss.ws.core.utils.JavaUtils;
import org.jboss.ws.integration.ResourceLoaderAdapter;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ExtensibleMetaData;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationMetaData
extends ExtensibleMetaData {
    private final Logger log = Logger.getLogger(OperationMetaData.class);
    private EndpointMetaData epMetaData;
    private QName qname;
    private QName responseName;
    private String javaName;
    private Method javaMethod;
    private boolean oneWay;
    private String soapAction;
    private SOAPBinding.ParameterStyle parameterStyle;
    private List<ParameterMetaData> parameters = new ArrayList<ParameterMetaData>();
    private List<FaultMetaData> faults = new ArrayList<FaultMetaData>();
    private ParameterMetaData returnParam;

    public OperationMetaData(QName qname, String javaName) {
        UnifiedMetaData umd = new UnifiedMetaData(new ResourceLoaderAdapter());
        ServiceMetaData smd = new ServiceMetaData(umd, new QName("mock-service"));
        ServerEndpointMetaData epmd = new ServerEndpointMetaData(smd, new QName("mock-endpoint"), new QName("mock-interface"), EndpointMetaData.Type.JAXRPC);
        this.initOperationMetaData(epmd, qname, javaName);
    }

    public OperationMetaData(EndpointMetaData epMetaData, QName qname, String javaName) {
        this.log.trace("new OperationMetaData: [xmlName=" + qname + ",javaName=" + javaName + "]");
        this.initOperationMetaData(epMetaData, qname, javaName);
    }

    private void initOperationMetaData(EndpointMetaData epMetaData, QName qname, String javaName) {
        this.epMetaData = epMetaData;
        this.qname = qname;
        this.javaName = javaName;
        if (qname == null) {
            throw new IllegalArgumentException("Invalid null qname argument");
        }
        if (javaName == null) {
            throw new IllegalArgumentException("Invalid null javaName argument, for: " + qname);
        }
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        this.responseName = new QName(nsURI, localPart + "Response");
    }

    public EndpointMetaData getEndpointMetaData() {
        return this.epMetaData;
    }

    public QName getQName() {
        return this.qname;
    }

    public QName getResponseName() {
        return this.responseName;
    }

    public String getSOAPAction() {
        return this.soapAction;
    }

    public void setSOAPAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public Style getStyle() {
        return this.epMetaData.getStyle();
    }

    public Use getUse() {
        return this.epMetaData.getEncodingStyle();
    }

    public SOAPBinding.ParameterStyle getParameterStyle() {
        return this.parameterStyle != null ? this.parameterStyle : this.epMetaData.getParameterStyle();
    }

    public void setParameterStyle(SOAPBinding.ParameterStyle parameterStyle) {
        this.parameterStyle = parameterStyle;
    }

    public boolean isRPCLiteral() {
        return this.getStyle() == Style.RPC && this.getUse() == Use.LITERAL;
    }

    public boolean isRPCEncoded() {
        return this.getStyle() == Style.RPC && this.getUse() == Use.ENCODED;
    }

    public boolean isDocumentBare() {
        return this.getStyle() == Style.DOCUMENT && this.getParameterStyle() == SOAPBinding.ParameterStyle.BARE;
    }

    public boolean isDocumentWrapped() {
        return this.getStyle() == Style.DOCUMENT && this.getParameterStyle() == SOAPBinding.ParameterStyle.WRAPPED;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public Method getJavaMethod() {
        Method tmpMethod = this.javaMethod;
        Class seiClass = this.epMetaData.getServiceEndpointInterface();
        if (tmpMethod == null && seiClass != null) {
            for (Method method : seiClass.getMethods()) {
                if (!this.isJavaMethod(method)) continue;
                tmpMethod = method;
                UnifiedMetaData wsMetaData = this.epMetaData.getServiceMetaData().getUnifiedMetaData();
                if (!wsMetaData.isEagerInitialized()) break;
                if (!UnifiedMetaData.isFinalRelease()) {
                    this.log.warn("Loading java method after eager initialization", new IllegalStateException());
                }
                this.javaMethod = method;
                break;
            }
            if (tmpMethod == null) {
                throw new WSException("Cannot find java method: " + this.javaName);
            }
        }
        return tmpMethod;
    }

    public boolean isJavaMethod(Method method) {
        String methodName;
        boolean isJavaMethod = method.equals(this.javaMethod);
        if (!isJavaMethod && this.javaName.equals(methodName = method.getName())) {
            this.log.trace("Found java method: " + method);
            if (this.matchParameters(method, true)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Found best matching java method: " + method);
                }
                isJavaMethod = true;
            }
            if (!isJavaMethod && this.matchParameters(method, false)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Found possible matching java method: " + method);
                }
                isJavaMethod = true;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Synchronized java method:\n" + method + "\nwith: " + this.toString());
        }
        return isJavaMethod;
    }

    private boolean matchParameters(Method method, boolean exact) {
        Class<?>[] paramTypes = method.getParameterTypes();
        HashSet<Integer> matches = new HashSet<Integer>(paramTypes.length);
        for (ParameterMetaData param : this.getParameters()) {
            if (param.matchParameter(method, matches, exact)) continue;
            return false;
        }
        ParameterMetaData returnMetaData = this.getReturnParameter();
        if (returnMetaData != null && !returnMetaData.matchParameter(method, matches, exact)) {
            return false;
        }
        return matches.size() == paramTypes.length;
    }

    public boolean isMessageEndpoint() {
        ParameterMetaData inParam;
        boolean isMessageEndpoint = false;
        if (this.parameters.size() == 1 && JavaUtils.isAssignableFrom(Element.class, (inParam = this.parameters.get(0)).getJavaType())) {
            isMessageEndpoint = true;
        }
        return isMessageEndpoint;
    }

    public boolean isOneWay() {
        return this.oneWay;
    }

    public void setOneWay(boolean oneWay) {
        this.oneWay = oneWay;
        this.assertOneWayOperation();
    }

    public ParameterMetaData getParameter(QName xmlName) {
        ParameterMetaData paramMetaData = null;
        for (int i = 0; paramMetaData == null && i < this.parameters.size(); ++i) {
            ParameterMetaData aux = this.parameters.get(i);
            if (!xmlName.equals(aux.getXmlName())) continue;
            paramMetaData = aux;
        }
        return paramMetaData;
    }

    public List<ParameterMetaData> getInputParameters() {
        ArrayList<ParameterMetaData> retList = new ArrayList<ParameterMetaData>();
        for (ParameterMetaData paramMetaData : this.parameters) {
            ParameterMode mode = paramMetaData.getMode();
            if (mode != ParameterMode.IN && mode != ParameterMode.INOUT) continue;
            retList.add(paramMetaData);
        }
        return retList;
    }

    public List<ParameterMetaData> getOutputParameters() {
        ArrayList<ParameterMetaData> retList = new ArrayList<ParameterMetaData>();
        for (ParameterMetaData paramMetaData : this.parameters) {
            ParameterMode mode = paramMetaData.getMode();
            if (mode != ParameterMode.OUT && mode != ParameterMode.INOUT) continue;
            retList.add(paramMetaData);
        }
        return retList;
    }

    public List<ParameterMetaData> getNonHeaderParameters() {
        ArrayList<ParameterMetaData> retList = new ArrayList<ParameterMetaData>();
        for (ParameterMetaData paramMetaData : this.parameters) {
            if (paramMetaData.isInHeader()) continue;
            retList.add(paramMetaData);
        }
        return retList;
    }

    public List<ParameterMetaData> getParameters() {
        return new ArrayList<ParameterMetaData>(this.parameters);
    }

    public void addParameter(ParameterMetaData pmd) {
        this.log.trace("addParameter: [xmlName=" + pmd.getXmlName() + ",xmlType=" + pmd.getXmlType() + "]");
        this.parameters.add(pmd);
        this.assertOneWayOperation();
    }

    public void removeAllParameters() {
        this.parameters.clear();
    }

    public ParameterMetaData getReturnParameter() {
        return this.returnParam;
    }

    public void setReturnParameter(ParameterMetaData returnParam) {
        this.log.trace("setReturnParameter: " + returnParam);
        returnParam.setMode(ParameterMode.OUT);
        returnParam.setIndex(-1);
        this.returnParam = returnParam;
        this.assertOneWayOperation();
    }

    public List<FaultMetaData> getFaults() {
        return new ArrayList<FaultMetaData>(this.faults);
    }

    public FaultMetaData getFault(QName xmlName) {
        FaultMetaData faultMetaData = null;
        for (int i = 0; faultMetaData == null && i < this.faults.size(); ++i) {
            FaultMetaData aux = this.faults.get(i);
            if (!aux.getXmlName().equals(xmlName)) continue;
            faultMetaData = aux;
        }
        return faultMetaData;
    }

    public FaultMetaData getFault(Class javaType) {
        FaultMetaData faultMetaData = null;
        for (FaultMetaData aux : this.faults) {
            if (!aux.getJavaType().equals(javaType)) continue;
            faultMetaData = aux;
            break;
        }
        return faultMetaData;
    }

    public void addFault(FaultMetaData fault) {
        this.log.trace("addFault: " + fault);
        this.faults.add(fault);
        this.assertOneWayOperation();
    }

    private void assertOneWayOperation() {
        if (this.oneWay) {
            if (this.returnParam != null) {
                throw new WSException("OneWay operations cannot have a return parameter");
            }
            if (this.faults.size() > 0) {
                throw new WSException("OneWay operations cannot have checked exceptions");
            }
            for (ParameterMetaData paramMetaData : this.parameters) {
                if (paramMetaData.getMode() == ParameterMode.IN) continue;
                throw new WSException("OneWay operations cannot have INOUT or OUT parameters");
            }
        }
    }

    public void assertDocumentBare() {
        if (this.isDocumentBare()) {
            int in = 0;
            int out = 0;
            for (ParameterMetaData paramMetaData : this.parameters) {
                if (paramMetaData.isInHeader()) continue;
                ParameterMode mode = paramMetaData.getMode();
                if (mode != ParameterMode.OUT) {
                    ++in;
                }
                if (mode == ParameterMode.IN) continue;
                ++out;
            }
            if (this.returnParam != null && !this.returnParam.isInHeader()) {
                ++out;
            }
            if (in > 1 || out > (this.oneWay ? 0 : 1)) {
                throw new WSException("The body of a document/literal bare message requires at most 1 input and at most 1 output (or 0 if oneway). method: " + this.javaName + " in: " + in + " out: " + out);
            }
        }
    }

    public void validate() {
        for (ParameterMetaData parameter : this.parameters) {
            parameter.validate();
        }
        for (FaultMetaData fault : this.faults) {
            fault.validate();
        }
    }

    public void eagerInitialize(List<Method> unsynchronizedMethods) {
        this.javaMethod = null;
        for (ParameterMetaData parameter : this.parameters) {
            parameter.eagerInitialize();
        }
        if (this.returnParam != null) {
            this.returnParam.eagerInitialize();
        }
        for (FaultMetaData fault : this.faults) {
            fault.eagerInitialize();
        }
        for (Method method : unsynchronizedMethods) {
            if (!this.isJavaMethod(method)) continue;
            this.javaMethod = method;
            break;
        }
        if (this.javaMethod == null) {
            StringBuilder errMsg = new StringBuilder("Cannot synchronize to any of these methods:");
            for (Method method : unsynchronizedMethods) {
                errMsg.append("\n" + method);
            }
            errMsg.append("\n" + this.toString());
            throw new IllegalStateException(errMsg.toString());
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\nOperationMetaData:");
        buffer.append("\n qname=" + this.qname);
        buffer.append("\n javaName=" + this.javaName);
        buffer.append("\n style=" + this.getStyle() + "/" + this.getUse());
        if (this.getStyle() == Style.DOCUMENT) {
            buffer.append("/" + (Object)((Object)this.getParameterStyle()));
        }
        buffer.append("\n oneWay=" + this.oneWay);
        buffer.append("\n soapAction=" + this.soapAction);
        for (ParameterMetaData param : this.parameters) {
            buffer.append(param);
        }
        if (this.returnParam != null) {
            buffer.append(this.returnParam.toString());
        }
        for (FaultMetaData fault : this.faults) {
            buffer.append(fault);
        }
        return buffer.toString();
    }
}

