/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.jaxws.api;

import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Locator {
    Locator() {
    }

    static <T> T locate(Class<T> providerType, String providerProperty, String defaultProvider, ClassLoader loader) {
        String provider = null;
        try {
            PropertyAccessAction action = new PropertyAccessAction(providerProperty);
            provider = (String)AccessController.doPrivileged(action);
            if (provider == null) {
                provider = defaultProvider;
            }
            Class<?> clazz = loader.loadClass(provider);
            return (T)clazz.newInstance();
        }
        catch (Throwable t) {
            if (provider == null) {
                throw new IllegalStateException("Failure reading system property: " + providerProperty);
            }
            throw new IllegalStateException("Could not load provider:" + provider);
        }
    }

    private static class PropertyAccessAction
    implements PrivilegedAction {
        private String name;

        PropertyAccessAction(String name) {
            this.name = name;
        }

        public Object run() {
            return System.getProperty(this.name);
        }
    }
}

