/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.rmi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.iiop.rmi.AbstractAnalysis;
import org.jboss.iiop.rmi.AttributeAnalysis;
import org.jboss.iiop.rmi.ContainerAnalysis;
import org.jboss.iiop.rmi.OperationAnalysis;
import org.jboss.iiop.rmi.RMIIIOPViolationException;
import org.jboss.iiop.rmi.RmiIdlUtil;
import org.jboss.iiop.rmi.WorkCacheManager;
import org.jboss.logging.Logger;

public class InterfaceAnalysis
extends ContainerAnalysis {
    Map operationAnalysisMap;
    private static final Logger logger = Logger.getLogger((Class)(class$org$jboss$iiop$rmi$InterfaceAnalysis == null ? (class$org$jboss$iiop$rmi$InterfaceAnalysis = InterfaceAnalysis.class$("org.jboss.iiop.rmi.InterfaceAnalysis")) : class$org$jboss$iiop$rmi$InterfaceAnalysis));
    private static WorkCacheManager cache = new WorkCacheManager(class$org$jboss$iiop$rmi$InterfaceAnalysis == null ? (class$org$jboss$iiop$rmi$InterfaceAnalysis = InterfaceAnalysis.class$("org.jboss.iiop.rmi.InterfaceAnalysis")) : class$org$jboss$iiop$rmi$InterfaceAnalysis);
    private boolean abstractInterface;
    private String[] allTypeIds;
    static /* synthetic */ Class class$org$jboss$iiop$rmi$InterfaceAnalysis;

    public static InterfaceAnalysis getInterfaceAnalysis(Class cls) throws RMIIIOPViolationException {
        return (InterfaceAnalysis)cache.getAnalysis(cls);
    }

    protected InterfaceAnalysis(Class cls) {
        super(cls);
        logger.debug((Object)("new InterfaceAnalysis: " + cls.getName()));
    }

    protected void doAnalyze() throws RMIIIOPViolationException {
        super.doAnalyze();
        if (!this.cls.isInterface()) {
            throw new IllegalArgumentException("Class \"" + this.cls.getName() + "\" is not an interface.");
        }
        this.abstractInterface = RmiIdlUtil.isAbstractInterface(this.cls);
        this.calculateOperationAnalysisMap();
        this.calculateAllTypeIds();
        this.fixupCaseNames();
    }

    public boolean isAbstractInterface() {
        return this.abstractInterface;
    }

    public boolean isRmiIdlRemoteInterface() {
        return !this.abstractInterface;
    }

    public String[] getAllTypeIds() {
        return (String[])this.allTypeIds.clone();
    }

    protected ArrayList getContainedEntries() {
        ArrayList<AbstractAnalysis> ret = new ArrayList<AbstractAnalysis>(this.constants.length + this.attributes.length + this.operations.length);
        int i = 0;
        while (i < this.constants.length) {
            ret.add(this.constants[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.attributes.length) {
            ret.add(this.attributes[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.operations.length) {
            ret.add(this.operations[i3]);
            ++i3;
        }
        return ret;
    }

    protected void analyzeOperations() throws RMIIIOPViolationException {
        int operationCount = 0;
        int i = 0;
        while (i < this.methods.length) {
            if ((this.m_flags[i] & 0xE) == 0) {
                ++operationCount;
            }
            ++i;
        }
        this.operations = new OperationAnalysis[operationCount];
        operationCount = 0;
        int i2 = 0;
        while (i2 < this.methods.length) {
            if ((this.m_flags[i2] & 0xE) == 0) {
                this.operations[operationCount] = new OperationAnalysis(this.methods[i2]);
                ++operationCount;
            }
            ++i2;
        }
    }

    protected void calculateOperationAnalysisMap() {
        OperationAnalysis oa;
        this.operationAnalysisMap = new HashMap();
        int i = 0;
        while (i < this.operations.length) {
            oa = this.operations[i];
            this.operationAnalysisMap.put(oa.getIDLName(), oa);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.attributes.length) {
            AttributeAnalysis attr = this.attributes[i2];
            oa = attr.getAccessorAnalysis();
            if (oa != null) {
                this.operationAnalysisMap.put(oa.getIDLName(), oa);
                oa = attr.getMutatorAnalysis();
                if (oa != null) {
                    this.operationAnalysisMap.put(oa.getIDLName(), oa);
                }
            }
            ++i2;
        }
    }

    protected void calculateAllTypeIds() {
        if (!this.isRmiIdlRemoteInterface()) {
            this.allTypeIds = new String[0];
        } else {
            ArrayList<String> a = new ArrayList<String>();
            InterfaceAnalysis[] intfs = this.getInterfaces();
            int i = 0;
            while (i < intfs.length) {
                String[] ss = intfs[i].getAllTypeIds();
                int j = 0;
                while (j < ss.length) {
                    if (!a.contains(ss[j])) {
                        a.add(ss[j]);
                    }
                    ++j;
                }
                ++i;
            }
            this.allTypeIds = new String[a.size() + 1];
            this.allTypeIds[0] = this.getRepositoryId();
            int i2 = 1;
            while (i2 <= a.size()) {
                this.allTypeIds[i2] = (String)a.get(a.size() - i2);
                ++i2;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

