/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.rmi;

import java.io.ObjectStreamField;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.jboss.iiop.rmi.AbstractAnalysis;
import org.jboss.iiop.rmi.AttributeAnalysis;
import org.jboss.iiop.rmi.ContainerAnalysis;
import org.jboss.iiop.rmi.RMIIIOPNotImplementedException;
import org.jboss.iiop.rmi.RMIIIOPViolationException;
import org.jboss.iiop.rmi.ValueMemberAnalysis;
import org.jboss.iiop.rmi.WorkCacheManager;
import org.jboss.logging.Logger;

public class ValueAnalysis
extends ContainerAnalysis {
    private static final Logger logger = Logger.getLogger((Class)(class$org$jboss$iiop$rmi$ValueAnalysis == null ? (class$org$jboss$iiop$rmi$ValueAnalysis = ValueAnalysis.class$("org.jboss.iiop.rmi.ValueAnalysis")) : class$org$jboss$iiop$rmi$ValueAnalysis));
    private static WorkCacheManager cache = new WorkCacheManager(class$org$jboss$iiop$rmi$ValueAnalysis == null ? (class$org$jboss$iiop$rmi$ValueAnalysis = ValueAnalysis.class$("org.jboss.iiop.rmi.ValueAnalysis")) : class$org$jboss$iiop$rmi$ValueAnalysis);
    ValueAnalysis superAnalysis;
    private boolean abstractValue = false;
    private boolean externalizable = false;
    private boolean hasWriteObjectMethod = false;
    private ObjectStreamField[] serialPersistentFields;
    private ValueMemberAnalysis[] members;
    static /* synthetic */ Class class$org$jboss$iiop$rmi$ValueAnalysis;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$java$io$ObjectStreamField;
    static /* synthetic */ Class array$Ljava$io$OutputStream;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$Serializable;

    public static ValueAnalysis getValueAnalysis(Class cls) throws RMIIIOPViolationException {
        return (ValueAnalysis)cache.getAnalysis(cls);
    }

    protected ValueAnalysis(Class cls) {
        super(cls);
        logger.debug((Object)("ValueAnalysis(\"" + cls.getName() + "\") entered."));
    }

    protected void doAnalyze() throws RMIIIOPViolationException {
        super.doAnalyze();
        if (this.cls == (class$java$lang$String == null ? (class$java$lang$String = ValueAnalysis.class$("java.lang.String")) : class$java$lang$String)) {
            throw new IllegalArgumentException("Cannot analyze java.lang.String here: It is a special case.");
        }
        if (this.cls == (class$java$lang$Class == null ? (class$java$lang$Class = ValueAnalysis.class$("java.lang.Class")) : class$java$lang$Class)) {
            throw new IllegalArgumentException("Cannot analyze java.lang.Class here: It is a special case.");
        }
        if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = ValueAnalysis.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(this.cls)) {
            throw new RMIIIOPViolationException("Value type " + this.cls.getName() + " cannot implement java.rmi.Remote.", "1.2.4");
        }
        if (this.cls.getName().indexOf(36) != -1) {
            throw new RMIIIOPNotImplementedException("Class " + this.cls.getName() + " has a '$', like " + "proxies or inner classes.");
        }
        this.externalizable = (class$java$io$Externalizable == null ? (class$java$io$Externalizable = ValueAnalysis.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(this.cls);
        if (!this.externalizable) {
            int mods;
            int mods2;
            Field spf = null;
            try {
                spf = this.cls.getField("serialPersistentFields");
            }
            catch (NoSuchFieldException ex) {
                // empty catch block
            }
            if (!(spf == null || Modifier.isFinal(mods2 = spf.getModifiers()) && Modifier.isStatic(mods2) && Modifier.isPrivate(mods2))) {
                spf = null;
            }
            if (spf != null) {
                Class<?> type = spf.getType();
                if (type.isArray()) {
                    if ((type = type.getComponentType()) != (class$java$io$ObjectStreamField == null ? (class$java$io$ObjectStreamField = ValueAnalysis.class$("java.io.ObjectStreamField")) : class$java$io$ObjectStreamField)) {
                        spf = null;
                    }
                } else {
                    spf = null;
                }
            }
            if (spf != null) {
                try {
                    this.serialPersistentFields = (ObjectStreamField[])spf.get(null);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("Unexpected IllegalException: " + ex.toString());
                }
                int i = 0;
                while (i < this.fields.length) {
                    if (this.fields[i] == spf) {
                        int n = i;
                        this.f_flags[n] = (byte)(this.f_flags[n] | 2);
                        break;
                    }
                    ++i;
                }
            }
            Method wo = null;
            try {
                wo = this.cls.getMethod("writeObject", array$Ljava$io$OutputStream == null ? (array$Ljava$io$OutputStream = ValueAnalysis.class$("[Ljava.io.OutputStream;")) : array$Ljava$io$OutputStream);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            if (wo != null && wo.getReturnType() != Void.TYPE) {
                wo = null;
            }
            if (wo != null && !Modifier.isPrivate(mods = spf.getModifiers())) {
                wo = null;
            }
            if (wo != null) {
                Class<?>[] paramTypes = wo.getParameterTypes();
                if (paramTypes.length != 1) {
                    wo = null;
                } else if (paramTypes[0] != (class$java$io$OutputStream == null ? (class$java$io$OutputStream = ValueAnalysis.class$("java.io.OutputStream")) : class$java$io$OutputStream)) {
                    wo = null;
                }
            }
            if (wo != null) {
                this.hasWriteObjectMethod = true;
                int i = 0;
                while (i < this.methods.length) {
                    if (this.methods[i] == wo) {
                        int n = i;
                        this.m_flags[n] = (byte)(this.m_flags[n] | 0x20);
                        break;
                    }
                    ++i;
                }
            }
        }
        TreeSet<ValueMemberAnalysis> m = new TreeSet<ValueMemberAnalysis>(new ValueMemberComparator());
        logger.debug((Object)("ValueAnalysis(\"" + this.cls.getName() + "\"): " + "fields.length=" + this.fields.length));
        int i = 0;
        while (i < this.fields.length) {
            logger.debug((Object)("ValueAnalysis(\"" + this.cls.getName() + "\"): " + "Considering field[" + i + "] \"" + this.fields[i].getName() + "\"" + " f_flags=" + this.f_flags[i]));
            if (this.f_flags[i] == 0) {
                int mods = this.fields[i].getModifiers();
                logger.debug((Object)("ValueAnalysis(\"" + this.cls.getName() + "\"): mods=" + mods));
                if (!Modifier.isStatic(mods) && !Modifier.isTransient(mods)) {
                    ValueMemberAnalysis vma = new ValueMemberAnalysis(this.fields[i].getName(), this.fields[i].getType(), Modifier.isPublic(mods));
                    m.add(vma);
                }
            }
            ++i;
        }
        this.members = new ValueMemberAnalysis[m.size()];
        this.members = m.toArray(this.members);
        logger.debug((Object)("ValueAnalysis(\"" + this.cls.getName() + "\") value member count: " + this.members.length));
        Class superClass = this.cls.getSuperclass();
        if (superClass == (class$java$lang$Object == null ? (class$java$lang$Object = ValueAnalysis.class$("java.lang.Object")) : class$java$lang$Object)) {
            superClass = null;
        }
        if (superClass == null) {
            this.superAnalysis = null;
        } else {
            logger.debug((Object)("ValueAnalysis(\"" + this.cls.getName() + "\"): superclass: " + superClass.getName()));
            this.superAnalysis = ValueAnalysis.getValueAnalysis(superClass);
        }
        if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = ValueAnalysis.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(this.cls)) {
            this.abstractValue = true;
        }
        this.fixupCaseNames();
        logger.debug((Object)("ValueAnalysis(\"" + this.cls.getName() + "\") done."));
    }

    public ValueAnalysis getSuperAnalysis() {
        return this.superAnalysis;
    }

    public boolean isAbstractValue() {
        return this.abstractValue;
    }

    public boolean isCustom() {
        return this.externalizable || this.hasWriteObjectMethod;
    }

    public boolean isExternalizable() {
        return this.externalizable;
    }

    public ValueMemberAnalysis[] getMembers() {
        return (ValueMemberAnalysis[])this.members.clone();
    }

    protected void analyzeAttributes() throws RMIIIOPViolationException {
        this.attributes = new AttributeAnalysis[0];
    }

    protected ArrayList getContainedEntries() {
        ArrayList<AbstractAnalysis> ret = new ArrayList<AbstractAnalysis>(this.constants.length + this.attributes.length + this.members.length);
        int i = 0;
        while (i < this.constants.length) {
            ret.add(this.constants[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.attributes.length) {
            ret.add(this.attributes[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.members.length) {
            ret.add(this.members[i3]);
            ++i3;
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ValueMemberComparator
    implements Comparator {
        private ValueMemberComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            ValueMemberAnalysis m1 = (ValueMemberAnalysis)o1;
            ValueMemberAnalysis m2 = (ValueMemberAnalysis)o2;
            boolean p1 = m1.getCls().isPrimitive();
            boolean p2 = m2.getCls().isPrimitive();
            if (p1 && !p2) {
                return -1;
            }
            if (!p1 && p2) {
                return 1;
            }
            return m1.getJavaName().compareTo(m2.getJavaName());
        }
    }
}

