/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.AuthPermission;
import javax.security.auth.PrivateCredentialPermission;

public final class Subject
implements Serializable {
    private static final long serialVersionUID = -8308522755600156056L;
    private static AuthPermission SET_READ_ONLY_PERM = new AuthPermission("setReadOnly");
    private static AuthPermission MOD_PRINCIPALS_PERM = new AuthPermission("modifyPrincipals");
    private static AuthPermission MOD_PUBLIC_CREDS_PERM = new AuthPermission("modifyPublicCredentials");
    private static AuthPermission MOD_PRIVATE_CREDS_PERM = new AuthPermission("modifyPrivateCredentials");
    private boolean readOnly;
    private Set principals;
    private Set publicCredentials;
    private Set privateCredentials;

    public static Subject getSubject(AccessControlContext acc) {
        throw new UnsupportedOperationException("getSubject is not supported by this version of JAAS 1.0, use the JDK 1.4 version");
    }

    public static Object doAs(Subject subject, PrivilegedAction action) {
        throw new UnsupportedOperationException("doAs is not supported by this version of JAAS 1.0, use the JDK 1.4 version");
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction action) throws PrivilegedActionException {
        throw new UnsupportedOperationException("doAs is not supported by this version of JAAS 1.0, use the JDK 1.4 version");
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction action, AccessControlContext acc) {
        throw new UnsupportedOperationException("doAsPrivileged is not supported by this version of JAAS 1.0, use the JDK 1.4 version");
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction action, AccessControlContext acc) throws PrivilegedActionException {
        throw new UnsupportedOperationException("doAsPrivileged is not supported by this version of JAAS 1.0, use the JDK 1.4 version");
    }

    public Subject() {
        this(false, null, null, null);
    }

    public Subject(boolean readOnly, Set principals, Set pubCredentials, Set privCredentials) {
        this.readOnly = readOnly;
        this.principals = new ProtectedSet(this, principals, (Permission)MOD_PRINCIPALS_PERM);
        this.publicCredentials = new ProtectedSet(this, pubCredentials, (Permission)MOD_PUBLIC_CREDS_PERM);
        this.privateCredentials = new ProtectedSet(this, privCredentials, (Permission)MOD_PRIVATE_CREDS_PERM);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Subject)) {
            return false;
        }
        Subject subj = (Subject)obj;
        boolean equals = this.getPrincipals().equals(subj.getPrincipals());
        if (equals) {
            equals = this.getPublicCredentials().equals(subj.getPublicCredentials());
        }
        if (equals) {
            equals = this.getPrivateCredentials().equals(subj.getPrivateCredentials());
        }
        return equals;
    }

    public int hashCode() {
        Object next;
        int hashCode = 0;
        Iterator iter = this.getPrincipals().iterator();
        while (iter.hasNext()) {
            next = iter.next();
            hashCode ^= next.hashCode();
        }
        iter = this.getPublicCredentials().iterator();
        while (iter.hasNext()) {
            next = iter.next();
            hashCode ^= next.hashCode();
        }
        iter = this.getPrivateCredentials().iterator();
        while (iter.hasNext()) {
            next = iter.next();
            hashCode ^= next.hashCode();
        }
        return hashCode;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_READ_ONLY_PERM);
        }
        this.readOnly = true;
    }

    public Set getPrincipals() {
        return this.principals;
    }

    public Set getPrincipals(Class c) {
        ProtectedSet copy = new ProtectedSet(this, this.principals, MOD_PRINCIPALS_PERM, c);
        return copy;
    }

    public Set getPublicCredentials() {
        return this.publicCredentials;
    }

    public Set getPublicCredentials(Class c) {
        ProtectedSet copy = new ProtectedSet(this, this.publicCredentials, MOD_PUBLIC_CREDS_PERM, c);
        return copy;
    }

    public Set getPrivateCredentials() {
        return this.privateCredentials;
    }

    public Set getPrivateCredentials(Class c) {
        ProtectedSet copy = new ProtectedSet(this, this.privateCredentials, MOD_PRIVATE_CREDS_PERM, c);
        return copy;
    }

    public String toString() {
        Object next;
        StringBuffer tmp = new StringBuffer("Subject(");
        tmp.append("Principals{");
        Iterator iter = this.principals.iterator();
        while (iter.hasNext()) {
            next = iter.next();
            tmp.append(next);
            if (!iter.hasNext()) continue;
            tmp.append(',');
        }
        tmp.append('}');
        tmp.append("PublicCredentials{");
        iter = this.publicCredentials.iterator();
        while (iter.hasNext()) {
            next = iter.next();
            tmp.append(next);
            if (!iter.hasNext()) continue;
            tmp.append(',');
        }
        tmp.append('}');
        tmp.append("PrivateCredentials{count=");
        tmp.append(this.privateCredentials.size());
        tmp.append('}');
        tmp.append(')');
        return tmp.toString();
    }

    private static class ProtectedSet
    extends AbstractSet
    implements Serializable {
        private HashSet content;
        private Permission modifyPerm;
        private Subject subject;

        private ProtectedSet(Subject subject, Set s, Permission modifyPerm) {
            this(subject, s, modifyPerm, (Class)null);
        }

        private ProtectedSet(Subject subject, Set s, Permission modifyPerm, Class filterClass) {
            this.subject = subject;
            this.modifyPerm = modifyPerm;
            if (s != null) {
                if (filterClass != null) {
                    this.content = new HashSet();
                    Iterator iter = s.iterator();
                    while (iter.hasNext()) {
                        Object next = iter.next();
                        if (!filterClass.isInstance(next)) continue;
                        this.content.add(next);
                    }
                } else {
                    this.content = new HashSet(s);
                }
            } else {
                this.content = new HashSet(3);
            }
        }

        public synchronized boolean add(Object obj) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("Subject is read-only");
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(this.modifyPerm);
            }
            if (this.modifyPerm == MOD_PRINCIPALS_PERM && !(obj instanceof Principal)) {
                throw new IllegalArgumentException("Only Principals may be added to the PrinpalsSet");
            }
            return this.content.add(obj);
        }

        public synchronized boolean remove(Object obj) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("Subject is read-only");
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(this.modifyPerm);
            }
            return this.content.remove(obj);
        }

        public Iterator iterator() {
            final Iterator iterator = this.content.iterator();
            return new Iterator(){

                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public Object next() {
                    Object next = iterator.next();
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null && modifyPerm == MOD_PRIVATE_CREDS_PERM) {
                        String name = next.getClass().getName() + " * *";
                        PrivateCredentialPermission pcp = new PrivateCredentialPermission(name, "read");
                        sm.checkPermission(pcp);
                    }
                    return next;
                }

                public void remove() {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkPermission(modifyPerm);
                    }
                    iterator.remove();
                }
            };
        }

        public int size() {
            return this.content.size();
        }
    }
}

