/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.security.auth.login.XMLLoginConfigImpl;

public abstract class Configuration {
    public static final AuthPermission GET_CONFIG_PERM = new AuthPermission("getLoginConfiguration");
    public static final AuthPermission SET_CONFIG_PERM = new AuthPermission("setLoginConfiguration");
    private static Configuration theConfiguration;

    public static synchronized Configuration getConfiguration() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONFIG_PERM);
        }
        if (theConfiguration == null) {
            theConfiguration = new XMLLoginConfigImpl();
        }
        return theConfiguration;
    }

    public static synchronized void setConfiguration(Configuration configuration) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONFIG_PERM);
        }
        theConfiguration = configuration;
    }

    protected Configuration() {
    }

    public abstract AppConfigurationEntry[] getAppConfigurationEntry(String var1);

    public abstract void refresh();
}

